/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 *  gen_deskey.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "key.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

int gen_deskey(alg, dummy1, key, dummy2)
int alg;		/* internal algorithm code */
int dummy1;		/* ignored */
struct key **key;	/* secret key */
struct key **dummy2;	/* ignored */
{
    int r = OK;
    struct bbuf *keybb = NULLBB;
    struct bbuf *keybb2 = NULLBB;
    struct bbuf *ivbb = NULLBB;
    struct bbuf *tmpbb = NULLBB;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (key == (struct key **)0) 
	return(NOTOK);

    FREE_KEY(*key);

    /* Allocate space for key algid */
    if (alloc_key(key) != OK
	|| ((*key)->algid = alloc_algid()) == NULL_ALGID) {
	r = NOTOK;
	goto cleanup;
    }

    /* Default to DES CBC algorithm if generic DES specified */
    if (alg == DES) alg = DES_CBC;
	
    switch (alg) {
    case DES_ECB:
	if ((keybb = pseudorandom(DESKEYLEN)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
	(void) setparity(keybb);
	break;

    case DES_CBC:
	if ((keybb = pseudorandom(DESKEYLEN)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
	(void) setparity(keybb);
	if ((ivbb = pseudorandom(DESIVLEN)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
	break;

    case DES_EDE:
	if ((keybb = pseudorandom(DESKEYLEN)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
	if ((keybb2 = pseudorandom(DESKEYLEN)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
	}
	tmpbb = dup_bbuf(keybb);
	FREE_BBUF(keybb);
	keybb = bbufcat(tmpbb, keybb2);
	(void) setparity(keybb);
	break;

    default:
	goto cleanup;
    }

    (*key)->algid->alg = alg;
    if ((r = encode_deskeyparms(ivbb, &((*key)->algid->parms))) != OK)
	goto cleanup;
    if ((r = encode_deskeydata(keybb, &((*key)->data))) != OK)
	goto cleanup;

    r = OK;

 cleanup:

    FREE_BBUF(ivbb);
    FREE_BBUF(keybb);
    FREE_BBUF(keybb2);
    FREE_BBUF(tmpbb);
    if (r != OK)
	FREE_KEY(*key);
    return(r);
}

/****************************************************************************/
