/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * set_key.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "util.h"

/* GLOBAL CURRENT KEY VARIABLES */
int curalg = -1;
struct bbuf *curparms = NULLBB;
struct bbuf *curdata = NULLBB;

int set_key(key)
struct bbuf *key;
{
    struct key *dkey = NULL_KEY;
    int ret = NOTOK;

    /* DOUBLE-CHECK KEY PARAMETER */
    if (key == NULLBB) 
	return(NOTOK);

    if (decode_key(key, &dkey) != OK)
        goto cleanup;

    /* MAKE SURE KEY IS COMPLETE */
    if (dkey == NULL_KEY || dkey->algid == NULL_ALGID
	|| dkey->data == NULLBB) 
	goto cleanup;

    /* FREE CURRENT KEY DATA AND PARAMETERS */
    FREE_BBUF(curparms);
    FREE_BBUF(curdata);

    /* SET NEW KEY DATA AND PARAMETERS */
    curalg = dkey->algid->alg;
    curparms = dup_bbuf(dkey->algid->parms);
    curdata = dup_bbuf(dkey->data);

    ret = OK;

 cleanup:

    FREE_KEY(dkey);
    return(ret);
}

/*****************************************************************************/
