/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "new.h"
#include "util.h"

/****************************************************************************
 * seedbyscript()
 ****************************************************************************/

struct bbuf *seedbyscript() 
{
    struct bbuf *newseed = NULLBB;
    FILE *fp = (FILE *)0;
    char **av;
    struct algent *ae = NULL_ALGENT;

    /* Generate seed by hashing unpredictable text from script */

    if ((av = tag_user(user_tailor, "randproc")) == NULLVP)
	goto cleanup;
    if ((fp = popen(*(av+1), "r")) == (FILE *)0)
	goto cleanup;
  
    if (fgetc(fp) == EOF)
	goto cleanup;

    if ((av = tag_user(user_tailor, "hash-alg")) == NULLVP)
	goto cleanup;
    if ((ae = getalgstr(algorithms, *(av+1), HASH)) == NULL_ALGENT)
	goto cleanup;

    if (fgen_mic(ae->code, NULLBB, fp, &newseed) != OK)
	goto cleanup;

 cleanup:

    if (fp != (FILE *)0)
	(void) pclose(fp);

    return(newseed);
}


/****************************************************************************
 * pseudorandom()
 ****************************************************************************/

struct bbuf *pseudorandom(length)
int length;
{
    static struct bbuf *randbb = NULLBB;
    static int randleft = 0;

    int i;
    struct bbuf *ranbytes = NULLBB;
    struct bbuf *retbytes = NULLBB;

    /* for each byte requested */

    for (i = 0; i < length; i++) {

	/*  If we haven't initialized */

	if (seedbb == NULLBB) {

	    /* seed using the script.  If the signature method can safely
	       be used, it must be called external to this routine.
	       */

	    if ((seedbb = seedbyscript()) == NULLBB)
		goto cleanup;
	}

	if (!randleft) {
	    struct algent *ae = NULL_ALGENT;
	    char **av;

	    /*  Increment the seed value */

	    bbufinc(seedbb);
	    
	    /*  Hash the seed to get the new set of random values  */

	    if ((av = tag_user(user_tailor, "hash-alg")) == NULLVP)
		goto cleanup;
	    if ((ae = getalgstr(algorithms, *(av+1), HASH)) == NULL_ALGENT)
		goto cleanup;

	    if (gen_mic(ae->code, NULLBB, seedbb, &randbb) != OK)
		goto cleanup;

	    randleft = randbb->length;
	}

	/*  Allocate a bbuf for the returned random data  */

	if (ranbytes == NULLBB) {

	    ranbytes = alloc_bbuf();
	    ranbytes -> length = length;
	    ranbytes -> data = alloc_uchar(length);
	}
	
        ranbytes->data[i] = randbb->data[--randleft];
    
    }

    retbytes = ranbytes;
    ranbytes = NULLBB;

 cleanup:

    FREE_BBUF(ranbytes);
    return(retbytes);
}


/***************************************************************************/
