/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/* given a user record, return a string that can be used with an
 * originator-id or recipient-id header
 */

#include "general.h"

#include "bbuf.h"
#include "dname.h"
#include "new.h"
#include "util.h"

char *id_user(user, need_pk, need_other)
char **user;
int need_pk;
int need_other;
{
    char *retid = NULLCP;
    char *id = NULLCP;
    char *nf = NULLCP;
    char *pubkey = NULLCP;
    char **av1 = NULLVP;
    char **av2 = NULLVP;
    struct bbuf *dn = NULLBB;
    struct bbuf *encdn = NULLBB;

    if (need_pk) {
	if ((pubkey = key_user(user)) != NULLCP) {
	    id = add2cp(id, "PK,");
	    id = add2cp(id, pubkey);
	}
	else
	    goto cleanup;
    }

    if ((av1 = tag_user(user, "id-en")) != NULLVP &&
	     (av2 = tag_user(user, "id-en-keyid")) != NULLVP) {
	nf = add2cp(nf, "EN,");
	nf = add2cp(nf, *(av2+1));
	nf = add2cp(nf, ",");
	nf = add2cp(nf, *(av1+1));
    }
    else if ((av1 = tag_user(user, "id-str")) != NULLVP &&
	     (av2 = tag_user(user, "id-str-keyid")) != NULLVP) {
	nf = add2cp(nf, "STR,");
	nf = add2cp(nf, *(av2+1));
	nf = add2cp(nf, ",");
	nf = add2cp(nf, *(av1+1));
    }
    else if ((av1 = tag_user(user, "id-dn")) != NULLVP &&
	     (av2 = tag_user(user, "id-dn-keyid")) != NULLVP) {
	nf = add2cp(nf, "DN,");
	nf = add2cp(nf, *(av2+1));
	nf = add2cp(nf, ",");
	nf = add2cp(nf, *(av1+1));
    }
    else if ((av1 = tag_user(user, "id-pgp")) != NULLVP &&
	     (av2 = tag_user(user, "id-pgp-keyid")) != NULLVP) {
	nf = add2cp(nf, "PGP2,");
	nf = add2cp(nf, *(av2+1));
	nf = add2cp(nf, ",");
	nf = add2cp(nf, *(av1+1));
    }
    else if (!need_pk && (av1 = tag_user(user, "issuer-name")) != NULLVP && 
	(av2 = tag_user(user, "serial-number")) != NULLVP) {
	nf = add2cp(nf, "IS,");
	if ((dn = str2dn(*(av1+1))) == NULLBB)
	    goto cleanup;
	if (bencode(dn, &encdn) != OK) 
	    goto cleanup;
	nf = add2cp(nf, (char *) encdn->data);
	nf = add2cp(nf, ",");
	nf = add2cp(nf, *(av2+1));
    }
    else if (need_other) {
	FREE(id);
	goto cleanup;
    }

    if (id != NULLCP && nf != NULLCP) 
	id = add2cp(id, ",");

    if (nf !=  NULLCP) 
	id = add2cp(id, nf);

    if (id == NULLCP) {
	if ((pubkey = key_user(user)) != NULLCP) {
	    id = add2cp(id, "PK,");
	    id = add2cp(id, pubkey);
	}
	else
	    goto cleanup;
    }

    retid = id;
    id = NULLCP;

 cleanup:
    
    FREE(nf);
    FREE(id);
    FREE_BBUF(dn);
    FREE_BBUF(encdn);

    return retid;
}
