/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "new.h"
#include "util.h"

char *pw_file()
{
    char       **tv = NULLVP;
    char	*file = NULLCP;
    char	 buf[128];	/* hard to believe this could be too small */

    if ((tv = tag_user(user_tailor, "pwdir")) == NULLVP)
	return NULLCP;

    if ((file = add2cp(NULLCP, *(tv+1))) == NULLCP)
	return NULLCP;

    if ((file = add2cp(file, "/pw")) == NULLCP)
        return NULLCP;

    (void) sprintf(buf, "%d", getuid());

    if ((file = add2cp(file, buf)) == NULLCP)
	return NULLCP;

    return(file);
}

char *tailor_file()
{
    char	*file = NULLCP;

    if ((file = getenv("HOME")) == NULLCP)
	return NULLCP;

    if (((file = add2cp(NULLCP, file)) == NULLCP)
	|| ((file = add2cp(file, "/")) == NULLCP)
	|| ((file = add2cp(file, TAILORFILE)) == NULLCP))
	return NULLCP;

    return(file);
}

char *tmp_file(prefix)
char *prefix;
{
    char       **tv = NULLVP;
    char	*file = NULLCP;

    /* NULL prefix is OK, designated by NULLCP */

    if ((tv = tag_user(user_tailor, "tmpdir")) == NULLVP)
	return NULLCP;

    if ((file = add2cp(NULLCP, *(tv+1))) == NULLCP)
        return NULLCP;

    if (prefix == NULLCP) {
	if ((file = add2cp(file, "/XXXXXX")) == NULLCP)
	    return NULLCP;
	(void) mktemp(file);
    }
    else {
	if ((file = add2cp(file, "/")) == NULLCP)
	    return NULLCP;
	if ((file = add2cp(file, prefix)) == NULLCP)
	    return NULLCP;
	if ((file = add2cp(file, "XXXXXX")) == NULLCP)
	    return NULLCP;
	(void) mktemp(file);
    }

    return(file);
}
