/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

avacmp(ava1, ava2)
struct bbuf *ava1, *ava2;
{
    struct bbuf *cava1= NULLBB, *cava2= NULLBB;
    struct bbuf *val1= NULLBB, *val2= NULLBB;
    OID oid1= NULLOID, oid2= NULLOID;
    int ret= NOTOK;

    if (ava1 == NULLBB)
	return(ava2 == NULLBB ? 0 : -1);

    if ((decode_ava(ava1, &oid1, &val1) != OK) ||
        (decode_ava(ava2, &oid2, &val2) != OK)) 
	goto cleanup;

    /* compare encoded oid's */
    if (ret = oid_cmp(oid1, oid2))
	goto cleanup;

 cleanup:

    FREE_BBUF(val1);
    FREE_BBUF(val2);
    FREE_BBUF(cava1);
    FREE_BBUF(cava2);
    FREE_OID(oid1);
    FREE_OID(oid2);

    return(ret);
}
