/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "x500.h"
#include "util.h"

static _read_avas();
static _write_avas(); 

avas_rdn(rdn, avas, mode)
struct bbuf *rdn;
struct bbuf **avas;
int mode;
{
    if (rdn == NULLBB) 
	return(NOTOK);

    if (avas == (struct bbuf **)0) 
	return(NOTOK);

    switch (mode) {
    case READ:
	return(_read_avas(rdn, avas));

    case WRITE:
	FREE_UCHAR(rdn->data);
	rdn->length = 0;
	if (*avas == NULLBB) 
	    return(OK);
	else
	    return(_write_avas(rdn, *avas));

    case APPEND:
	if (*avas == NULLBB) 
	    return(OK);
	else
	    return(_write_avas(rdn, *avas));

    default:
	return(NOTOK);
    }
}


static _read_avas(rdn, list)
struct bbuf *rdn;
struct bbuf  **list;
{
    int ret = NOTOK, pos = 0;

    /* Parse out individual ava's */
    if ((asn_extract(rdn, list, &pos) & TAG_MASK) != CONS_SET ||
        asn_parse(rdn, list) != OK) 
        goto cleanup;

    ret = OK;

 cleanup:

    return(ret);
}


static _write_avas(bbuf, list)
struct bbuf *bbuf;
struct bbuf  *list;
{
    struct bbuf *ptr = NULLBB, *tagbb = NULLBB,
		*lenbb = NULLBB, *retbb = NULLBB,
		*avas = NULLBB, *tmp = NULLBB;
    int 	ret = NOTOK;

    /* parse existing avas if they exist */
    if (asn_parse(bbuf, &avas) != OK)
	goto cleanup;

    /* Find end of list and check for duplicates */
    if (avas != NULLBB && avas->length != 0) {
	for (tmp = avas; tmp->next != NULLBB; tmp = tmp->next) 
	    if (!avacmp(bbuf, tmp)) 
	        goto cleanup;

	if (!avacmp(bbuf, tmp)) 
	    goto cleanup;

    }

    for (ptr = list; ptr != NULLBB; ptr = ptr->next) 
	if (tmp == NULLBB) {
	    if ((tmp=dup_bbuf(ptr)) == NULLBB)
	        goto cleanup;
	    avas = tmp;
	}
	else {
	    if ((tmp->next=dup_bbuf(ptr)) == NULLBB)
	        goto cleanup;
	    tmp = tmp->next;
	}

    for (ptr = avas; ptr != NULLBB; ptr = ptr->next) {
	retbb = bbufcat(tmp=retbb, ptr);
	FREE_BBUF(tmp);
    }

    if (encode_len(retbb->length, &lenbb) != OK)
        goto cleanup;
    if (encode_tag(CLASS_UNIV|FORM_CONS|CONS_SET, &tagbb) != OK)
	goto cleanup;

    retbb = bbufcat(lenbb, tmp=retbb);
    FREE_BBUF(tmp);
    retbb = bbufcat(tagbb, tmp=retbb);
    FREE_BBUF(tmp);

    FREE_UCHAR(bbuf->data);
    bbuf->data = retbb->data;
    retbb->data = NULLUCP;
    bbuf->length = retbb->length;

    ret = OK;

 cleanup:
    FREE_BBUF(lenbb);
    FREE_BBUF(tagbb);
    FREE_BBUF(retbb);
    FREE_BBUFS(avas);

    return(ret);
}
