/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

struct bbuf *bbufcat(bbuf1, bbuf2)
struct bbuf *bbuf1, *bbuf2;
{
    struct bbuf *ret= NULLBB;

    if ((bbuf1 == NULLBB) && (bbuf2 == NULLBB))
	goto cleanup;

    if (bbuf1 == NULLBB) {
	ret = dup_bbuf(bbuf2);
	goto cleanup;
    }
    if (bbuf2 == NULLBB) {
	ret = dup_bbuf(bbuf1);
	goto cleanup;
    }

    ret = alloc_bbuf();
    if (bbuf1->length + bbuf2->length)
	ret->data = alloc_uchar(bbuf1->length + bbuf2->length);

    ret->length = bbuf1->length + bbuf2->length;
    
    BCOPY(bbuf1->data, ret->data, bbuf1->length);
    BCOPY(bbuf2->data, &(ret->data[bbuf1->length]), bbuf2->length);

 cleanup:

    return(ret);
}
