/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

free_bbufs(bbufs)
struct bbuf *bbufs;
{
    struct bbuf *bbuf = NULLBB, *next = NULLBB;

    if (bbufs == NULLBB)
	return(OK);

    for (bbuf = bbufs; bbuf != NULLBB; bbuf = next) {
	next = bbuf -> next;
	FREE_BBUF(bbuf);
    }

    return(OK);
}

free_bbuf(bbuf)
struct bbuf *bbuf;
{
    if (bbuf == NULLBB)
	return(OK);

    FREE_UCHAR(bbuf -> data);

    free((char *)bbuf);
    return(OK);
}
