/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <sys/stat.h>
#include "general.h"

#include "bbuf.h"
#include "util.h"

read_bbuf(fd, bbuf)
int		fd;
struct bbuf	**bbuf;
{
    int    retval= NOTOK;

    if (fd < 0 || bbuf == (struct bbuf **)0) 
	goto cleanup;

    FREE_BBUF(*bbuf);

    *bbuf = alloc_bbuf();

    if (read(fd, (char *)&((*bbuf)->length), sizeof((*bbuf)->length))
	!= sizeof((*bbuf)->length)) 
	goto cleanup;

    BSWAP((*bbuf)->length);
    if ((*bbuf)->length > 0)
	(*bbuf)->data = alloc_uchar((*bbuf)->length+1);

    if ((*bbuf)->length > 0
	&& read(fd, (char *)(*bbuf)->data, (*bbuf)->length)
	!= (*bbuf)->length) 
	goto cleanup;

    retval = OK;

 cleanup:

    if (retval != OK)
	FREE_BBUF(*bbuf);

    return(retval);
}
