/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "new.h"
#include "util.h"

main (argc, argv)
int argc;
char **argv;
{
    int ret = NOTOK;
    char **localopts = NULLVP;
    char **countopt = NULLVP;
    char **sigopt = NULLVP;
    char **user = NULLVP;
    struct bbuf *bb = NULLBB;
    int count, i, j;

    
    /* check args, display help */

    if (pem_init(argc, argv, &localopts) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    if (argc < 2 || !strcasecmp (argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s byte-count <count>\n",  myname);
	goto cleanup;
    }

    if ((countopt = tag_user(localopts, "byte-count")) == NULLVP) {
	(void) fprintf(stderr, "%s: byte-count not specified\n", myname);
        goto cleanup;
    }

    count = atoi(*(countopt+1));

    if ((sigopt = tag_user(user_tailor, "sig-alias")) == NULLVP)
	(void) fprintf(stderr, "%s: no sig-alias defined\n", myname);
    else if ((user = get_tv_user("alias", *(sigopt+1))) == NULLVP)
	(void) fprintf(stderr, "%s: unable to find sig-alias user %s\n", 
		       myname, *(sigopt+1));

    (void) fprintf(stderr, "Initializing with ");
    if (user == NULLVP)
	(void) fprintf(stderr, "shell script (slow)");
    else
	(void) fprintf(stderr, "signature (fast) from %s", *(sigopt+1));
    (void) fprintf(stderr, " and generating %d bytes.\n", count);
    
    if (initprng(user) != OK) {
       (void) fprintf(stderr, "%s: unable to initialize prng.\n", myname);
        goto cleanup;
    }

    for (i = 0; i < count; i+= i + BUFSIZ < count ? BUFSIZ : count - i) {
	if ((bb = pseudorandom(i + BUFSIZ < count ? BUFSIZ : count - i))
	    == NULLBB) {
	    (void) fprintf(stderr, "%s: prng failed at byte %d.\n", myname, i);
	    goto cleanup;
	}
	for (j = 0; j < bb->length; j++)
	    putchar (bb->data[j]);
	FREE_BBUF(bb);
    }

    ret = OK;

 cleanup:

    return ret;
}
