/***************************************************************************
 * Copyright 1998 International Business Machines Corporation. All Rights
 * Reserved.
 *
 * Please read this carefully.  Your use of this reference implementation of
 * certain of the IETF public-key infrastructure specifications ("Software")
 * indicates your acceptance of the following.  If you do not agree to the
 * following, do not install or use any of the Software.
 *
 * Permission to use, reproduce, distribute and create derivative works from
 * the Software ("Software Derivative Works"), and to distribute such Software
 * Derivative Works is hereby granted to you by International Business
 * Machines Corporation ("IBM").  This permission includes a license under the
 * patents of IBM that are necessarily infringed by your use of the Software
 * as provided by IBM.
 *
 * IBM licenses the Software to you on an "AS IS" basis, without warranty of
 * any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES OR CONDITIONS,
 * EITHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, NON INFRINGEMENT AND FITNESS
 * FOR A PARTICULAR PURPOSE.  You are solely responsible for determining the
 * appropriateness of using this Software and assume all risks associated with
 * the use of this Software, including but not limited to the risks of program
 * errors, damage to or loss of data, programs or equipment, and
 * unavailability or interruption of operations.
 *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL,
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC CONSEQUENTIAL DAMAGES
 * (INCLUDING LOST PROFITS OR SAVINGS), EVEN IF IBM HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.  IBM will not be liable for the loss of, or
 * damage to, your records or data, or any damages claimed by you based on a
 * third party claim.
 *
 * IBM wishes to obtain your feedback to assist in improving the Software. You
 * grant IBM a world-wide, royalty-free right to use, copy, distribute,
 * sublicense and prepare derivative works based upon any feedback, including
 * materials, error corrections, Software Derivatives, enhancements,
 * suggestions and the like that you provide to IBM relating to the Software
 * (this does not include products for which you charge a royalty and
 * distribute to IBM under other terms and conditions).
 *
 * You agree to distribute the Software and any Software Derivatives under a
 * license agreement that: 1) is sufficient to notify all licensees of the
 * Software and Software Derivatives that IBM assumes no liability for any
 * claim that may arise regarding the Software or Software Derivatives, and 2)
 * that disclaims all warranties, both express and implied, from IBM regarding
 * the Software and Software Derivatives.  (If you include this Agreement with
 * any distribution of the Software or Software Derivatives you will have met
 * this requirement.)  You agree that you will not delete any copyright
 * notices in the Software.
 *
 * This Agreement is the exclusive statement of your rights in the Software as
 * provided by IBM.   Except for the rights granted to you in the second
 * paragraph above, You are not granted any other patent rights, including but
 * not limited to the right to make combinations of the Software with products
 * that infringe IBM patents. You agree to comply with all applicable laws and
 * regulations, including all export and import laws and regulation.  This
 * Agreement is governed by the laws of the State of New York.  This Agreement
 * supersedes all other communications, understandings or agreements we may
 * have had prior to this Agreement.
 ****************************************************************************/


//------------------------------------------------------------
// include
//------------------------------------------------------------

#include <iomanip.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "cssm.h"
#include "cssmutility.h"


//********************************************************************************
//
// memory management
//
//********************************************************************************


//------------------------------------------------------------
// function: DefaultMalloc
//------------------------------------------------------------

void*
DefaultMalloc(uint32 size,
              void* allocRef)
{
   return malloc(size);
}


//------------------------------------------------------------
// function: DefaultFree
//------------------------------------------------------------

void
DefaultFree(void* memPtr,
            void* allocRef)
{
   free(memPtr);
}


//------------------------------------------------------------
// function: DefaultRealloc
//------------------------------------------------------------

void*
DefaultRealloc(void* memPtr,
               uint32 size,
               void* allocRef)
{
   return realloc(memPtr, size);
}


//------------------------------------------------------------
// function: DefaultCalloc
//------------------------------------------------------------

void*
DefaultCalloc(uint32 num,
              uint32 size,
              void* allocRef)
{
   return calloc(num, size);
}


//********************************************************************************
//
// CSSM utility
//
//********************************************************************************


//------------------------------------------------------------
// function: DumpData
//------------------------------------------------------------

void
DumpData(ostream& os,
         CSSM_DATA& data)
{
   uint32 i;
   char originalFill = os.fill('0');
   os.setf(ios::hex, ios::basefield);
   for (i = 0; i < data.Length; i++)
   {
      if (i == 0) os << "0x";
      os << setw(2) << (int)data.Data[i];
   }
   os.fill(originalFill);
   os.unsetf(ios::hex);
}


//------------------------------------------------------------
// function: DumpData
//------------------------------------------------------------

void
DumpData(ostream& os,
         CSSM_BOOL& data)
{
   if (CSSM_TRUE == data)
      os << "TRUE";
   else
      os << "FALSE";
}


//------------------------------------------------------------
// function: ThrowCSSMException
//------------------------------------------------------------

void
ThrowCSSMException(uint32 errcode)
{
   static char msg[64];

   sprintf(msg, "CSSM_ERROR_CODE = %lu", errcode);

   throw msg;
}


//------------------------------------------------------------
// function: InitializeCSSM
//------------------------------------------------------------

void
InitializeCSSM(void)
{
   CSSM_VERSION version = { CSSM_MAJOR, CSSM_MINOR };
   CSSM_MEMORY_FUNCS memoryFuncs = { DefaultMalloc, DefaultFree, DefaultRealloc, DefaultCalloc, NULL };

   if (CSSM_FAIL == CSSM_Init(&version, &memoryFuncs, NULL))
      ThrowCSSMException(CSSM_GetError()->error);
}


//------------------------------------------------------------
// function: AttachCSP
//------------------------------------------------------------

#define ADDIN_BUG 1

CSSM_CSP_HANDLE
AttachCSP(const CSSM_GUID& selectedGUID)
{
#ifdef ADDIN_BUG
   CSSM_LIST* moduleListPtr = CSSM_ListModules(CSSM_SERVICE_CSP, CSSM_FALSE);
   if (!moduleListPtr)
      ThrowCSSMException(CSSM_GetError()->error);

   // assume there is only one CSP addin module installed
   CSSM_VERSION			CspVersion = {1, 0};

   CSSM_CSP_HANDLE cspHandle;
   CSSM_API_MEMORY_FUNCS memoryFuncs = { DefaultMalloc, DefaultFree, DefaultRealloc, DefaultCalloc, NULL };
   cspHandle = CSSM_ModuleAttach((CSSM_GUID*)&selectedGUID,
                                 &CspVersion,
                                 &memoryFuncs,
                                 0,
                                 0,
                                 0,
                                 NULL,
                                 NULL);
   if (!cspHandle)
      ThrowCSSMException(CSSM_GetError()->error);
   if (CSSM_FreeList(moduleListPtr) == CSSM_FAIL)
      ThrowCSSMException(CSSM_GetError()->error);

   return cspHandle;
#else
   CSSM_LIST* moduleListPtr = CSSM_ListModules(CSSM_SERVICE_CSP, CSSM_FALSE);
   if (!moduleListPtr)
      ThrowCSSMException(CSSM_GetError()->error);

   // assume there is only one CSP addin module installed
   CSSM_MODULE_INFO* moduleInfoPtr = CSSM_GetModuleInfo(&selectedGUID,
                                                        CSSM_SERVICE_CSP,
                                                        CSSM_ALL_SUBSERVICES,
                                                        CSSM_INFO_LEVEL_ALL_ATTR);
   if (!moduleInfoPtr)
      ThrowCSSMException(CSSM_GetError()->error);

   CSSM_CSP_HANDLE cspHandle;
   CSSM_API_MEMORY_FUNCS memoryFuncs = { DefaultMalloc, DefaultFree, DefaultRealloc, DefaultCalloc, NULL };

   cspHandle = CSSM_ModuleAttach(&selectedGUID,
                                 &moduleInfoPtr->Version,
                                 &memoryFuncs,
                                 0,
                                 0,
                                 0,
                                 NULL,
                                 NULL);
   if (!cspHandle)
      ThrowCSSMException(CSSM_GetError()->error);
   if (CSSM_FreeModuleInfo(moduleInfoPtr) == CSSM_FAIL)
       ThrowCSSMException(CSSM_GetError()->error);
   if (CSSM_FreeList(moduleListPtr) == CSSM_FAIL)
      ThrowCSSMException(CSSM_GetError()->error);

   return cspHandle;
#endif
}


//------------------------------------------------------------
// function: AttachTP
//------------------------------------------------------------

CSSM_TP_HANDLE
AttachTP(const CSSM_GUID& selectedGUID)
{
   CSSM_LIST* moduleListPtr = CSSM_ListModules(CSSM_SERVICE_TP, CSSM_FALSE);
   if (!moduleListPtr)
      ThrowCSSMException(CSSM_GetError()->error);

   CSSM_MODULE_INFO* moduleInfoPtr = CSSM_GetModuleInfo((CSSM_GUID*)&selectedGUID,
                                                        CSSM_SERVICE_TP,
                                                        CSSM_ALL_SUBSERVICES,
                                                        CSSM_INFO_LEVEL_ALL_ATTR);
   if (!moduleInfoPtr)
      ThrowCSSMException(CSSM_GetError()->error);

   CSSM_TP_HANDLE tpHandle;
   CSSM_API_MEMORY_FUNCS memoryFuncs = { DefaultMalloc, DefaultFree, DefaultRealloc, DefaultCalloc, NULL };

   tpHandle = CSSM_ModuleAttach((CSSM_GUID*)&selectedGUID,
                                &moduleInfoPtr->Version,
                                &memoryFuncs,
                                0,
                                0,
                                0,
                                NULL,
                                NULL);
   if (!tpHandle)
      ThrowCSSMException(CSSM_GetError()->error);

   if (CSSM_FreeModuleInfo(moduleInfoPtr) == CSSM_FAIL)
       ThrowCSSMException(CSSM_GetError()->error);

   if (CSSM_FreeList(moduleListPtr) == CSSM_FAIL)
      ThrowCSSMException(CSSM_GetError()->error);

   return tpHandle;
}
