/* SCCSID: fwk/cssm/tpapi.c, dss_cdsa_fwk, fwk_rel2, dss_980302 1.17 3/2/98 20:54:42 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*-----------------------------------------------------------------------
 *      File:   TPAPI.C
 *
 * This file contains the functions that are contained in the TPI portion
 * of the CSSM exported functions.
 */
/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */
/*
 * WARNING: EXPORT RESTRICTED.
 * This software listing contains cryptographic methods and technology.
 * It is export restricted by the Office of Defense Trade Controls, United
 * States Department of State and cannot be downloaded or otherwise
 * exported or re-exported (i) into (or to a national or resident of) Cuba,
 * Iraq, Libya, Yugoslavia, North Korea, Iran, Syria or any other country
 * to which the US has embargoed goods; or (ii) to anyone on the US
 * Treasury Department's list of Specially Designated Nationals or the US
 * Commerce Department's Table of Denial Orders. By downloading or using
 * this product, you are agreeing to the foregoing and you are representing
 * and warranting that you are not located in, under the control of, or a
 * national or resident of any such country or on any such list.
 */

#include "cssm.h"
#include "cssmport.h"
#include "internal.h"
#include "cssmtpi.h"
#include "addin.h"

/* Returns the signed certificate */
/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CertSign
 *
 *Description:
 *   Exported function for TP module to sign a certificate
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   CCHandle - CC handle
 *   UnsignedCert - unsigned certificate
 *   SignerCert - signer certificate
 *   SignScope - data that identifies the fields to sign
 *   ScopeSize - number of items in sign scope
 *
 *Returns:
 *  NULL - unable to sign certificate
 *  non NULL - pointer to signed certificate
 *
 *----------------------------------------------------------------*/
CSSM_DATA_PTR CSSMAPI CSSM_TP_CertSign(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CC_HANDLE    CCHandle,
    const CSSM_DL_DB_LIST_PTR DBList,
    const CSSM_DATA_PTR CertToBeSigned,
    const CSSM_CERTGROUP_PTR SignerCertGroup,
    const CSSM_FIELD_PTR SignScope,
    uint32 ScopeSize)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_DATA_PTR Data = NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle (TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(NULL);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CertSign))
		Data = CallBack->CertSign (TPHandle,
		CLHandle,
		CCHandle,
		DBList,
		CertToBeSigned,
		SignerCertGroup,
		SignScope,
		ScopeSize);
	else {
		Data = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			Data = NULL;
		}
    }

    return(Data);
};

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CertRevoke
 *
 *Description:
 *   Exported function for TP module to revoke a certificate
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   CCHandle - CC handle
 *   OldCrl - pointer to existing crl
 *   SubjectCert - certificate to revoke
 *   RevokerCert - CA certificate
 *   Reason - reason for revoking certificate
 *
 *Returns:
 *  NULL - unable to revoke certificate
 *  non NULL - pointer to new crl with certificate revoked
 *
 *----------------------------------------------------------------*/
CSSM_DATA_PTR CSSMAPI CSSM_TP_CertRevoke(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CC_HANDLE CCHandle,
    const CSSM_DL_DB_LIST_PTR DBList,
    const CSSM_DATA_PTR OldCrl,
    const CSSM_CERTGROUP_PTR CertGroupToBeRevoked,
    const CSSM_CERTGROUP_PTR RevokerCertGroup,
    CSSM_REVOKE_REASON Reason)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_DATA_PTR Data = NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle(TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(NULL);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CertRevoke)){
		Data = CallBack->CertRevoke (TPHandle,
			CLHandle,
			CCHandle,
			DBList,
			OldCrl,
			CertGroupToBeRevoked,
			RevokerCertGroup,
			Reason);
	} else {
		Data = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			Data = NULL;
		}
    }

    return(Data);
};

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CrlVerify
 *
 *Description:
 *   Exported function for TP module to verify a crl
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   CCHandle - CC handle
 *   SubjectCrl - pointer to crl
 *   SignerCert - CA certificate useed to sign crl
 *   VerifyScope - data that identifies the verification scope
 *   ScopeSize - number of items in verification scope
 *
 *Returns:
 *  CSSM_FALSE - unable to verify crl signature
 *  CSSM_TRUE - crl signature is verified
 *
 *----------------------------------------------------------------*/
CSSM_BOOL CSSMAPI CSSM_TP_CrlVerify(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CSP_HANDLE CSPHandle,
    const CSSM_DL_DB_LIST_PTR DBList,
    const CSSM_DATA_PTR CrlToBeVerified,
    const CSSM_CERTGROUP_PTR SignerCertGroup,
    const CSSM_FIELD_PTR VerifyScope,
    uint32 ScopeSize)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_BOOL ret = CSSM_FALSE;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle(TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(ret);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(ret);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CrlVerify)){
		ret = CallBack->CrlVerify (TPHandle,
			CLHandle,
			CSPHandle,
			DBList,
			CrlToBeVerified,
			SignerCertGroup,
			VerifyScope,
			ScopeSize);
	} else {
		ret = CSSM_FALSE;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// cssm error is set
			ret = CSSM_FALSE;
		}
    }

    return(ret);
};

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CrlSign
 *
 *Description:
 *   Exported function for TP module signing the crl
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   CCHandle - CC handle
 *   SubjectCrl - unsigned crl
 *   SignerCert - signer certificate
 *   SignScope - data that identifies the fields to sign
 *   ScopeSize - number of items in sign scope
 *
 *Returns:
 *  NULL - unable to sign crl
 *  non NULL - pointer to signed crl
 *
 *----------------------------------------------------------------*/
CSSM_DATA_PTR CSSMAPI CSSM_TP_CrlSign(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CC_HANDLE    CCHandle,
    const CSSM_DL_DB_LIST_PTR DBList,
    const CSSM_DATA_PTR CrlToBeSigned,
    const CSSM_CERTGROUP_PTR SignerCertGroup,
    const CSSM_FIELD_PTR SignScope,
    uint32 ScopeSize)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_DATA_PTR Data = NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle (TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(NULL);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CrlSign)){
		Data = CallBack->CrlSign (TPHandle,
			CLHandle,
			CCHandle,
			DBList,
			CrlToBeSigned,
			SignerCertGroup,
			SignScope,
			ScopeSize);
	} else {
		Data = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			Data = NULL;
		}
    }

    return(Data);
};

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_ApplyCrlToDb
 *
 *Description:
 *   Exported function for TP module to apply a crl to a database.
 *   This function will mark the certificates found in the crl as
 *   revoked in the database of certificates
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   Crl - crl to be applied on database
 *
 *Returns:
 *  CSSM_FAIL - CSSM unable to update database
 *  CSSM_OK - certificate database is updated
 *
 *----------------------------------------------------------------*/
CSSM_RETURN CSSMAPI CSSM_TP_ApplyCrlToDb(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CSP_HANDLE CSPHandle,
    const CSSM_DL_DB_LIST_PTR DBList,
    const CSSM_DATA_PTR Crl)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_RETURN ret = CSSM_FAIL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle (TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(ret);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(ret);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->ApplyCrlToDb)){
		ret = CallBack->ApplyCrlToDb (TPHandle,
			CLHandle,
			CSPHandle,
			DBList,
			Crl);
	} else {
		ret = CSSM_FAIL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// cssm error is set
			ret = CSSM_FAIL;
		}
    }

    return(ret);
};

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_PassThrough
 *
 *Description:
 *   Exported function for TP module passing private functions
 *
 *Parameters:
 *   TPHandle - TP handle
 *   CLHandle - CL handle
 *   DLHandle - DL handle
 *   DBHandle - DB handle
 *   CCHandle - CC handle
 *   PassThroughId - identifier suupiled by the TP module
 *   InputParams - data associated with pass through function
 *
 *Returns:
 *  NULL - unable to complete pass through call
 *  non NULL - result from pass through call
 *
 *----------------------------------------------------------------*/
void * CSSMAPI CSSM_TP_PassThrough(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_DL_HANDLE DLHandle,
    CSSM_DB_HANDLE DBHandle,
    CSSM_CC_HANDLE CCHandle,
    uint32 PassThroughId,
    const void * InputParams)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_DATA_PTR Data = NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle (TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(NULL);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->PassThrough))
		Data = CallBack->PassThrough (TPHandle, CLHandle, DLHandle,
		DBHandle, CCHandle, PassThroughId,
		(CSSM_DATA_PTR) InputParams);
	else {
		Data = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			Data = NULL;
		}
    }

    return(Data);
}

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CertGroupConstruct
 *
 *Description:
 *   Returns the constructed cert group
 *
 *
 *Parameters:
 *   TPHandle - handle of TP module
 *   CLHandle - handle of CL module
 *   CertGroupFrag - a cert group
 *   DBList - DB of certs to use in construction of group
 *
 *Returns:
 *  Null - TP unable to construct certificate group
 *  non Null - CSSM_CERTGROUP_PTR
 *
 *----------------------------------------------------------------*/
CSSM_CERTGROUP_PTR CSSMAPI CSSM_TP_CertGroupConstruct(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
	CSSM_CSP_HANDLE	CSPHandle,
    CSSM_CERTGROUP_PTR CertGroupFrag,
    CSSM_DL_DB_LIST_PTR DBList)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_CERTGROUP_PTR CertGroup= NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle(TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(NULL);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CertGroupConstruct)) {
		CertGroup = CallBack->CertGroupConstruct (TPHandle,
			CLHandle,CSPHandle,
			CertGroupFrag, DBList);
	} else {
		CertGroup = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			CertGroup = NULL;
		}
    }

    return(CertGroup);
}

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CertGroupPrune
 *
 *Description:
 *   Returns the pruned cert group
 *
 *
 *Parameters:
 *   TPHandle - handle of TP module
 *   CLHandle - handle of CL module
 *   OrderedCertGroup - ordered cert group
 *   DBList - certs to identify level of pruning
 *
 *Returns:
 *  Null - TP unable to construct certificate group
 *  non Null - CSSM_CERTGROUP_PTR
 *
 *----------------------------------------------------------------*/

CSSM_CERTGROUP_PTR CSSMAPI CSSM_TP_CertGroupPrune(
	CSSM_TP_HANDLE TPHandle,
    CSSM_CL_HANDLE CLHandle,
    CSSM_CERTGROUP_PTR OrderedCertGroup,
    CSSM_DL_DB_LIST_PTR DBList)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_CERTGROUP_PTR CertGroup= NULL;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle(TPHandle,
						CSSM_SERVICE_TP);

	if (CallBack == NULL)
		CSSM_SetError(&cssm_GUID,CSSM_INVALID_ADDIN_HANDLE);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(NULL);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CertGroupPrune))
		CertGroup = CallBack->CertGroupPrune (TPHandle,CLHandle, OrderedCertGroup, DBList);
	else {
		CertGroup = NULL;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FALSE) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			CertGroup = NULL;
		}
    }

    return(CertGroup);

}

/*---------------------------------------------------------------
 *
 *Name: CSSM_TP_CertGroupVerify
 *
 *Description:
 *   verifies the certificates in the Oredered Certgroup
 *
 *
 *Parameters:
 *   TPHandle - handle of TP module
 *   CLHandle - handle of CL module
 *   CSPHandle - handle of CSP module
 *   CCHandle - handle of crypto context
 *   OrderedCertGroup - ordered list of certs
 *   VerifyScope - range of fields to verify
 *   ScopeSize - size of scope
 *   DBList - DB to look for issuers
 *   RootCerts - certs to terminate verify
 *
 *Returns:
 *  CSSM_TRUE - Verified the Certs in teh group
 *  CSSM_FALSE - verify failed
 *
 *----------------------------------------------------------------*/

CSSM_BOOL CSSMAPI CSSM_TP_CertGroupVerify(
	CSSM_TP_HANDLE TPHandle,
	CSSM_CL_HANDLE CLHandle,
	CSSM_DL_DB_LIST_PTR	DBList,
	CSSM_CSP_HANDLE CSPHandle,
	const CSSM_FIELD_PTR  PolicyIdentifiers,
	uint32 NumberofPolicyIdentifiers,
	CSSM_TP_STOP_ON VerificationAbortOn,
	const CSSM_CERTGROUP_PTR CertToBeVerified,
	const CSSM_DATA_PTR AnchorCerts,
	uint32 NumberofAnchorCerts,
	const CSSM_FIELD_PTR VerifyScope,
	uint32 ScopeSize,
	CSSM_TP_ACTION Action,
	const CSSM_DATA_PTR Data,
	CSSM_DATA_PTR *Evidence,
	uint32 *EvidenceSize)
{
    CSSM_SPI_TP_FUNCS_PTR CallBack = NULL;
    CSSM_BOOL Verify= CSSM_FALSE;
    CSSM_MUTEX retMutex;

    /* clear the error */

    CSSM_ClearError ();

    CallBack  = (CSSM_SPI_TP_FUNCS_PTR)cssm_GetAddInCallBackByHandle(TPHandle,
                       CSSM_SERVICE_TP);

	if (CallBack == NULL)
		return(CSSM_FALSE);

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FAIL) {
        retMutex = cssm_LockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP),CSSM_INFINITE_WAIT);
        if(retMutex != CSSM_MUTEX_LOCKED) {
            return(CSSM_FALSE);
        }
    }

    /* Make sure that function pointer is valid */
	if (!cssm_IsBadCodePtr ((CSSM_CALLBACK)CallBack->CertGroupVerify))
		Verify = CallBack->CertGroupVerify (TPHandle,
											CLHandle,
											DBList,
											CSPHandle,
											PolicyIdentifiers,
											NumberofPolicyIdentifiers,
											VerificationAbortOn,
											CertToBeVerified,
											AnchorCerts,
											NumberofAnchorCerts,
											VerifyScope,
											ScopeSize,
											Action,
											Data,
											Evidence,
											EvidenceSize);
	else {
		Verify = CSSM_FALSE;
		CSSM_SetError (&cssm_GUID, CSSM_FUNCTION_NOT_IMPLEMENTED);
	}

    if(cssm_CheckThreadSafe (TPHandle, CSSM_SERVICE_TP) == CSSM_FAIL) {
        retMutex = cssm_UnlockMutex(cssm_GetMultitaskMutexHandle (TPHandle,CSSM_SERVICE_TP));
		if (retMutex != CSSM_MUTEX_UNLOCKED) {
			// panic and dont delete
			Verify = CSSM_FALSE;
		}
    }

    return(Verify);
}
