/* @(#)38        1.9.3.22  src/export/include/ldap.h, ldap.include, ldapadt12, 980504b 4/17/98 10:46:38 */
/*
 * COMPONENT_NAME: ldap.include
 *
 * ABSTRACT:
 *
 * FUNCTIONS:
 *
 * ORIGINS: 202,27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */


/*
 *
 * Licensed Materials - Property of IBM
 * 5647-A01,5796-SS1
 * (C) Copyright IBM Corp. 1997
 *
 */
/*
 * Copyright (c) 1990 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the
 * University may not be used to endorse or promote products
 * derived from this software without specific prior written
 * permission.	This software is provided ``as is'' without express
 * or implied warranty.
 */

#ifndef _LDAP_H
#define _LDAP_H

#ifdef __OS400_HEAP_DEBUG__
#include <Qp0wHeap.H>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#include <winsock.h>
#else
#include <sys/time.h>
#endif

#include <lber.h>

#define LDAP_VERSION2	2
#define LDAP_VERSION3	3
#ifdef LDAPV3
  #define LDAP_VERSION	LDAP_VERSION3
#else
  #define LDAP_VERSION	LDAP_VERSION2
#endif

/* For compatibility w/Netscape implementation of ldap_version(). */
#define LDAP_SECURITY_NONE      0
         
#define LDAP_PORT	389
#define LDAPS_PORT	636

#define LDAP_MAX_ATTR_LEN	100

/* possible result types a server can return */
#define LDAP_RES_BIND			0x61L	/* application + constructed */
#define LDAP_RES_SEARCH_ENTRY		0x64L	/* application + constructed */
#define LDAP_RES_SEARCH_RESULT		0x65L	/* application + constructed */
#define LDAP_RES_MODIFY 		0x67L	/* application + constructed */
#define LDAP_RES_ADD			0x69L	/* application + constructed */
#define LDAP_RES_DELETE 		0x6bL	/* application + constructed */
#define LDAP_RES_MODRDN 		0x6dL	/* application + constructed */
#define LDAP_RES_COMPARE		0x6fL	/* application + constructed */
#define LDAP_RES_SEARCH_REFERENCE	0X73L	/* application + constructed */
#define LDAP_RES_EXTENDED		0X78L	/* application + constructed */
#define LDAP_EXTENDED_RES_NAME		0X8aL	/* context specific+primitive*/
#define LDAP_EXTENDED_RES_VALUE 	0X8bL	/* context specific+primitive*/
#define LDAP_RES_REFERRAL		0Xa3L	/* context specific+constructed*/
#define LDAP_RES_ANY			(-1L)

/* authentication methods available */
#define LDAP_AUTH_SIMPLE	0x80L	/* context specific + primitive   */
#define LDAP_AUTH_SASL_30	0xa3L
#define LDAP_SASL_SIMPLE	""

/* search scopes */
#define LDAP_SCOPE_BASE 	0x00
#define LDAP_SCOPE_ONELEVEL	0x01
#define LDAP_SCOPE_SUBTREE	0x02
  
/* bind constants */
#define LDAP_MECHANISM_EXTERNAL           "EXTERNAL"

/* for modifications */
typedef struct ldapmod {
	int		mod_op;
#define LDAP_MOD_ADD		0x00
#define LDAP_MOD_DELETE 	0x01
#define LDAP_MOD_REPLACE	0x02
#define LDAP_MOD_BVALUES	0x80
	char		*mod_type;
	union {
		char		**modv_strvals;
		struct berval	**modv_bvals;
	} mod_vals;
#define mod_values	mod_vals.modv_strvals
#define mod_bvalues	mod_vals.modv_bvals
	struct ldapmod	*mod_next;
} LDAPMod;

/*
 * options that can be set/gotten
 */
#define LDAP_OPT_SIZELIMIT		0x00
#define LDAP_OPT_TIMELIMIT		0x01
#define LDAP_OPT_REFERRALS		0x00000002
#define LDAP_OPT_DEREF			0x03
#define LDAP_OPT_RESTART		0x00000004
#define LDAP_OPT_REFHOPLIMIT		0x05
#define LDAP_OPT_DEBUG			0x06

#define LDAP_OPT_SSL_CIPHER		0x07
#define LDAP_OPT_SSL_TIMEOUT		0x08

#define LDAP_OPT_REBIND_FN		0x09
#define LDAP_OPT_SSL			0x0A
#define LDAP_OPT_PROTOCOL_VERSION	0x11
#define LDAP_OPT_SERVER_CONTROLS	0x12
#define LDAP_OPT_CLIENT_CONTROLS	0x13 
#define LDAP_OPT_HOST_NAME		0x30
#define LDAP_OPT_ERROR_NUMBER		0x31
#define LDAP_OPT_ERROR_STRING		0x32
#define LDAP_OPT_EXT_ERROR              0x33

#define LDAP_OPT_UTF8_IO 		0xE0

#define LDAP_OPT_LCS			0x0F

/* option value for no size limit or no time limit on searches */
#define LDAP_NO_LIMIT		0

/* option values for binary options */
#define LDAP_OPT_ON		0x01
#define LDAP_OPT_OFF		0x00

/* option values for dereferencing aliases */
#define LDAP_DEREF_NEVER 	0
#define LDAP_DEREF_SEARCHING	1
#define LDAP_DEREF_FINDING 	2	
#define LDAP_DEREF_ALWAYS	3

/* default limit on nesting of referrals */
#define LDAP_DEFAULT_REFHOPLIMIT	5

/* Debug levels */
#define LDAP_DEBUG_OFF			0x0000
#define LDAP_DEBUG_TRACE		0x0001
#define LDAP_DEBUG_PACKETS		0x0002
#define LDAP_DEBUG_ARGS 		0x0004
#define LDAP_DEBUG_CONNS		0x0008
#define LDAP_DEBUG_BER			0x0010
#define LDAP_DEBUG_FILTER		0x0020
#define LDAP_DEBUG_MESSAGE		0x0040
#define LDAP_DEBUG_ACL			0x0080
#define LDAP_DEBUG_STATS		0x0100
#define LDAP_DEBUG_THREAD		0x0200
#define LDAP_DEBUG_REPL			0x0400
#define LDAP_DEBUG_PARSE		0x0800
#define LDAP_DEBUG_PERFORMANCE  0x1000
#define LDAP_DEBUG_RDBM		 	0x2000
#define LDAP_DEBUG_REFERRAL	 	0x4000
#define LDAP_DEBUG_ERROR		0x8000
#define LDAP_DEBUG_ANY			0xffff


/* options for SSL ciphers */
#define LDAP_SSL_RC4_MD5_EX	"03"
#define LDAP_SSL_RC2_MD5_EX	"06"
#define LDAP_SSL_RC4_SHA_US	"05"
#define LDAP_SSL_RC4_MD5_US	"04"
#define LDAP_SSL_DES_SHA_US	"09"
#define LDAP_SSL_3DES_SHA_US	"0A"

/*
 * possible error codes we can return
 */

#define LDAP_SUCCESS			0x00
#define LDAP_OPERATIONS_ERROR		0x01
#define LDAP_PROTOCOL_ERROR		0x02
#define LDAP_TIMELIMIT_EXCEEDED 	0x03
#define LDAP_SIZELIMIT_EXCEEDED 	0x04
#define LDAP_COMPARE_FALSE		0x05
#define LDAP_COMPARE_TRUE		0x06
#define LDAP_STRONG_AUTH_NOT_SUPPORTED	0x07
#define LDAP_STRONG_AUTH_REQUIRED	0x08
#define LDAP_PARTIAL_RESULTS		0x09
    
#define LDAP_REFERRAL			0X0a
#define LDAP_ADMIN_LIMIT_EXCEEDED	0X0b
#define LDAP_UNAVAILABLE_CRITICAL_EXTENSION  0X0c
#define LDAP_CONFIDENTIALITY_REQUIRED   0x0d
#define LDAP_SASLBIND_IN_PROGRESS       0x0e  

#define LDAP_NO_SUCH_ATTRIBUTE		0x10
#define LDAP_UNDEFINED_TYPE		0x11
#define LDAP_INAPPROPRIATE_MATCHING	0x12
#define LDAP_CONSTRAINT_VIOLATION	0x13
#define LDAP_TYPE_OR_VALUE_EXISTS	0x14
#define LDAP_INVALID_SYNTAX		0x15

#define LDAP_NO_SUCH_OBJECT		0x20
#define LDAP_ALIAS_PROBLEM		0x21
#define LDAP_INVALID_DN_SYNTAX		0x22
#define LDAP_IS_LEAF			0x23
#define LDAP_ALIAS_DEREF_PROBLEM	0x24

#define LDAP_INAPPROPRIATE_AUTH 	0x30
#define LDAP_INVALID_CREDENTIALS	0x31
#define LDAP_INSUFFICIENT_ACCESS	0x32
#define LDAP_BUSY			0x33
#define LDAP_UNAVAILABLE		0x34
#define LDAP_UNWILLING_TO_PERFORM	0x35
#define LDAP_LOOP_DETECT		0x36

#define LDAP_NAMING_VIOLATION		0x40
#define LDAP_OBJECT_CLASS_VIOLATION	0x41
#define LDAP_NOT_ALLOWED_ON_NONLEAF	0x42
#define LDAP_NOT_ALLOWED_ON_RDN 	0x43
#define LDAP_ALREADY_EXISTS		0x44
#define LDAP_NO_OBJECT_CLASS_MODS	0x45
#define LDAP_RESULTS_TOO_LARGE		0x46

#define LDAP_AFFECTS_MULTIPLE_DSAS	0X47

#define LDAP_OTHER			0x50
#define LDAP_SERVER_DOWN		0x51
#define LDAP_LOCAL_ERROR		0x52
#define LDAP_ENCODING_ERROR		0x53
#define LDAP_DECODING_ERROR		0x54
#define LDAP_TIMEOUT			0x55
#define LDAP_AUTH_UNKNOWN		0x56
#define LDAP_FILTER_ERROR		0x57
#define LDAP_USER_CANCELLED		0x58
#define LDAP_PARAM_ERROR		0x59
#define LDAP_NO_MEMORY			0x5a
#define LDAP_CONNECT_ERROR		0x5b
#define LDAP_NOT_SUPPORTED		0x5c
#define LDAP_CONTROL_NOT_FOUND		0x5d
#define LDAP_NO_RESULTS_RETURNED	0x5e
#define LDAP_MORE_RESULTS_TO_RETURN	0x5f

#define LDAP_URL_ERR_NOTLDAP		0x60
#define LDAP_URL_ERR_NODN		0x61
#define LDAP_URL_ERR_BADSCOPE		0x62
#define LDAP_URL_ERR_MEM		0x63


#define LDAP_CLIENT_LOOP		0x64
#define LDAP_REFERRAL_LIMIT_EXCEEDED	0x65 

#define LDAP_SSL_ALREADY_INITIALIZED    0x70
#define LDAP_SSL_INITIALIZE_FAILED      0x71
#define LDAP_SSL_CLIENT_INIT_NOT_CALLED 0x72
#define LDAP_SSL_PARAM_ERROR            0x73
#define LDAP_SSL_HANDSHAKE_FAILED       0x74
#define LDAP_SSL_GET_CIPHER_FAILED      0x75

#define LDAP_NO_EXPLICIT_OWNER		0x80

/*
 * This structure represents both ldap messages and ldap responses.
 * These are really the same, except in the case of search responses,
 * where a response has multiple messages.
 */

typedef struct ldapmsg LDAPMessage;
#define NULLMSG ((LDAPMessage *) NULL)

/*
 * structure representing an ldap connection
 */
typedef struct ldap  LDAP;

/*
 * type for ldap_set_rebind_proc()
 */
typedef int (*LDAPRebindProc)( struct ldap *ld, char **dnp,
			char **passwdp, int *authmethodp, int freeit );

/*
 * types for ldap URL handling
 */
typedef struct ldap_url_desc {
    char	*lud_host;
    int 	lud_port;
    char	*lud_dn;
    char	**lud_attrs;
    int 	lud_scope;
    char	*lud_filter;
    char	*lud_string;	/* for internal use only */
} LDAPURLDesc;
#define NULLLDAPURLDESC ((LDAPURLDesc *)NULL)

typedef struct _LDAPVersion {
    int sdk_version;
    int protocol_version;
    int SSL_version;
    int security_level;
    char ssl_max_cipher[ 65 ] ;
    char ssl_min_cipher[ 65 ] ;
} LDAPVersion;

typedef struct _LDAPControl {
    char *ldctl_oid;
    struct berval ldctl_value;
    int           ldctl_iscritical;
} LDAPControl;

/* Function prototypes */
#ifndef _NO_PROTO
#define LDAP_P(x) x
#else
#define LDAP_P(x) ()
#endif

#ifndef LDAPFUNCDECL
#ifdef _WIN32
#define LDAPFUNCDECL	__declspec( dllexport )
#else /* _WIN32 */
#define LDAPFUNCDECL
#endif /* _WIN32 */
#endif /* LDAPFUNCDECL */

int ldap_abandon LDAP_P(( LDAP *ld, int msgid ));
int ldap_abandon_ext LDAP_P(( LDAP *ld, int msgid, 
	LDAPControl **serverctrls,  
	LDAPControl **clientctrls));		 
int ldap_add LDAP_P(( LDAP *ld, char *dn, LDAPMod **attrs ));
int ldap_add_s LDAP_P(( LDAP *ld, char *dn, LDAPMod **attrs ));
int ldap_add_ext LDAP_P((LDAP *ld, char *dn, LDAPMod **attrs,
	LDAPControl **serverctrls,    
	LDAPControl **clientctrls,
	int *msgidp));
int ldap_add_ext_s LDAP_P((LDAP *ld, char *dn, LDAPMod **attrs,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls));
int ldap_bind LDAP_P(( LDAP *ld, char *who, char *passwd,
	int authmethod ));
int ldap_bind_s LDAP_P(( LDAP *ld, char *who, char *cred,
	int method ));
int ldap_simple_bind LDAP_P(( LDAP *ld, char *who, char *passwd ));
int ldap_simple_bind_s LDAP_P(( LDAP *ld, char *who, char *passwd ));
void ldap_set_rebind_proc LDAP_P(( LDAP *ld,
	LDAPRebindProc rebindproc ));
int ldap_compare LDAP_P(( LDAP *ld, char *dn, char *attr,
	char *value ));
int ldap_compare_s LDAP_P(( LDAP *ld, char *dn, char *attr,
	char *value ));
int ldap_compare_ext LDAP_P(( LDAP *ld, char *dn, char *attr,
	struct berval *bvalue,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	int *msgidp));
int ldap_compare_ext_s LDAP_P(( LDAP *ld, char *dn, char *attr,
	struct berval *bvalue,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls));
int ldap_delete LDAP_P(( LDAP *ld, char *dn ));
int ldap_delete_s LDAP_P(( LDAP *ld, char *dn ));
int ldap_delete_ext LDAP_P (( LDAP *ld, char *dn,     
	LDAPControl **serverctrls,  
	LDAPControl **clientctrls,
	int *msgidp));
int ldap_delete_ext_s LDAP_P (( LDAP * ld, char *dn,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls));
int ldap_result2error LDAP_P(( LDAP *ld, LDAPMessage *r, int freeit ));
char *ldap_err2string LDAP_P(( int err ));
void ldap_perror LDAP_P(( LDAP *ld, char *s ));
int ldap_get_errno LDAP_P(( LDAP *ld ));
int ldap_get_exterror LDAP_P(( LDAP *ld )) ;
int ldap_modify LDAP_P(( LDAP *ld, char *dn, LDAPMod **mods ));
int ldap_modify_s LDAP_P(( LDAP *ld, char *dn, LDAPMod **mods ));
int ldap_modify_ext LDAP_P (( LDAP *ld, char *dn, LDAPMod **mods,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	int *msgidp));
int ldap_modify_ext_s LDAP_P (( LDAP *ld, char *dn, LDAPMod **mods,
	LDAPControl **serverctrls,
	LDAPControl **clientctrls));
int ldap_modrdn LDAP_P(( LDAP *ld, char *dn, char *newrdn,
	int deleteoldrdn ));
int ldap_modrdn_s LDAP_P(( LDAP *ld, char *dn, char *newrdn,
	int deleteoldrdn));
LDAP *ldap_open LDAP_P(( char *host, int port ));
LDAP *ldap_init LDAP_P(( char *defhost, int defport ));
int ldap_set_option LDAP_P(( LDAP *ld, int optionToSet,
	void *optionValue ));
int ldap_get_option LDAP_P(( LDAP *ld, int optionToGet,
	void *optionValue ));
int ldap_version LDAP_P((LDAPVersion *version));
LDAPMessage *ldap_first_entry LDAP_P(( LDAP *ld, LDAPMessage *chain ));
LDAPMessage *ldap_next_entry LDAP_P(( LDAP *ld, LDAPMessage *entry ));
int ldap_count_entries LDAP_P(( LDAP *ld, LDAPMessage *chain ));
LDAPMessage *ldap_first_message LDAP_P(( LDAP *ld, LDAPMessage *chain));
LDAPMessage *ldap_next_message  LDAP_P(( LDAP *ld, LDAPMessage *chain));
int ldap_count_messages LDAP_P(( LDAP *ld, LDAPMessage *chain));
LDAPMessage *ldap_first_reference LDAP_P ((LDAP *ld, LDAPMessage *res));
LDAPMessage *ldap_next_reference LDAP_P ((LDAP *ld, LDAPMessage *res));
int ldap_count_references LDAP_P((LDAP *ld, LDAPMessage *result));
char *ldap_get_dn LDAP_P(( LDAP *ld, LDAPMessage *entry ));
char **ldap_explode_dn LDAP_P(( char *dn, int notypes ));
char **ldap_explode_rdn LDAP_P(( char *rdn, int notypes));
char *ldap_dn2ufn LDAP_P(( char *dn));
char *ldap_first_attribute LDAP_P(( LDAP *ld, LDAPMessage *entry,
	BerElement **ber ));
char *ldap_next_attribute LDAP_P(( LDAP *ld, LDAPMessage *entry,
	BerElement *ber ));
int ldap_count_attributes LDAP_P(( LDAP *ld, LDAPMessage *entry ));
char **ldap_get_values LDAP_P(( LDAP *ld, LDAPMessage *entry,
	char *target ));
struct berval **ldap_get_values_len LDAP_P(( LDAP *ld,
	LDAPMessage *entry, char *target ));
int ldap_count_values LDAP_P(( char **vals ));
int ldap_count_values_len LDAP_P(( struct berval **vals ));
void ldap_value_free LDAP_P(( char **vals ));
void ldap_value_free_len LDAP_P(( struct berval **vals ));
int ldap_result LDAP_P(( LDAP *ld, int msgid, int all,
	struct timeval *timeout, LDAPMessage **result ));
int ldap_msgfree LDAP_P(( LDAPMessage *lm ));
int ldap_msgid LDAP_P (( LDAPMessage *res));
int ldap_msgtype LDAP_P ((LDAPMessage *res));
int ldap_search LDAP_P(( LDAP *ld, char *base, int scope, char *filter,
	char **attrs, int attrsonly ));
int ldap_search_s LDAP_P(( LDAP *ld, char *base, int scope,
	char *filter, char **attrs, int attrsonly,
	LDAPMessage **res ));
int ldap_search_st LDAP_P(( LDAP *ld, char *base, int scope,
	char *filter, char **attrs, int attrsonly,
	struct timeval *timeout, LDAPMessage **res ));
int ldap_search_ext LDAP_P ((LDAP *ld, char *base, int scope, char *filter,
	char **attrs, int attrsonly, 
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	struct timeval *timeoutp,
	int sizelimit, int *msgidp));
int ldap_search_ext_s LDAP_P  ((LDAP *ld, char *base, int scope, char *filter,
	char **attrs, int attrsonly, 
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	struct timeval *timeoutp,
	int sizelimit,
	LDAPMessage **res));		
int ldap_unbind LDAP_P(( LDAP *ld ));
int ldap_unbind_s LDAP_P(( LDAP *ld ));
void ldap_mods_free LDAP_P(( LDAPMod **mods, int freemods ));
void ldap_control_free LDAP_P ((LDAPControl *ctrl));
void ldap_controls_free LDAP_P ((LDAPControl **ctrls));
void ldap_memfree LDAP_P(( char *mem ));
void ldap_ber_free LDAP_P(( BerElement *mem ));
int ldap_is_ldap_url LDAP_P(( char *url ));
int ldap_url_parse LDAP_P(( char *url, LDAPURLDesc **ludpp ));
void ldap_free_urldesc LDAP_P(( LDAPURLDesc *ludp ));
int ldap_url_search LDAP_P(( LDAP *ld, char *url, int attrsonly ));
int ldap_url_search_s LDAP_P(( LDAP *ld, char *url, int attrsonly,
	LDAPMessage **res ));
int ldap_url_search_st LDAP_P(( LDAP *ld, char *url, int attrsonly,
	struct timeval *timeout, LDAPMessage **res ));
void ldap_set_debug LDAP_P(( int debugLevel ));

int   ldap_set_cipher( LDAP *ld, char *userString ); 

int ldap_ssl_start LDAP_P((LDAP *ld, char *keyfile, char *keyfile_pw,
	char *keyfile_dn));

int ldap_ssl_client_init LDAP_P((char *keyfile, 
				 char *keyfile_pw, 
				 int sslTimeout, 
				 int *pSSLReasonCode )) ;
LDAP *ldap_ssl_init LDAP_P((char *host,
			    int   port,
			    char *keyfile_dn )) ;

int ldap_sasl_bind LDAP_P((LDAP *ld, char *dn, char *mechansim, 
	struct berval *credentials, 
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	int* msgidp));
int ldap_sasl_bind_s LDAP_P(( LDAP *ld, char* dn, char *mechansim,
	struct berval *credentials,    
	LDAPControl **serverctrls,
	LDAPControl **clientctrls,
	struct berval  **servercredp));
int ldap_rename LDAP_P((LDAP* ld, char *dn, char *newdn, char *newparent,
	int deleteoldrdn, 
	LDAPControl **serverctrls, LDAPControl **clientctrls,
	int *msgidp));
int ldap_rename_s LDAP_P((LDAP* ld,char *dn, char *newdn, char *newparent,
	int deleteoldrdn, 
	LDAPControl **serverctrls, LDAPControl **clientctrls));
int ldap_parse_result LDAP_P((LDAP* ld, LDAPMessage *result, int *errcodep,
	char **matcheddnp, char **errmsgp, 
	char ***referralsp, LDAPControl ***serverctrlsp,
	int freeint )) ;
int ldap_parse_sasl_bind_result LDAP_P((LDAP* ld, LDAPMessage *result,
   	struct berval **servercredp, 
	int freeit)); 

LDAPFUNCDECL void ber_free LDAP_P((BerElement *ber, int freebuf));
LDAPFUNCDECL void ber_bvfree LDAP_P((struct berval *bv));

#ifdef __cplusplus
}
#endif

#endif /* _LDAP_H */
