/* @(#)43   1.3.1.2  src/export/include/ldapssl.h, ldap.include, ldapadt12, 980504b  4/17/98  10:47:00 */
/*
 * COMPONENT_NAME: ldap.include
 *
 * ABSTRACT: header file for errors returned from ldap_ssl_start.
 *
 * FUNCTIONS:
 *
 * ORIGINS: 27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _LDAPSSL_H
#define _LDAPSSL_H

/* Return codes. These are the return values */
/* for ldap_ssl_start()                      */
#define SKIT_INITIALIZE_OK             0 /* Successful Completion           */
#define SKIT_KEYFILE_IO_ERROR          1 /* Warning: keyring io error       */
#define SKIT_KEYFILE_OPEN_FAILED       2 /* Warning: keyring open error     */
#define SKIT_KEYFILE_BAD_FORMAT        3 /* Warning: keyring format problem */
#define SKIT_KEYFILE_BAD_PASSWORD      4 /* Warning: Keyring password bad   */
#define SKIT_KEYFILE_BAD_MALLOC        5 /* Error: Malloc failed            */
#define SKIT_KEYFILE_NOTHING_TO_WRITE  6
#define SKIT_KEYFILE_WRITE_FAILED      7 
#define SKIT_KEYFILE_NOT_FOUND         8
#define SKIT_KEYFILE_BAD_DNAME         9 /* Error: Invalid distinquish name */
#define SKIT_KEYFILE_BAD_KEY          10
#define SKIT_KEYFILE_KEY_EXISTS       11
#define SKIT_KEYFILE_BAD_LABEL        12
#define SKIT_KEYFILE_DUPLICATE_NAME   13
#define SKIT_KEYFILE_DUPLICATE_KEY    14
#define SKIT_KEYFILE_DUPLICATE_LABEL  15
#define SKIT_ERR_INIT_PARM_NOT_VALID 100 /* Error: invalid cipher spec      */
#define SKIT_INIT_HARD_RT            101 /* Warning: no keyring file or pw  */
#define SKIT_INIT_SEC_TYPE_NOT_VALID 102 /* Error: invalid security type    */
#define SKIT_INIT_V2_TIMEOUT_NOT_VALID 103 /* Error: invalid V2 timeout value */
#define SKIT_INIT_V3_TIMEOUT_NOT_VALID 104 /* Error: invalid V3 timeout value */
#define SKIT_KEYFILE_CERT_EXPIRED    105 /* Error: Certificate has expired */

  /* Return codes. These are the return values */
  /* for skit_secure_soc_init                  */
#define SKIT_SOC_BAD_V2_CIPHER                   -40
#define SKIT_SOC_BAD_V3_CIPHER                   -41
#define SKIT_SOC_BAD_SEC_TYPE                    -42
#define SKIT_SOC_BAD_SEC_TYPE_COMBINATION        -102
#define SKIT_SOC_NO_READ_FUNCTION                -43
#define SKIT_SOC_NO_WRITE_FUNCTION               -44

#define SKIT_ERROR_NO_CIPHERS                    -1
#define SKIT_ERROR_NO_CERTIFICATE                -2
#define SKIT_ERROR_BAD_CERTIFICATE               -4
#define SKIT_ERROR_UNSUPPORTED_CERTIFICATE_TYPE  -6
#define SKIT_ERROR_IO                            -10
#define SKIT_ERROR_BAD_MESSAGE                   -11
#define SKIT_ERROR_BAD_MAC                       -12
#define SKIT_ERROR_UNSUPPORTED                   -13
#define SKIT_ERROR_BAD_CERT_SIG                  -14
#define SKIT_ERROR_BAD_CERT                      -15
#define SKIT_ERROR_BAD_PEER                      -16
#define SKIT_ERROR_PERMISSION_DENIED             -17
#define SKIT_ERROR_SELF_SIGNED                   -18
#define SKIT_ERROR_BAD_MALLOC                    -20
#define SKIT_ERROR_BAD_STATE                     -21 /* V3 */
#define SKIT_ERROR_SOCKET_CLOSED                 -22
#define SKIT_ERROR_SKIT_INITIALIZATION_FAILED    -23
#define SKIT_ERROR_HANDLE_CREATION_FAILED        -24
#define SKIT_ERROR_UNKNOWN_ERROR                 -99

#endif /* _LDAPSSL_H */
