/* @(#)88   1.4.2.1  src/export/include/ldif.h, ldap.include, ldapadt12, 980504b  4/17/98  10:47:07 */
/*
 * COMPONENT_NAME: ldap.include
 *
 * ABSTRACT:
 *
 * FUNCTIONS:
 *
 * ORIGINS: 202,27
 *
 * (C) COPYRIGHT International Business Machines Corp. 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * CHANGE HISTORY:
 *
 * 01/08/98  PAWOLF  F37251   OS/400 argument optimization
 */

/*
 * Copyright (c) 1996 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifndef _LDIF_H
#define _LDIF_H

#ifdef __cplusplus
extern "C" {
#endif

#define LINE_WIDTH      76      /* maximum length of LDIF lines */

/*
 * Macro to calculate maximum number of bytes that the base64 equivalent
 * of an item that is "vlen" bytes long will take up.  Base64 encoding
 * uses one byte for every six bits in the value plus up to two pad bytes.
 */
#define LDIF_BASE64_LEN(vlen)	(((vlen) * 4 / 3 ) + 3)

/*
 * Macro to calculate maximum size that an LDIF-encoded type (length
 * tlen) and value (length vlen) will take up:  room for type + ":: " +
 * first newline + base64 value + continued lines.  Each continued line
 * needs room for a newline and a leading space character.
 */
#define LDIF_SIZE_NEEDED(tlen,vlen) \
    ((tlen) + 4 + LDIF_BASE64_LEN(vlen) \
    + ((LDIF_BASE64_LEN(vlen) + tlen + 3) / LINE_WIDTH * 2 ))


#ifdef NEEDPROTOS
char * str_getline( char **next );
char *ldif_type_and_value( char *type, char *val, int vlen );
void put_type_and_value( char **out, char *t, char *val, int vlen );
int str_parse_line( char *line, char **type, char **value, int *vlen);

/*
 * NOTE: If you add new prototypes to this file, add an argopt pragma.
 */
#ifdef __OS400_ARG_OPT__
#pragma argopt(str_getline)
#pragma argopt(ldif_type_and_value)
#pragma argopt(put_type_and_value)
#pragma argopt(str_parse_line)
#endif /* __OS400_ARG_OPT__ */

#ifdef LOCALCP_TRANSLATION
char *ldif_type_and_value_or_bvalue( char *type, char *localcp_val, int localcp_vlen, 
                                     char *val, int vlen );
void put_type_and_value_or_bvalue( char **out, char *t, char *localcp_val, int localcp_vlen, 
								   char *val, int vlen );
int str_parse_line_v_or_bv( char *line, char **type, char **value, int *vlen, int *binvalue);

/*
 * NOTE: If you add new prototypes to this file, add an argopt pragma.
 */
#ifdef __OS400_ARG_OPT__
#pragma argopt(ldif_type_and_value_or_bvalue)
#pragma argopt(put_type_and_value_or_bvalue)
#pragma argopt(str_parse_line_v_or_bv)
#endif /* __OS400_ARG_OPT__ */

#endif /* LOCALCP_TRANSLATION */
#else /* NEEDPROTOS */
#ifdef LOCALCP_TRANSLATION
char *ldif_type_and_value_or_bvalue();
void put_type_and_value_or_bvalue();
int str_parse_line_v_or_bv();

/*
 * NOTE: If you add new prototypes to this file, add an argopt pragma.
 */
#ifdef __OS400_ARG_OPT__
#pragma argopt(ldif_type_and_value_or_bvalue)
#pragma argopt(put_type_and_value_or_bvalue)
#pragma argopt(str_parse_line_v_or_bv)
#endif /* __OS400_ARG_OPT__ */

#endif /* LOCALCP_TRANSLATION */
char * str_getline();
char *ldif_type_and_value();
void put_type_and_value();
int str_parse_line();

/*
 * NOTE: If you add new prototypes to this file, add an argopt pragma.
 */
#ifdef __OS400_ARG_OPT__
#pragma argopt(str_getline)
#pragma argopt(ldif_type_and_value)
#pragma argopt(put_type_and_value)
#pragma argopt(str_parse_line)
#endif /* __OS400_ARG_OPT__ */

#endif /* NEEDPROTOS */

#ifdef __cplusplus
}
#endif

#endif /* _LDIF_H */
