#ifndef JONAH_ALGS_H_
#define JONAH_ALGS_H_

// This file contains OIDs and other stuff relating to the 
// crypto algorithms supported by Jonah.

#include "x509.h"

#define OID_DSA "DSA"
#define OID_RSAwithMD2 "RSAwithMD2"
#define OID_RSAwithMD4 "RSAwithMD5"
#define OID_RSAwithMD5 "RSAwithMD5"
#define OID_RSAwithSHA1 "RSAwithSHA1"

EXPORTFN(uint32, GetKeySize, (const SubjectPublicKeyInfo & key));
// Returns the number of bits in a public key.  What this means is totally algorithm-dependent


#endif