//
// Certificate Policy definitions
//

#ifndef _CERTPOL_H_
#define _CERTPOL_H_

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <x509.h>
#include <sections.h>
#include <jonahini.h>
#include <jonahalg.h>
#include <pkix_messages.h>
#include <polmsg.h>
#include <constants.h>
#include <crypto.h>


/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#define CP_STRSIZE 1024

// Explicit text can only be 200 characters long
#define CP_EXPTEXTSIZE 200

// Key usages for algorithms documented in PKIX 
static const long rsaKeyUsage = 
(USAGE_digitalSignature | USAGE_nonRepudiation | USAGE_keyEncipherment | USAGE_dataEncipherment); 
static const long rsaCaKeyUsage = (rsaKeyUsage | USAGE_keyCertSign | USAGE_cRLSign); 
static const long dhKeyUsage = (USAGE_keyAgreement | USAGE_encipherOnly | USAGE_decipherOnly); 
static const long dsaKeyUsage = (USAGE_digitalSignature | USAGE_nonRepudiation);
static const long dsaCaKeyUsage = (dsaKeyUsage | USAGE_keyCertSign | USAGE_cRLSign); 

// An array to contain indexes to all possible extensions on a cert
#define CP_EXTENSIONS 15
typedef int ExtArray[CP_EXTENSIONS]; 

enum ExtIndex {authKeyExt, subjKeyExt, keyUsageExt, privKeyPeriodExt, certPolExt, polMapExt,
		subjAltExt, issuerAltExt, subjDirExt, basicConstExt, nameConstExt, polConstExt, 
		extKeyUsageExt, crlDistPointExt, authInfoAccessExt}; 

// Check the fields in the new cert to see if they're valid
// Includes checking against the RA or CA's policy in the .ini file 
EXPORTFN (int ,
		  CP_NewCertVerify,
		  (const CertTemplate & cert));

// If the caller wants the indices to the extensions found returned
EXPORTFN (int ,
		  CP_NewCertVerify,
		  (const CertTemplate & cert,
		  ExtArray & indices));

// The public key is optional (must be in the template if not specified)
EXPORTFN (int,
		  CP_NewCertCreate,
		  (const CertTemplate & tmplt, 
		  x509_certificate  & cert, 
		  const asn_bitstring & pubkey));

EXPORTFN (int,
		  CP_NewCertCreate,
		  (const CertTemplate & tmplt, 
		  x509_certificate & cert));

bool CP_OidsEqual(const asn_oid &oid, unsigned long p[], unsigned n); 

int CP_FindPolicy(const asn_oid &poloid); 

int CP_FindCpsQual(const PolicyInformation *pol); 

int CP_FindUnoticeQual(const PolicyInformation *pol); 

bool CP_IsSubjKeyOid(const asn_oid &oid); 

bool CP_IsSubjAltOid(const asn_oid &oid);

#endif
