/* SCCSID: inc/cssmkeyformats.h, dss_cdsa_fwk, fwk_rel3, dss_980403 1.8 4/13/98 10:38:51 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef __CSSMKEYFORMATS_H
#define __CSSMKEYFORMATS_H


//
// DES Key Format
//
typedef CSSM_DATA  CSSM_DES, *CSSM_DES_PTR;

//
// 3DES Key Format
//
typedef CSSM_DATA  CSSM_3DES, *CSSM_3DES_PTR;


//
// RSA Key Formats
//

typedef struct cssm_rsa_public {
	CSSM_DATA		modulus;							/* Modulus n */
	uint32			modulusBits;						/* Size of modulus n in bits */
	CSSM_DATA		publicExponent;						/* Public exponent e */
} CSSM_RSA_PUBLIC, *CSSM_RSA_PUBLIC_PTR;


typedef struct cssm_rsa_private {
	CSSM_DATA		modulus;							/* Modulus n */
	CSSM_DATA		publicExponent;						/* Public exponent e */
	CSSM_DATA		privateExponent;					/* Private exponent d */
	CSSM_DATA		primeOne;							/* Prime p */
	CSSM_DATA		primeTwo;							/* Prime q */	
	CSSM_DATA		exponentOne;		                /* Private exponent d modulo p-1 */
	CSSM_DATA		exponentTwo;						/* Private exponent d modulo q-1 */
	CSSM_DATA		coefficient;                        /* CRT coefficient (1/q) modulo p */
} CSSM_RSA_PRIVATE, *CSSM_RSA_PRIVATE_PTR;


//
// DSA Key Formats
//

typedef struct cssm_dsa_public {
	CSSM_DATA		prime;								/* Prime p */
	CSSM_DATA		subPrime;							/* Subprime q */
	CSSM_DATA		base;								/* Base g */
	CSSM_DATA		publicValue;						/* Public value y */
} CSSM_DSA_PUBLIC, *CSSM_DSA_PUBLIC_PTR;


typedef struct cssm_dsa_private {
	CSSM_DATA		prime;								/* Prime p */
	CSSM_DATA		subPrime;							/* Subprime q */
	CSSM_DATA		base;								/* Base g */
	CSSM_DATA		privateValue;						/* Private value x */
} CSSM_DSA_PRIVATE, *CSSM_DSA_PRIVATE_PTR;


//
// DH Params and Key Formats
//

typedef struct cssm_dh_params {
	CSSM_DATA		prime;								/* Prime p */
	CSSM_DATA		base;								/* Base g */
	uint32			exponentBits;						/* Size of exponent in bits */
} CSSM_DH_PARAMS, *CSSM_DH_PARAMS_PTR;


typedef struct cssm_dh_public {
	CSSM_DATA		prime;								/* Prime p */
	CSSM_DATA		base;								/* Base g */
	CSSM_DATA		publicValue;						/* Public value y */
} CSSM_DH_PUBLIC, *CSSM_DH_PUBLIC_PTR;


typedef struct cssm_dh_private {
	CSSM_DATA		prime;								/* Prime p */
	CSSM_DATA		base;								/* Base g */
	CSSM_DATA		privateValue;						/* Private value x */
	uint32			exponentBits;						/* Size of exponent in bits */
} CSSM_DH_PRIVATE, *CSSM_DH_PRIVATE_PTR;

#endif

