/* SCCSID: inc/cssmport.h, dss_cdsa_fwk, fwk_rel3, dss_980403 1.20 4/13/98 10:38:27 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef _CSSMPORT_H
#define _CSSMPORT_H    

#if defined (WIN32)
#include <process.h>
#include <windows.h>
#include <limits.h>
#endif

#include "cssm.h"
#include <stdio.h>

#if defined (WIN32)
#include <sys\types.h>
#include <sys\stat.h>
#define cssm_stat _stat
#endif

#if defined (WIN32)
#define DllImport       __declspec( dllimport )
#define DllExport       __declspec( dllexport )
#else
#define DllImport
#define DllExport
#define __declspec( attr )
#define __stdcall
#define CSSM_THREAD
#endif

typedef void (*NULL_FUNC_PTR) ();
static CSSM_GUID port_guid = 
{ 0xa32fbd82, 0xfbcc, 0x11cf, { 0x81, 0x72, 0x0, 0xaa, 0x0, 0xb1, 0x99, 0xdd } };

#ifdef __cplusplus
extern "C" {
#endif

/* Porting Library Functions */

/* GetProcess ID and GetThreadID macros */
#if defined (WIN32)
#define CSSM_GETPROCESSID (uint32)_getpid()
#define CSSM_GETTHREADID (uint32)GetCurrentThreadId()
#endif

/* Initialization and termination routines */
CSSM_RETURN CSSMAPI cssm_port_init(void);
CSSM_RETURN CSSMAPI cssm_port_terminate(void);

/* Registry Routines */
#if defined(WIN32)
typedef HKEY
#else
typedef char *
#endif
CSSM_HKEY, *CSSM_HKEY_PTR;

#if !defined (WIN32)
/* Taken from Winnt.h */

#define REG_NONE                    ( 0 )   // No value type
#define REG_SZ                      ( 1 )   // Unicode nul terminated string
#define REG_EXPAND_SZ               ( 2 )   // Unicode nul terminated string
#define REG_BINARY                  ( 3 )   // Free form binary
#define REG_DWORD                   ( 4 )   // 32-bit number
#define REG_DWORD_LITTLE_ENDIAN     ( 4 )   // 32-bit number (same as REG_DWORD)
#define REG_DWORD_BIG_ENDIAN        ( 5 )   // 32-bit number
#define REG_LINK                    ( 6 )   // Symbolic Link (unicode)
#define REG_MULTI_SZ                ( 7 )   // Multiple Unicode strings
#define REG_RESOURCE_LIST           ( 8 )   // Resource list in the resource map
#define REG_FULL_RESOURCE_DESCRIPTOR ( 9 )  // Resource list in the hardware desicription
#define REG_RESOURCE_REQUIREMENTS_LIST ( 10 )
#define HKEY_CURRENT_USER            (CSSM_HKEY) 0x80000001
#define HKEY_LOCAL_MACHINE           (CSSM_HKEY) 0x80000002
#endif

#define CSSM_CONFIG_STRING          REG_SZ
#define CSSM_CONFIG_BINARY          REG_BINARY
#define CSSM_CONFIG_PERSONAL                1
#define CSSM_CONFIG_GLOBAL          0
#define CSSM_VALUE_BINARY           0
#define CSSM_VALUE_STRING           1

typedef char **CSSM_REG_LIST, ***CSSM_REG_LIST_PTR;

CSSM_RETURN CSSMAPI cssm_SetValue (char *Section, char *Name,
                                   void * Value, sint32  ValueLength, 
                                   sint32  ValueType, sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_GetValue (char *Section, char *Name,
                                   void * Value, sint32 *ValueLength,
                                   sint32 *ValueType, sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_DeleteSection (char *Section, sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_GetValueList (char *section, CSSM_REG_LIST_PTR list,
                                       sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_GetValueCount (char *section, sint32 * count, 
                                        sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_GetSectionCount (char *section, sint32 * count, 
                                          sint32  PersonalPref);
CSSM_RETURN CSSMAPI cssm_GetSectionList (char *section, CSSM_REG_LIST_PTR list,
                                         sint32  PersonalPref);


/* Memory Allocation Routines */

void * cssm_malloc (uint32 size, void* allocRef);
void * cssm_calloc (uint32 num_elem, uint32 num_bytes, void* allocRef);
void cssm_free (void * mem_ptr, void* allocRef);
void * cssm_realloc (void * old_ptr, uint32 num_bytes, void* allocRef);
void * cssm_memset (void * ptr, sint32  value, uint32 num_bytes);
void * cssm_memcpy (void * dest_ptr, void * src_ptr, uint32 num_bytes);
void * cssm_memmove (void * dest_ptr, void * src_ptr, uint32 num_bytes);
sint32 cssm_memcmp (void * ptr1, void * ptr2, uint32 count);

CSSM_BOOL CSSMAPI cssm_IsBadStrPtr (const char *str, uint32  length);
CSSM_BOOL CSSMAPI cssm_IsBadCodePtr (CSSM_CALLBACK  code_ptr);
CSSM_BOOL CSSMAPI cssm_IsBadReadPtr (const void * ptr, uint32 length);
CSSM_BOOL CSSMAPI cssm_IsBadWritePtr (void * ptr, uint32 length);
char * CSSMAPI cssm_strlwr (char *str);

/* File I/O Routines */

CSSM_RETURN CSSMAPI cssm_fwrite (void * buffer, uint32 size, uint32 num, 
                                 FILE * stream);
CSSM_RETURN CSSMAPI cssm_fread (void * buffer, uint32 size, uint32 num, 
                                FILE * stream);
sint32 CSSMAPI cssm_GetLength (FILE * stream) ;

/* Sync Routines */
#define CSSM_INFINITE_WAIT INFINITE
#define CSSM_ZERO_WAIT 0

typedef enum cssm_mutex {
    CSSM_MUTEX_LOCKED, 
    CSSM_MUTEX_BUSY, 
    CSSM_MUTEX_UNLOCKED, 
    CSSM_MUTEX_ERROR
} CSSM_MUTEX;

void * CSSMAPI cssm_CreateMutex (char *name);
CSSM_MUTEX CSSMAPI cssm_LockMutex (void *mutex, sint32 timeout);
CSSM_MUTEX CSSMAPI cssm_TrylockMutex (void *mutex);
CSSM_MUTEX CSSMAPI cssm_UnlockMutex (void *mutex); 
CSSM_RETURN CSSMAPI cssm_CloseMutex (void *mutex);

/* Thread related routines */
uint32 CSSMAPI cssm_GetThreadId();

/* Misc */
char * CSSMAPI cssm_GetIdentificationInfo(char *info, uint32  size);
char * CSSMAPI cssm_GetUserName (char *userName, uint32 size);
char * CSSMAPI cssm_getcwd (char *dir, uint32 size);
char * CSSMAPI cssm_getenv (char *env_var);
uint32 CSSMAPI cssm_GetTime();

/* Dynamic Loading of Libraries */

#if defined(WIN32)
typedef HINSTANCE
#else
typedef void *
#endif
CSSM_LIB_HANDLE, *CSSM_LIB_HANDLE_PTR;

#if defined(WIN32)
typedef HMODULE
#else
typedef void *
#endif
CSSM_MODULE, *CSSM_MODULE_PTR;

#if defined(WIN32)
typedef FARPROC
#else
typedef void *
#endif
CSSM_PROC_ADDR, *CSSM_PROC_ADDR_PTR;

#if defined(WIN32)
typedef HINSTANCE 
#else
typedef void * 
#endif
CSSM_HINSTANCE, *CSSM_HINSTANCE_PTR;

CSSM_RETURN CSSMAPI cssm_FreeLibrary (CSSM_LIB_HANDLE handle);
CSSM_LIB_HANDLE CSSMAPI cssm_LoadLibrary (char *pLibraryPathName);
CSSM_PROC_ADDR CSSMAPI cssm_GetProcAddress (CSSM_MODULE handle, 
                                            char *func_name);  
CSSM_MODULE CSSMAPI cssm_GetModuleHandle (char *module_name);
CSSM_RETURN CSSMAPI cssm_GetModuleFileName (CSSM_MODULE module, char *filename,
                                            sint32 buf_length);


/* Shared Memory Functions */

#if defined(WIN32)
#define CSSM_INVALID_FILE_HANDLE NULL
typedef HANDLE
#else
#define CSSM_INVALID_FILE_HANDLE -1 
typedef int
#endif
CSSM_SHARED_FILE;

#if defined(WIN32)

#define CSSM_CREATE_READWRITE       PAGE_READWRITE
#define CSSM_CREATE_READ            PAGE_READONLY
#define CSSM_MAP_READWRITE          FILE_MAP_ALL_ACCESS
#define CSSM_MAP_READ               FILE_MAP_READ

#endif

CSSM_SHARED_FILE CSSMAPI cssm_CreateMemoryFile (char *name, sint32 perms);
CSSM_SHARED_FILE CSSMAPI cssm_OpenMemoryFile (char *name, sint32 perms);
void * CSSMAPI cssm_MapMemoryFile (CSSM_SHARED_FILE handle, sint32 perms);
CSSM_RETURN CSSMAPI cssm_UnmapMemoryFile (void *file_addr);
CSSM_RETURN CSSMAPI cssm_FlushMemoryFile (void *file_addr);
CSSM_RETURN CSSMAPI cssm_CloseMemoryFile (CSSM_SHARED_FILE handle);

/* error functions */
CSSM_RETURN CSSMAPI cssm_InitError(void);
CSSM_RETURN CSSMAPI cssm_DestroyError(void);
CSSM_ERROR_PTR  CSSMAPI cssm_GetError(void);
CSSM_RETURN CSSMAPI cssm_SetError(CSSM_GUID_PTR guid, uint32 error);
void CSSMAPI cssm_ClearError(void);

/* Misc. functions */

#ifdef __cplusplus
}
#endif

/* Do not edit the following string. It should be expanded at check-in by version control. */
static const char sccs_id_INC_CSSMPORT_H[] = { "@(#) $Header: /cdsa/r1_2/inc/cssmport.h 1     3/11/97 9:54a Snrichar $" };

#endif
