/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef PKI_MESSAGES_
#define PKI_MESSAGES_

#include <stdio.h>
#include <stdarg.h>
#include <platform.h>

#ifdef __cplusplus
extern "C" {
#endif

#if OS == WIN32

typedef uint32 pki_msgcat_handle_t;

#else
#  error Unsupported operating system
#endif

#define PKI_STS_SET_MASK 0xffff0000ul
#define PKI_STS_SET_POS  16
#define PKI_STS_COD_MASK 0x3fful
#define PKI_STS_COD_POS  0



/* Extract the set from a PKI status value.                   */
EXPORTFN(int,
         pkiStsSet,
         (uint32));

/* Extract the status from a PKI status value.                */
EXPORTFN(int,
         pkiStsCode,
         (uint32));

/* Combine a facility, set-id and msg-id into a status code.  */
EXPORTFN(uint32,
         pkiMakeSts,
         (int setId, int msgId));

/* Open a PKI message catalog                                 */
EXPORTFN(pki_msgcat_handle_t,
         pkiCatOpen,
         (const char * name));

/* Close a PKI message catalog                                */
EXPORTFN(int,
         pkiCatClose,
         (pki_msgcat_handle_t h));


/* Write a message to the specified file.  An I18N-enabled    */
/* format-string is read from the specified catalog (if the   */
/* message cannot be found, the defaultMsg parameter is used  */
/* instead), processed using any provided stdargs parameters. */
/*                                                            */
/* The format specifiers are roughly a subset of the I18N     */
/* versions of standard C formatted I/O, except that the h&l  */
/* modifiers refer to PKI portable types, rather than C       */
/* long and short integer types.  The parameter number        */
/* indicator is required.                                     */
/*                                                            */
/*     %<n>$[<w>][.<p>]<t>                                    */
/*                                                            */
/* where <n> is an integer and identifies the parameter that  */
/* provides the value to be substituted (starting counting at */
/* 1, <w> is a width specifier, <p> is a precision, and <t>   */
/* is one of:                                                 */
/*     d - int (decimal)                                      */
/*    hd - sint16 (decimal)                                   */
/*    ld - sint32 (decimal)                                   */
/*     x - int (hex)                                          */
/*    hx - uint16 (hex)                                       */
/*    lx - uint32 (hex)                                       */
/*     X - int (hex)                                          */
/*    hX - uint16 (hex)                                       */
/*    lX - uint32 (hex)                                       */
/*     u - unsigned (hex)                                     */
/*    hu - uint16 (hex)                                       */
/*    lu - uint32 (hex)                                       */
/*     s - character string                                   */
/*     c - char                                               */
/*                                                            */	

EXPORTFN(void,
         PKI_OSSRV_fprintMsg,
         (FILE * file,
          pki_msgcat_handle_t catalog,
          uint32 status,
          const char * defaultMsg,
          ...));

EXPORTFN(size_t,
         PKI_OSSRV_sprintMsg,
         (char * buffer,
          size_t bufferSize,
          pki_msgcat_handle_t catalog,
          uint32 status,
          const char * defaultMsg,
          ...));

EXPORTFN(size_t,
         PKI_OSSRV_vprintMsg,
         (char * buffer,
          size_t bufferSize,
          pki_msgcat_handle_t catalog,
          uint32 status,
          const char * defaultMsg,
          va_list ap));


EXPORTFN(size_t,
         PKI_OSSRV_getMsg,
         (char * buffer,
          size_t bufferSize,
          pki_msgcat_handle_t catalog,
          uint32 status,
          const char * defaultMsg));

#ifdef __cplusplus
}
#endif

#endif