/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef JNH_TRANSPORTS_H_
#define JNH_TRANSPORTS_H_

#include <platform.h>
#include <tcp.h>
#include <pkiTask.h>

// Create a JnhMsgListener object (tcp_listener or mail_listener) for each 
// address/protocol combination you want to support.  The constructor of
// each protocol-specific JnhMsgListener descendant takes the address to
// listen on as an additional parameter.  You can suspend listening by 
// calling stop_listening, and resume listening by calling listen.
// Stop_listening may not stop listening after next connection request
// is received, so it is not a very reliable way of pausing a listener.
// It should be viewed as a way of throttling back incoming traffic if 
// data is arriving too fast to process.
//
// When a message is received, the listener will create a new thread to 
// handle it, and the callback routine will be invoked in the context of
// that message-specific thread.  The listener will continue listening
// in its main thread.
//
// You don't need to call stop_listening before destroying the listener
// object.

class JnhTcpListener;

class EXPORTCLASS JnhMsgListener {
friend void JnhTcpMessageRoutine(void * context);
friend void JnhTcpListenerRoutine(void * thisPtr);
private:
protected:
  union {
    uint32 (* callback1)(unsigned char * msg, size_t length, void * arg);
    uint32 (* callback2)(unsigned char * msg, size_t length, 
                        unsigned char *& respMsg, size_t &respLength, 
                        void (*& freeRtn)(void * ptr), 
                        void * arg);
  } callback;
  void * callback_arg;
  pki_thread_handle_t listenerThread;
  int (*function)(void *);
  bool okToListen;
  bool shuttingDown;
public:
  uint32 error;
  JnhMsgListener(uint32 (* act_rtn)(unsigned char * msg, size_t length, void * arg), void * arg);
  JnhMsgListener(uint32 (* act_rtn)(unsigned char * rcvMsg, size_t rcvLength, 
                                    unsigned char * &sndMsg, size_t &sndLength,
                                    void (*& freeRtn)(void * ptr), void * arg), 
                 void * arg);
  virtual ~JnhMsgListener();
  virtual uint32 listen(void) = 0;
  virtual uint32 stop_listening(void) = 0;
};



// Create a JnhMsgSender object (JnhTcpSender or JnhMailSender) for each 
// address/protocol combination you want to send messages from.  The 
// constructor of each protocol-specific JnhMsgSender descendant takes 
// the address to send from as an additional parameter.  Messages are 
// sent by calling the send() function, which takes both a target 
// address and the message data.



class EXPORTCLASS JnhMsgSender {
protected:
public:
  uint32 error;
  JnhMsgSender(void);
  virtual ~JnhMsgSender();
};






class EXPORTCLASS JnhTcpListener : public JnhMsgListener {
friend void JnhTcpMessageRoutine(void * context);
friend void JnhTcpListenerRoutine(void * thisPtr);
private:
  TCP * tcp;
  uint16 myPort;
public:
  JnhTcpListener(uint32 (* act_rtn)(unsigned char * msg, size_t length, 
                                    unsigned char * &repMsg, size_t & repLength, 
                                    void(*& freeRtn)(void * ptr), void * arg),
                 void * arg,
                 uint16 port = 0);
  virtual ~JnhTcpListener();
  virtual uint32 listen(void);
  virtual uint32 stop_listening(void);
};


/*
class EXPORTCLASS JnhMailListener : public JnhMsgListener {
public:
  JnhMailListener(uint32 (* act_rtn)(unsigned char * msg, size_t length),
                  const char * postoffice, 
                  const char * account, 
                  const char * password);
  virtual ~JnhMailListener();
  virtual uint32 listen(void);
  virtual uint32 stop_listening(void);
};


// We can add a JnhWebListener here, which receives the message via IPC
// from a servlet or CGI program 


*/






class EXPORTCLASS JnhTcpSender : public JnhMsgSender {
protected:
  TCP * tcp;
public:
  JnhTcpSender(uint16 sourcePort = 0);
  virtual ~JnhTcpSender();
  uint32 send(const unsigned char * msg, 
              size_t length, 
              const ipAddressV4 & target,
              uint16 port=0);
  uint32 send(const unsigned char * msg, 
              size_t length, 
              unsigned char * respBuffer,
              size_t respBufferLength,
              size_t * respLength,
              const ipAddressV4 & target,
              uint16 port=0);
};

/*

class EXPORTCLASS JnhMailSender : public JnhMsgSender {
friend int JnhMailListenerRoutine(void * thisPtr);
protected:
  char * retAddr;
public:
  JnhMailSender(const char * returnAddress);
  virtual ~JnhMailSender();
  uint32 send(const unsigned char * msg, size_t length, const char * target);
};

*/


#endif
