/*
**	ssh_comm.h	-- generatic communication over ssh
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**	See the LICENSE file.
*/

#ifndef __SSH_COMM_H
#define __SSH_COMM_H

#include "ssh_types.h"

#define SSH_NO_DATA	-1	/* no data available */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	roll packing, encrypting and sending into on function:
*/
int ssh_recv(socket_type sockfd, struct ssh_struct * ssh_info,
	uint8_t * data, uint32_t * data_len);
int ssh_send(socket_type sockfd, struct ssh_struct * ssh_info,
	const uint8_t * data, uint32_t data_len, uint8_t type);

/*
**	read stdout, stderr, merged data and write stdin
*/
int ssh_write_stdin(socket_type sockfd, struct ssh_struct * ssh_info,
	const uint8_t * input);
int ssh_write_stdin_n(socket_type sockfd, struct ssh_struct * ssh_info,
	const uint8_t * input, int length);
int ssh_read_merge(socket_type sockfd, struct ssh_struct * ssh_info,
	uint8_t * output);
int ssh_read_interactive(socket_type sockfd, struct ssh_struct * ssh_info,
	uint8_t * output, uint32_t * output_len, uint32_t max_output_len);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_COMM_H */

