/* apps/ciphers.c */
/* Copyright (C) 1995-1997 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@mincom.oz.au).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@mincom.oz.au)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@mincom.oz.au)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "apps.h"
#include "ssl.h"

#undef PROG
#define PROG	ciphers_main

static char *ciphers_usage[]={
"usage: ciphers args\n",
" -v          - verbose mode, a textual listing of the ciphers in SSLeay\n",
NULL
};

int MAIN(argc, argv)
int argc;
char **argv;
	{
	int ret=1,i;
	int verbose=0;
	char **pp,*p;
	int badops=0;

	apps_startup();

	argc--;
	argv++;
	while (argc >= 1)
		{
		if (strcmp(*argv,"-v") == 0)
			verbose=1;
		else
			{
			BIO_printf(bio_err,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
		for (pp=ciphers_usage; (*pp != NULL); pp++)
			BIO_printf(bio_err,*pp);
		goto end;
		}

	if (verbose)
		{
		fprintf(stdout,"%-16s: No encryption with a MD5 MAC\n",
			SSL2_TXT_NULL_WITH_MD5);
#ifndef NO_RC4
		fprintf(stdout,"%-16s: 128 bit RC4 encryption with a MD5 MAC\n",
			SSL2_TXT_RC4_128_WITH_MD5);
		fprintf(stdout,"%-16s:  40 bit RC4 encryption with a MD5 MAC\n",
			SSL2_TXT_RC4_128_EXPORT40_WITH_MD5);
#endif
#ifndef NO_RC2
		fprintf(stdout,"%-16s: 128 bit RC2 encryption with a MD5 MAC\n",
			SSL2_TXT_RC2_128_CBC_WITH_MD5);
		fprintf(stdout,"%-16s:  40 bit RC2 encryption with a MD5 MAC\n",
			SSL2_TXT_RC2_128_CBC_EXPORT40_WITH_MD5);
#endif
#ifndef NO_IDEA
		fprintf(stdout,"%-16s: 128 bit IDEA encryption with a MD5 MAC\n",
			SSL2_TXT_IDEA_128_CBC_WITH_MD5);
#endif
		fprintf(stdout,"%-16s:  56 bit DES encryption with a MD5 MAC\n",
			SSL2_TXT_DES_64_CBC_WITH_MD5);
		fprintf(stdout,"%-16s:  56 bit DES encryption with a SHA MAC\n",
			SSL2_TXT_DES_64_CBC_WITH_SHA);
		fprintf(stdout,"%-16s: 192 bit EDE3 DES encryption with a MD5 MAC\n",
			SSL2_TXT_DES_192_EDE3_CBC_WITH_MD5);
		fprintf(stdout,"%-16s: 192 bit EDE3 DES encryption with a SHA MAC\n",
			SSL2_TXT_DES_192_EDE3_CBC_WITH_SHA);
		fprintf(stdout,"%-16s:  56 bit CFB64 DES encryption with a one byte MD5 MAC\n",
			SSL2_TXT_DES_64_CFB64_WITH_MD5_1);
		}

	if (!verbose)
		{
		for (i=0; ; i++)
			{
			p=SSL_get_cipher_list(NULL,i);
			if (p == NULL) break;
			if (i != 0) printf(":");
			printf("%s",p);
			}
		printf("\n");
		}
	ret=0;
end:
	EXIT(ret);
	}

