dnl aclocal.m4 generated automatically by aclocal 1.3.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl aclocal.m4 file for fist-2.0
dnl Contains definitions for specialized GNU-autoconf macros.
dnl Author: Erez Zadok <ezk@cs.columbia.edu>
dnl
dnl DO NOT EDIT DIRECTLY!  Generated automtically by maintainers from
dnl aux/Makefile!
dnl
dnl ######################################################################
dnl UNCOMMENT THE NEXT FEW LINES FOR DEBUGGING CONFIGURE
dnl define([AC_CACHE_LOAD], )dnl
dnl define([AC_CACHE_SAVE], )dnl
dnl ======================================================================



dnl ######################################################################
dnl check if compiler can handle "void *"
AC_DEFUN(AC_C_VOID_P,
[
AC_CACHE_CHECK(if compiler can handle void *,
ac_cv_c_void_p,
[
# try to compile a program which uses void *
AC_TRY_COMPILE(
[ ],
[
void *vp;
], ac_cv_c_void_p=yes, ac_cv_c_void_p=no)
])
if test "$ac_cv_c_void_p" = yes
then
  AC_DEFINE(voidp, void *)
else
  AC_DEFINE(voidp, char *)
fi
])
dnl ======================================================================


dnl ######################################################################
dnl New versions of the cache functions which also dynamically evaluate the
dnl cache-id field, so that it may contain shell variables to expand
dnl dynamically for the creation of $ac_cv_* variables on the fly.
dnl In addition, this function allows you to call COMMANDS which generate
dnl output on the command line, because it prints its own AC_MSG_CHECKING
dnl after COMMANDS are run.
dnl
dnl ======================================================================
dnl AC_CACHE_CHECK_DYNAMIC(MESSAGE, CACHE-ID, COMMANDS)
define(AC_CACHE_CHECK_DYNAMIC,
[
ac_tmp=`echo $2`
if eval "test \"`echo '$''{'$ac_tmp'+set}'`\" = set"; then
  AC_MSG_CHECKING([$1])
  echo $ac_n "(cached) $ac_c" 1>&AC_FD_MSG
else
  $3
  AC_MSG_CHECKING([$1])
fi
ac_tmp_val=`eval eval "echo '$''{'$ac_tmp'}'"`
AC_MSG_RESULT($ac_tmp_val)
])
dnl ======================================================================


dnl ######################################################################
dnl AC_HOST_MACROS: define HOST_CPU, HOST_VENDOR, and HOST_OS
AC_DEFUN(AC_HOST_MACROS,
[
# these are defined already by the macro 'CANONICAL_HOST'
  AC_MSG_CHECKING("host cpu")
  AC_DEFINE_UNQUOTED(HOST_CPU, "$host_cpu")
  AC_MSG_RESULT($host_cpu)

  AC_MSG_CHECKING("vendor")
  AC_DEFINE_UNQUOTED(HOST_VENDOR, "$host_vendor")
  AC_MSG_RESULT($host_vendor)

  AC_MSG_CHECKING("host full OS name and version")
  # normalize some host OS names
  case ${host_os} in
	# linux is linux is linux, regardless of RMS.
	linux-gnu* | lignux* )	host_os=linux ;;
  esac
  AC_DEFINE_UNQUOTED(HOST_OS, "$host_os")
  AC_MSG_RESULT($host_os)

# break host_os into host_os_name and host_os_version
  AC_MSG_CHECKING("host OS name")
  host_os_name=`echo $host_os | sed 's/\..*//g'`
  # normalize some OS names
  case ${host_os_name} in
	# linux is linux is linux, regardless of RMS.
	linux-gnu* | lignux* )	host_os_name=linux ;;
	# remove version number
	solaris* ) host_os_name=solaris;;
	freebsd* ) host_os_name=freebsd;;
  esac
  AC_DEFINE_UNQUOTED(HOST_OS_NAME, "$host_os_name")
  AC_MSG_RESULT($host_os_name)

# parse out the OS version of the host
  AC_MSG_CHECKING("host OS version")
changequote(<<, >>)dnl
  host_os_version=`echo $host_os | sed 's/^[^0-9]*//g'`
changequote([, ])dnl
  if test -z "$host_os_version"
  then
	host_os_version=`(uname -r) 2>/dev/null` || host_os_version=unknown
  fi
# keep only major and minor version (make x.y.z.w => x.y)
changequote(<<, >>)dnl
  host_os_version=`echo $host_os_version | sed 's/^\([0-9]*\.[0-9]*\).*/\1/g'`
changequote([, ])dnl
  AC_DEFINE_UNQUOTED(HOST_OS_VERSION, "$host_os_version")
  AC_MSG_RESULT($host_os_version)
# figure out host architecture (different than CPU)
  AC_MSG_CHECKING("host OS architecture")
  host_arch=`(uname -m) 2>/dev/null` || host_arch=unknown
  # normalize some names
  case ${host_arch} in
	sun4* )	host_arch=sun4 ;;
	sun3x )	host_arch=sun3 ;;
	sun )	host_arch=`(arch) 2>/dev/null` || host_arch=unknown ;;
	i?86 )	host_arch=i386 ;; # all x86 should show up as i386
  esac
  AC_DEFINE_UNQUOTED(HOST_ARCH, "$host_arch")
  AC_MSG_RESULT($host_arch)

# figure out host name
  AC_MSG_CHECKING("host name")
  host_name=`(hostname || uname -n) 2>/dev/null` || host_name=unknown
  AC_DEFINE_UNQUOTED(HOST_NAME, "$host_name")
  AC_MSG_RESULT($host_name)

# set os name + version
  HOST_SHORT_OS_VER=${host_os_name}-${host_os_version}
  AC_SUBST(HOST_SHORT_OS_VER)

# figure out user name
  AC_MSG_CHECKING("user name")
  if test -n "$USER"
  then
    user_name="$USER"
  else
    if test -n "$LOGNAME"
    then
      user_name="$LOGNAME"
    else
      user_name=`(whoami) 2>/dev/null` || user_name=unknown
    fi
  fi
  AC_DEFINE_UNQUOTED(USER_NAME, "$user_name")
  AC_MSG_RESULT($user_name)

# figure out configuration date
  AC_MSG_CHECKING("configuration date")
  config_date=`(date) 2>/dev/null` || config_date=unknown_date
  AC_DEFINE_UNQUOTED(CONFIG_DATE, "$config_date")
  AC_MSG_RESULT($config_date)

])
dnl ======================================================================


dnl ######################################################################
dnl check if a local configuration file exists
AC_DEFUN(AC_LOCALCONFIG,
[AC_MSG_CHECKING(a local configuration file)
if test -f localconfig.h
then
  AC_DEFINE(HAVE_LOCALCONFIG_H)
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT(no)
fi
])
dnl ======================================================================


dnl ######################################################################
dnl AC_MSG: a simple printout message
define(AC_MSG,
[echo "*** $1:" 1>&AC_FD_MSG])
dnl ======================================================================


dnl ######################################################################
dnl Package name
AC_DEFUN(AC_NAME_PACKAGE,
[AC_MSG_CHECKING(package name)
AC_DEFINE_UNQUOTED(PACKAGE, "$1")
AC_MSG_RESULT(\"$1\")
])
dnl ======================================================================


dnl ######################################################################
dnl Version of package
AC_DEFUN(AC_NAME_VERSION,
[AC_MSG_CHECKING(version of package)
AC_DEFINE_UNQUOTED(VERSION, "$1")
AC_MSG_RESULT(\"$1\")
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for CPPFLAGS (-I options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_CPPFLAGS,
[AC_MSG_CHECKING(for configuration/compilation (-I) preprocessor flags)
AC_ARG_ENABLE(cppflags,
[  --enable-cppflags[=ARG] configure/compile with ARG (-I) preprocessor flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  CPPFLAGS="$CPPFLAGS $enableval"
  export CPPFLAGS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Debugging: "yes" means general, and "no" means none.
AC_DEFUN(AC_OPT_DEBUG,
[AC_MSG_CHECKING(for debugging options)
AC_ARG_ENABLE(debug,
[  --enable-debug[=ARG]    enable debugging (yes/no)],
[
if test "$enableval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(DEBUG)
  AC_DEFINE(FIST_DEBUG)
else
  AC_MSG_RESULT(no)
fi
],
[
  # default is no debugging
  AC_MSG_RESULT(no)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Which options to add to CFLAGS for compilation?
dnl NOTE: this is only for final compiltions, not for configure tests)
AC_DEFUN(AC_OPT_FIST_CFLAGS,
[AC_MSG_CHECKING(for additional C option compilation flags)
AC_ARG_ENABLE(fist-cflags,
[  --enable-fist-cflags[=ARG]
                          compile package with ARG additional C flags],
[if test "$enableval" = ""; then
  FIST_CFLAGS=""
  AC_SUBST(FIST_CFLAGS)
  AC_MSG_RESULT(none)
else
  # check if fist supplied configure option without argument
  if test "$enableval" = "yes"; then
    FIST_CFLAGS=""
    AC_SUBST(FIST_CFLAGS)
    AC_MSG_RESULT(none)
  else
    # fist supplied a cflags option to configure
    FIST_CFLAGS="$enableval"
    AC_SUBST(FIST_CFLAGS)
    AC_MSG_RESULT($enableval)
  fi
fi], [
  # default is to have no additional C flags
  FIST_CFLAGS=""
  AC_SUBST(FIST_CFLAGS)
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for LDFLAGS (-L options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_LDFLAGS,
[AC_MSG_CHECKING(for configuration/compilation (-L) library flags)
AC_ARG_ENABLE(ldflags,
[  --enable-ldflags[=ARG]  configure/compile with ARG (-L) library flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  LDFLAGS="$LDFLAGS $enableval"
  export LDFLAGS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Initial settings for LIBS (-l options)
dnl NOTE: this is for configuration as well as compilations!
AC_DEFUN(AC_OPT_LIBS,
[AC_MSG_CHECKING(for configuration/compilation (-l) library flags)
AC_ARG_ENABLE(libs,
[  --enable-libs[=ARG]     configure/compile with ARG (-l) library flags],
[if test "$enableval" = ""; then
  # ignore if empty
  AC_MSG_RESULT(none)
else
  # use supplied options
  LIBS="$LIBS $enableval"
  export LIBS
  AC_MSG_RESULT($enableval)
fi], [
  # default is to have no additional flags
  AC_MSG_RESULT(none)
])
])
dnl ======================================================================


dnl ######################################################################
dnl Specify additional compile options based on the OS and the compiler
AC_DEFUN(AC_OS_CFLAGS,
[
AC_CACHE_CHECK(additional compiler flags,
ac_cv_os_cflags,
[
case "${host_os}" in
# 	irix6* )
# 		case "${CC}" in
# 			cc )
# 				# do not use 64-bit compiler
# 				ac_cv_os_cflags="-32 -Wl,-woff,84"
# 				;;
# 		esac
# 		;;
# 	osf4* )
# 		# get the right version of struct sockaddr
# 		case "${CC}" in
# 			cc )
# 				ac_cv_os_cflags="-std -D_SOCKADDR_LEN"
# 				;;
# 			* )
# 				ac_cv_os_cflags="-D_SOCKADDR_LEN"
# 				;;
# 		esac
# 		;;
# 	osf* )
# 		# get the right version of struct sockaddr
# 		case "${CC}" in
# 			cc )
# 				ac_cv_os_cflags="-std -D_SOCKADDR_LEN -D_NO_PROTO"
# 				;;
# 			* )
# 				ac_cv_os_cflags="-D_SOCKADDR_LEN -D_NO_PROTO"
# 				;;
# 		esac
# 		;;
# 	solaris2.6* | sunos5.6* )
# 		# turn on 64-bit file offset interface
# 		case "${CC}" in
# 			* )
# 				ac_cv_os_cflags="-D_LARGEFILE64_SOURCE"
# 				;;
# 		esac
# 		;;
# 	OFF-sunos4* )
# 		# make sure passing whole structures is handled in gcc
# 		case "${CC}" in
# 			gcc )
# 				ac_cv_os_cflags="-fpcc-struct-return"
# 				;;
# 		esac
# 		;;
	* )	ac_cv_os_cflags="" ;;
esac
])
CFLAGS="$CFLAGS $ac_cv_os_cflags"
])
dnl ======================================================================


dnl ######################################################################
dnl Specify additional cpp options based on the OS and the compiler
AC_DEFUN(AC_OS_CPPFLAGS,
[
AC_CACHE_CHECK(additional preprocessor flags,
ac_cv_os_cppflags,
[
case "${host_os}" in

# off for now, posix may be a broken thing for nextstep3...
#	nextstep* )
#		ac_cv_os_cppflags="-D_POSIX_SOURCE"
#		;;
	* )	ac_cv_os_cppflags="" ;;
esac
])
CPPFLAGS="$CPPFLAGS $ac_cv_os_cppflags"
])
dnl ======================================================================


dnl ######################################################################
dnl end of aclocal.m4 for fist-2.0

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AM_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE")
AC_DEFINE_UNQUOTED(VERSION, "$VERSION"))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])


# serial 1

AC_DEFUN(AM_PROG_INSTALL,
[AC_REQUIRE([AC_PROG_INSTALL])
test -z "$INSTALL_SCRIPT" && INSTALL_SCRIPT='${INSTALL_PROGRAM}'
AC_SUBST(INSTALL_SCRIPT)dnl
])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

