#ifndef EC_INCL_EACTH_H
#define EC_INCL_EACTH_H
/* beginning of eacth.h */




	/* ecashlib public headers */
#include "emsg.fh"
#include "einfo.fh"
#include "eacth.fh"
#include "eerrno.fh"
#include "eaddr.fh"
#include "eacth.fh"

#include "eecdef.h"

	
	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "eacth.ih"
#endif
	


	/* Action handler functions */

/* 
 * Note the absense of a public "EC_acth_new()" function.  Instead
 * use "EC_pocket_begin_foo()" to begin an action that will be handled
 * by the resulting EC_ActionHandler.
 */


/*
 * Free the action handler.
 * If this handler's state is not EC_STATE_DONE, then the 
 * EC_ActionHandler will _not_ be freed and EC_acth_free will return 
 * an EC_ERR_ACTH_MANAGEMENT.
 */
EC_EXPORT EC_Errno EC_acth_free(EC_ActionHandler *this_acth_ptr);


/*
 * Abort the current action.
 * If this handler's state is EC_STATE_DONE, then this will return 
 * EC_ERR_ACTH_MANAGEMENT.  There are two possible results from an
 * abort.  One: the state of the client was re-wound so that it is
 * as if the aborted action never happened.  Two: the action was too 
 * far along for that, and it is as if the action was completed.
 * (In the second case, aborting the action caused the action to cease
 * prematurely, after the necessary information had been transmitted, 
 * but before some auxiliary information was transmitted.)
 * After the EC_acth_abort_action() is called, the acth's EC_ERRNO
 * will reflect one of the two results.
 */
EC_EXPORT EC_Errno EC_acth_abort_action(EC_ActionHandler *this_acth_lnk);


/*
 * Get a communication which was passed to the ecashlib by another 
 * ecash application via an EC_Msg.  If the last EC_Msg that was
 * processed by this action handler contained a communication then
 * this call will return that communication.
 */
EC_EXPORT EC_Errno EC_acth_get_communication(
	const EC_ActionHandler *this_acth_lnk, UInt32 *comm_size_out, 
	Byte **comm_ptr_out);



	/* interactions between the action handler and the application */

/*
 * Give a message which has been received to the action handler.
 * The "sender_addr" parameter is optional-- a NULL pointer may
 * be passed instead of the sender's address.
 * Note:  The sender-address is only stored in records-- it is not
 * acted upon by ecashlib.
 * Note: this is only for messages that the action handler is
 * requesting.  If the ecashlib is not in state 
 * EC_STATE_NEED_RECEIVE_MSG, then calling EC_acth_process_msg()
 * generates an EC_ERR_ACTH_MANAGEMENT.
 */
EC_EXPORT EC_Errno EC_acth_process_msg(EC_ActionHandler *this_acth_lnk,
	const EC_Msg *msg_lnk, const EC_Address *sender_addr_lnk);

/*
 * Get the action handler's error state.
 * The return value is the EC_Errno which is contained by the 
 * action handler as a part of its state.
 */
EC_EXPORT EC_Errno EC_acth_get_errno(const EC_ActionHandler *this_acth_lnk);

EC_EXPORT EC_StateType EC_acth_get_state(const EC_ActionHandler *this_acth_lnk);


/* Get a copy of the message to be sent. */
EC_EXPORT EC_Msg *EC_acth_get_msg(EC_ActionHandler *this_acth_lnk);

/*
 * Get the address of an Ecash application to which a message
 * should be sent, or from which a message should be received.
 */
EC_EXPORT EC_Address *EC_acth_get_address(EC_ActionHandler *this_acth_lnk);

/*
 * Get info about the account that this action handler is uses.
 * info_ptr_out: This EC_Info is frozen when the action is completed or
 * aborted, yielding a snap-shot of the state of the account at that 
 * moment.  Calling EC_acth_get_info() before that time is equivalent
 * to calling EC_pocket_get_info().
 */
EC_EXPORT EC_Info *EC_acth_get_info(const EC_ActionHandler *this_acth_lnk);


/* end of eacth.h */
#endif

