#ifndef EC_INCL_ERECORD_H
#define EC_INCL_ERECORD_H
/* beginning of erecord.h */


	/* ecashlib public headers */
#include "eaddr.fh"
#include "erecord.fh"
#include "epocket.fh"
#include "eamount.fh"
#include "eaccid.fh"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "erecord.ih"
#endif




	/* EC_RecordList functions */


/* Read the next record from a record list. */
EC_EXPORT EC_Record *EC_rlist_read_record(EC_RecordList *rlist_lnk);

/* Free a record list. */
EC_EXPORT EC_Errno EC_rlist_free(EC_RecordList *rlist_ptr);

/*
 * Delete all but the last num entries in a record list.
 * Note that once a record has been deleted you can no longer cancel
 * or re-send that payment.  On the other hand it may be wasteful of
 * resources to keep _all_ records forever.  The application should 
 * never call EC_rlist_snip() on records that it might want to
 * cancel or resend, but it _should_ call EC_rlist_snip() on
 * records that it will never want to cancel or resend.
 */
EC_EXPORT EC_Errno EC_rlist_snip(EC_RecordList *rlist_lnk, UInt32 num);



	/* EC_Record functions */


/* Free a record. */
EC_EXPORT EC_Errno EC_rec_free(EC_Record *record_ptr);

/* Find out what kind of record this is. */
EC_EXPORT EC_RecordType EC_rec_get_type(const EC_Record *record_lnk);

/*
 * Get the EC_PaymentRecord from this record.  Returns NULL if
 * called on an EC_Record which is not a payment record.
 */
EC_EXPORT EC_PaymentRecord *EC_rec_get_prec(const EC_Record *record_lnk);

/*
 * Get the EC_Booking from this record.  Returns NULL if called
 * on an EC_Record which is not a booking.
 */
EC_EXPORT EC_Booking *EC_rec_get_booking(const EC_Record *record_lnk);



	/* EC_PaymentRecord functions. */

EC_EXPORT EC_Errno EC_prec_free(EC_Record *record_ptr);

/* Get the payer's address from a payment record. */
EC_EXPORT EC_Address *EC_prec_payer_address(const EC_Record *record_lnk);

/* Get the Account ID of the recipient from a payment record. */
EC_EXPORT EC_AccountID *EC_prec_recip_ID(const EC_Record *record_lnk);

/* Get the amount of the payment from a payment record. */
EC_EXPORT EC_Amount EC_prec_amount(const EC_Record *record_lnk);

/*
 * Get the time of the payment from a payment record.
 * The return value is an unsigned 32-bit integer representing
 * seconds since 00:00:00 UTC Jan. 1, 1970.
 */
EC_EXPORT UInt32 EC_prec_time(const EC_Record *record_lnk);

/* Get the description of the payment from a payment record. */
EC_EXPORT char *EC_prec_desc(const EC_Record *record_lnk);

/* Get the state of a payment from a payment record. */
EC_EXPORT EC_TransactionState EC_prec_get_state(const EC_PaymentRecord *prec_lnk);



	/* EC_Booking functions */

EC_EXPORT EC_Errno EC_book_free(EC_Booking *book_ptr);

/* Get booking type. */
EC_EXPORT EC_BookingType EC_book_get_type(const EC_Booking *book_lnk);

/* Get the amount. */
EC_EXPORT EC_Amount EC_book_amount(const EC_Booking *book_lnk);

/*
 * Get the time the event was initiated.
 * The return value is an unsigned 32-bit integer representing
 * seconds since 00:00:00 UTC Jan. 1, 1970.
 */
EC_EXPORT UInt32 EC_book_start_time(const EC_Booking *book_lnk);

/*
 * Get the time that the event was completed.
 * The return value is an unsigned 32-bit integer representing
 * seconds since 00:00:00 UTC Jan. 1, 1970.
 */
EC_EXPORT UInt32 EC_book_end_time(const EC_Booking *book_lnk);

/* Get the description of the booking. */
EC_EXPORT char *EC_book_desc(const EC_Booking *book_lnk);

/* Get the state of a booking. */
EC_EXPORT EC_TransactionState EC_book_get_state(const EC_Booking *book_lnk);



/* end of erecord.h */
#endif

