#!/bin/sh

export PGPPATH=.
export PGPPASS=TstPas

rm -f tstf*
cp README tstf.pro
cp tstf.pro tstf.ret
if [ ! -e randseed.bin ] ; then cp test.sh randseed.bin; fi

rm -f pubring.pgp secring.pgp tstf.pro.asc tstf.ret

./newkey5 -g 512 -3
mv secnew.skr secnew.pgp
mv pubnew.pkr pubnew.pgp

cp secnew.pgp secring.skr
mv pubring.pkr pubring.sav
cp pubnew.pgp pubring.pkr

pgp -ka secnew.pgp +batchmode +verbose=0 >tstf.log
pgp -ka pubnew.pgp +batchmode +verbose=0 >tstf.log
./lookup5 -z -o testfpb1.pgp
./lookup5 -y -o testfpb2.pgp
./minipgp5 -3 -i testfpb1.pgp -o tstf.sgn -t 16 -A 1 -a 1 -k 0
cat testfpb2.pgp tstf.sgn >tstf.pgp
pgp -ka tstf.pgp +batchmode +verbose=0 | grep "/.*Unknown"
rm -f testfsec.pgp testfpub.pgp testfpb2.pgp pubring.bak secring.bak

pgp -eas tstf.pro Unknown -u Unknown +batchmode +verbose=0 >/dev/null
./minipgp5 -i tstf.pro.asc -o tstf.sgn #dearmor
./minipgp5 -i tstf.sgn -o tstf.out $USEPASS #decrypt
./minipgp5 -i tstf.out -o tstf.sgn #decompress
./minipgp5 -o tstf.out -i tstf.sgn #delit/extract
if cmp tstf.pro tstf.out; then echo decrypt ok; else exit 0; fi

# literal and encryption must seek output file, so cannot use pipe or append
./minipgp5 -i tstf.out -o tstf.c1 -3 -A 1 -a 1 #signature
./minipgp5 -i tstf.out -o tstf.d1x -l tstf.out #literal
./tooldctb <tstf.d1x >tstf.d1
cat tstf.c1 tstf.d1 | ./minipgp5 -o tstf.z1x -z #append sig and compress
./tooldctb <tstf.z1x >tstf.z1

#conventional test
./minipgp5 -i tstf.z1 -x 0 -y 1 -s 1 -a 1 -c -p TstPas -o tstf.px
./tooldctb <tstf.px >tstf.pgp
pgp tstf.pgp -z"TstPas" +batchmode +verbose=0 2>tstf.lg1 >tstf.log
if cmp tstf.pro tstf; then echo convencr ok; else exit 0; fi
rm tstf.pgp tstf

pgp -c tstf.out -o tstf.pgp -z"TstPas" +batchmode +verbose=0 2>tstf.lg2
./minipgp5 -p TstPas <tstf.pgp | ./minipgp5 | ./minipgp5 >tstf.out
if cmp tstf.pro tstf.out; then echo convdecr ok; else exit 0; fi

./minipgp5 -i tstf.z1 -A 1 -a 1 -k 0 -o tstf.a1x
./tooldctb <tstf.a1x >tstf.a1
./minipgp5 -i tstf.a1 -o tstf.asc -m MESSAGE
pgp -f <tstf.asc >tstf.ret +batchmode +verbose=0 2>tstf.log
if grep "Good signature" tstf.log ; then true; else exit 0; fi

./lookup5 -x -o testfpb2.pgp
./lookup5 -u -o testfpb1.pgp
./minipgp5 -3 -o tstf.sgn -i testfpb2.pgp -t 32 -A 1 -a 1 -p "" -k 0
cat testfpb2.pgp tstf.sgn testfpb1.pgp >tstf.pgp
pgp -f +batchmode +verbose=0 <tstf.pgp >tstf.log
if grep "KEY REVOKED" tstf.log ; then echo revoked; else exit 0; fi

rm -f tstf*
mv pubring.sav pubring.pkr
echo 2.6.2 test complete
