#include <stdio.h>
#include <stdlib.h>
#include "libopgp.h"

#define MAXLEN 32768

unsigned int PGP_nxpkt(int *neof, FILE * inf)
{
  unsigned int k, ll;

  *neof = 0;
  if ((ll = fgetc(inf)) >= 0xc0) {
    if (ll == 0xff)
      for (k = 0, ll = 0; k < 4; k++)
        ll = (ll << 8) + fgetc(inf);
    else if (ll >= 0xe0)
      ll = 1 << (ll & 31), *neof = 1;
    else
      ll = ((ll & 31) << 8) + 192 + fgetc(inf);
  }
  return ll;
}

void *PGP_gtpkt(FILE * inf, UCHAR ctb, int *gaz)
{
  unsigned int ll;
  int neof = 0, i, k;
  UCHAR *bufptr, *bp;
  unsigned long gazouta;

  gazouta = 0;
  if (ctb < 0xc0) {
    i = 1 << (ctb & 3);         /* length of length */
    for (k = 0, ll = 0; k < i; k++)
      ll = (ll << 8) + fgetc(inf);
  } else
    ll = PGP_nxpkt(&neof, inf);
  if (ll > MAXLEN || !ll)
    return NULL;
  bufptr = malloc(neof ? MAXLEN + 1 : ll + 1);  /* +1 to add final null */

  bp = bufptr;
  for (;;) {
    gazouta += ll;
    if (gazouta > MAXLEN) {
      if (0 >= (i = fread(bp, 1, MAXLEN - gazouta, inf)))
        exit(-2);
      gazouta += i - ll;
      ll = 0, neof = 0;
    }
    while (ll) {
      if (0 >= (i = fread(bp, 1, ll, inf)))
        exit(-2);
      ll -= i, bp += i;
    }
    if (!neof) {
      bufptr[gazouta] = 0;
      if (gaz)
        *gaz = gazouta;
      return bufptr;
    }
    ll = PGP_nxpkt(&neof, inf);
  }
}
