#include <stdio.h>
#include <string.h>
#include "libopgp.h"
#include <zlib.h>

#define BSIZ 10240

int PGP_unzip(FILE * inf, FILE * outf)
{
  unsigned int neof, ll;
  int got, firstflag = 0, k;
  unsigned char ibuf[BSIZ], obuf[BSIZ];
  z_stream pgpz;

  memset(&pgpz, 0, sizeof(pgpz));
  inflateInit2(&pgpz, -15);
  ll = fgetc(inf);
  if ((ll & 0xfc) == 0xa0) {    /* Old CTB type */
    if (ll != 0xa3)             /* bypass length if it exists */
      fread(ibuf, 1, 1 << (ll & 3), inf);
    if (fgetc(inf) != 1)
      return -1;
    do {
      pgpz.next_in = ibuf;
      pgpz.avail_in = got = fread(ibuf, 1, BSIZ, inf);
      while (pgpz.avail_in || got != BSIZ) {
        pgpz.next_out = obuf, pgpz.avail_out = BSIZ;
        k = inflate(&pgpz, got == BSIZ ? 0 : Z_FINISH);
        fwrite(obuf, 1, BSIZ - pgpz.avail_out, outf);
        if (k != Z_OK)
          break;
      }
    } while (got == BSIZ);
    return (k == Z_STREAM_END);
  }
  if (ll != 0xc8)
    return -1;
  ll = 0, neof = 1, firstflag = 1;
  while (!feof(inf) && neof) {
    if (!ll && neof)
      ll = PGP_nxpkt(&neof, inf);
    while (ll) {
      if (firstflag)            /* snag algorithm byte */
        firstflag = 0, ll--, k = fgetc(inf);
      if (0 > (got = fread(ibuf, 1, ll > BSIZ ? BSIZ : ll, inf)))
        break;
      ll -= got;
      pgpz.next_in = ibuf, pgpz.avail_in = got;
      while (pgpz.avail_in || !(ll || neof) || feof(inf)) {
        pgpz.next_out = obuf, pgpz.avail_out = BSIZ;
        k = inflate(&pgpz, neof || !feof(inf) ? 0 : Z_FINISH);
        fwrite(obuf, 1, BSIZ - pgpz.avail_out, outf);
        if (k != Z_OK)
          break;
      }
    }
  }
  return 0;
}
