// PGPBase64InputStream.java

import java.io.*;

public class PGPBase64InputStream extends Base64InputStream {
DataInputStream datais;

public PGPBase64InputStream(InputStream is)
    throws IOException
{
    super(is, true);
    datais = (is instanceof DataInputStream)?(DataInputStream)is:
    		new DataInputStream(is);
    for ( ; ; ) {
	String line = datais.readLine();
	if (line==null)
	    throw new IOException("PGP packet not found");
	if (line.startsWith("-----BEGIN PGP"))
	    break;
    }
    for ( ; ; ) {
	String line = datais.readLine();
	if (line==null)
	    throw new IOException("PGP packet header separator line not found");
	if (line.length() < 2)
	    break;
    }
}


public void close() throws IOException
{
    super.close();
    for ( ; ; ) {
	String line = datais.readLine();
	if (line==null)
	    throw new IOException ("PGP end of packet line not found");
	if (line.startsWith("-----END PGP"))
	    break;
    }
    datais.close();
}

}
