/*------------------------------------------------------------------------------*/
/* LZS221-PPP Version 3.01 Release                                              */
/*------------------------------------------------------------------------------*/
/* LZSC.H                                                                       */
/*  Function prototypes and constants.                                          */
/*------------------------------------------------------------------------------*/
/* hi/fn (R), LZS (R)                                                           */
/* (c) 1988-1993, hi/fn                                                         */
/* Includes one or more U.S. Patents:                                           */
/*   No. 4701745, 5016009, 5126739, 5146221, and 5414425.                       */
/*   Other patents pending                                                      */
/*------------------------------------------------------------------------------*/
/* Engineering Sequence Number                                                  */
/*  3001                                                                        */
/*------------------------------------------------------------------------------*/

/* $Id: LZSC.H,v 1.2 1999/01/18 21:45:58 dgal Exp $	*/

#include	"pgpBase.h"

typedef struct LZSContext		LZSContext;
typedef struct LZSContext *		LZSContextRef;

/*
******************************************************************************
*
* Block Name:        Target Processor Identification Macro
*
* Functional Block:  LZS221-PPP
*
* Special Notes:     User should select a compiler type from this list
*
*****************************************************************************/

#define	LZS_ANSI			1		/* February 1990 ANSI */
#define	LZS_INTEL_86		2		/* Borland C++ 3.1 */

#define	LZS_TARGET			LZS_ANSI	/* selected from the list above */

/*

****************************************************************************
*
* Block Name:        Processor Specific Data Types
*
* Functional Block:  LZS221-PPP
*
* Special Notes:
*
*****************************************************************************/

#if		LZS_TARGET == LZS_ANSI

#define	LZS_FAR
#define	LZS_HANDLE			* *

#elif	LZS_TARGET == LZS_INTEL_86

#define	LZS_FAR				far
#define	LZS_HANDLE			far * far *

#endif


/*

****************************************************************************
*
* Block Name:	Shorthand Declarations
*
* Functional Block: LZS221-PPP
*
* Special Notes:	
*
*****************************************************************************/

/* shorthand declarations */			/* size assumptions */

/*

****************************************************************************
*
* Block Name:        Symbolic Constants
*
* Functional Block:  LZS221-PPP
*
* Special Notes:
*
*****************************************************************************/


/* Bit definitions for the flags parameter */

#define		LZS_NO_CLEAR			0x04
#define		LZS_DEST_FLUSH			0x02
#define		LZS_SOURCE_FLUSH		0x01

#define		LZS_RESET				0x01


/* Return codes */

#define	LZS_INVALID					0
#define	LZS_SOURCE_EXHAUSTED		1
#define	LZS_DEST_EXHAUSTED			2
#define	LZS_SOURCE_DEST_EXHAUSTED	3
#define LZS_FLUSHED					4	/* flushed at end of compression	*/
#define LZS_END_MARKER				4	/* hit eocd during decompression	*/


/* Other */

#define	LZS_DEST_MIN				15

#define	LZS_HISTORY_SIZE			24760	/* Size of history scratch RAM */


/*

****************************************************************************
*
* Block Name:        Performance Tuning Declarations
*
* Functional Block:  LZS221-PPP
*
* Special Notes:     The speed and compression ratio of the LZS_Compress
*					 function can be tuned by adjusting the values of the
*					 performance parameter and the LZS_PERFORMANCE_MODE
*					 bits of the flags parameter.  Valid values for the
*					 performance parameter are 0 thru 255.  Valid values
*					 for the LZS_PERFORMANCE_MODE BITS are 0 thru 2.
*					 Setting these parameters to the lowest possible values
*					 results in the fastest speed.  Setting these parameters
*					 to the highest possible values results in the
*					 greatest compression ratios.
*
*****************************************************************************/

/* Possible settings for the performance mode flag bits */

#define	LZS_PERF_MODE_0			0X0000
#define LZS_PERF_MODE_1			0x0008
#define LZS_PERF_MODE_2			0x0010

#define	LZS_PERF_SHIFT			3	/* # of positions to shift performance	*/
									/* mode bits for right justification	*/

#define	LZS_PERF_MASK			0X0018	/* mask for extracting performance	*/
										/* mode bits						*/


/*

*****************************************************************************
*
* Block Name:        Function Prototypes
*
* Functional Block:  LZS221-PPP
*
* Special Notes:
*
*****************************************************************************/

PGPUInt32 LZS_GetContextSize(void);

void LZS_FAR LZS_InitHistory(
							LZSContextRef	context,
							void LZS_FAR	*scratch
							);


PGPUInt16	 LZS_FAR	LZS_Compress(
									LZSContextRef			 context,
									PGPUInt8	LZS_HANDLE	 sourceHandle,
									PGPUInt8	LZS_HANDLE	 destHandle,
									PGPUInt32	LZS_FAR		*sourceCount,
									PGPUInt32	LZS_FAR		*destCount,
									void		LZS_FAR		*scratch,
									PGPUInt16				 flags,
									PGPUInt16				 performance
									);


PGPUInt16	 LZS_FAR	LZS_Decompress(
									  LZSContextRef				 context,
									  PGPUInt8		LZS_HANDLE 	 sourceHandle,
									  PGPUInt8		LZS_HANDLE 	 destHandle,
									  PGPUInt32		LZS_FAR		*sourceCount,
									  PGPUInt32		LZS_FAR		*destCount,
									  void			LZS_FAR		*scratch,
									  PGPUInt16				   	 flags
									  );


/****************************************************************************
*							End - of - File									*
****************************************************************************/

