


FILTER(1L)        MISC. REFERENCE MANUAL PAGES         FILTER(1L)



NAME
     filter - filter incoming messages before adding to mailbox

SYNOPSIS
     filter [-q] [-v] [-l] [-o output] [-f rules-file]
     filter [-n] [-f rules-file]
     filter [-r] [-o output] [-f rules-file]
     filter [-c] [-s] [-o output] [-f rules-file]
     filter [-c] [-S] [-o output] [-f rules-file]

DESCRIPTION
     _F_i_l_t_e_r uses a set of selection  rules  to  process  incoming
     mail  messages.   The  format  for  the  rules,  located  in
     $HOME/.elm/filter-rules, is;

             _r_u_l_e  ::=  if  (_e_x_p_r_e_s_s_i_o_n)  then  _a_c_t_i_o_n

     where _e_x_p_r_e_s_s_i_o_n is:

             _e_x_p_r_e_s_s_i_o_n  ::=  {  not  }  _c_o_n_d_i_t_i_o_n  _e_x_p_r_2

             _e_x_p_r_2  ::=  _N_U_L_L  |  and  _c_o_n_d_i_t_i_o_n  _e_x_p_r_2

             _c_o_n_d_i_t_i_o_n  ::=  _f_i_e_l_d  _r_e_l_a_t_i_o_n_s_h_i_p  _v_a_l_u_e
                        ::=  lines  _r_e_l_o_p  _n_u_m_v_a_l_u_e
     or                 ::=  always

     These further break down as:

             _f_i_e_l_d  ::=  from  |  subject  |  to  |  lines | sender

             _r_e_l_a_t_i_o_n_s_h_i_p  ::=  =  |  !=

             _r_e_l_o_p  ::=  =  |  !=  |  <  |  >  |  <=  |  >=

             _v_a_l_u_e  ::=  _a_n_y  _q_u_o_t_e_d  _s_t_r_i_n_g

             _n_u_m_v_a_l_u_e  ::=  _a_n_y  _i_n_t_e_g_e_r  _v_a_l_u_e

     _A_c_t_i_o_n can be any of:

             delete
             save  _f_o_l_d_e_r_n_a_m_e
             savecopy _f_o_l_d_e_r_n_a_m_e
             execute  _c_o_m_m_a_n_d
             executec  _c_o_m_m_a_n_d
             forward  _a_d_d_r_e_s_s
             leave

     For further information about the rules language, please see
     _T_h_e _E_l_m _F_i_l_t_e_r _G_u_i_d_e.




USENET Community TrustLast change: Elm Version 2.4                 1






FILTER(1L)        MISC. REFERENCE MANUAL PAGES         FILTER(1L)



     The flags the _f_i_l_t_e_r program understands are;

     -c        Clear logs.  If this flag is used, the  log  files
               will  be  removed after being summarized by either
               "-s" or "-S" (see below).

     -f _r_u_l_e_s-_f_i_l_e
               Get rules from specified file instead  of  default
               $HOME/.elm/filter-rules

     -l        Log actions only.  Do not  log  information  about
               mailed messages.

     -n        Not really.  Output what  would  happen  if  given
               message from standard input, but don't actually do
               anything with it.

     -o _f_i_l_e   Redirect stdout messages to the specified file  or
               device.    Logging   of   filter  actions  is  not
               affected.  (This is added to more gracefully  deal
               with changes in the file system (since sendmail is
               quite picky about modes of files being  redirected
               into.))

     -q        Quiet.  Do not log filtering actions.

     -r        Rules.  List the rules currently being used.

     -s        Summarize.  List a summary of the message  filter-
               ing log.

     -S        This is the same as `-s' but includes  message-by-
               message information additionally.

     -v        Verbose.  Give output on  standard  out  for  each
               message  filtered.   Useful  to have redirected to
               ``/dev/console'' and such.  (see -o too).

AUTHOR
     Elm Development Group

FILES
     $HOME/.elm/filter-rules     Default rules file
     $HOME/.elm/filterlog        A log of what has been done
     $HOME/.elm/filtersum        A summary of what has been done
     /etc/passwd             Used to get users home directory

SEE ALSO
     _T_h_e _E_l_m _F_i_l_t_e_r _G_u_i_d_e
     readmsg(1L), elm(1L), mail(1), mailx(1), sendmail(1,8)





USENET Community TrustLast change: Elm Version 2.4                 2






FILTER(1L)        MISC. REFERENCE MANUAL PAGES         FILTER(1L)



COMMENTS
     Not really smart about pattern matching.

BUG REPORTS TO
     Syd Weinstein  elm@DSI.COM    (dsinc!elm)

COPYRIGHTS
     Copyright 1988-1992 by The USENET Community Trust
     Derived from Elm 2.0,  Copyright 1986, 1987 by Dave Taylor














































USENET Community TrustLast change: Elm Version 2.4                 3



