#  This is version 1.1 of Crowds
# 
#  The authors of this software are Mike Reiter and Avi Rubin
#               Copyright (c) 1997 by AT&T.
#  Permission to use, copy, and modify this software without fee is
#  hereby granted, provided that this entire notice is included in all
#  copies of any software which is or includes a copy or modification
#  of this software and in all copies of the supporting documentation
#  for such software.
# 
#  SOME PARTS OF CROWDS MAY BE RESTRICTED UNDER UNITED STATES EXPORT
#  REGULATIONS.
# 
#  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
#  IMPLIED WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE
#  ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
#  MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR
#  PURPOSE.

# This package is used to check whether or not timestamps fall within
# a proper interval. We chose one hour.

package TimeStamp;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(check_time);

my $interval=3600;   # Default to a one hour interval


#This routine return 1 if the test_time is within the
#proper interval and 0 if the interval has passed.

sub check_time {
   my ($test_time) = @_;
   my $real_time = time();

   if ( ($test_time + $interval) >= $real_time) {
      return 1;
   } else {
      return 0;
   }

}
      




