#!/weblab/software/bin/perl -w

#  This is version 1.1 of Crowds
# 
#  The authors of this software are Mike Reiter and Avi Rubin
#               Copyright (c) 1997 by AT&T.
#  Permission to use, copy, and modify this software without fee
#  is hereby granted, provided that this entire notice is included in
#  all copies of any software which is or includes a copy or
#  modification of this software and in all copies of the supporting
#  documentation for such software.
# 
#  SOME PARTS OF CROWDS MAY BE RESTRICTED UNDER UNITED STATES EXPORT
#  REGULATIONS.
# 
# 
#  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
#  WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
#  REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
#  OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.


# This package is used to create a new account database. The word
# 'KEYWORD' is encrypted using the new passphrase so that correct
# values of the passphrase can be identified for administrative functions.

require 5.004;

use strict;
use Socket;
use Carp;
use BlockCipher;

sub logmsg;


my $filename = "accounts";
my %Accounts;


my ($new_name) = @_;
my $entry;
my $enc_entry;
my $passphrase1;
my $passphrase2;
my $new_cipher;
my $my_key;
my $my_block_cipher;
my $name;
my $pw;


$passphrase1 = 1;
$passphrase2 = 2;
while ($passphrase1 ne $passphrase2) {

    print "Enter admin passphrase for new file: ";
    system "stty -echo";
    chop($passphrase1 = <STDIN>);
    print "\n";
    print "Enter passphrase again for confirmation: ";
    chop($passphrase2 = <STDIN>);
    print "\n";
    system "stty echo";
    
    if  ($passphrase1 ne $passphrase2) {
	print "Passphrase mismatch, try again.\n";
    }
}

$my_key = pack("a8", $passphrase1);
$new_cipher = BlockCipher::new($my_key);


dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";

# Remove any existing accounts
undef %Accounts;

$Accounts{KEYWORD} = $new_cipher->cbc_encrypt("KEYWORD");
dbmclose %Accounts;

print "New accounts file $filename created.\n";


