/****************************************************************************
  This file is part of the Freedom Remailer.  It is:
  Copyright (C) 1996  Andy Dustman (andy@CCMSD.chem.uga.edu)
  Changes are (C) 1997 Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

/***************************************************************************
To test out the "esub" feature, send your remailer something like this:

================================================================
From: myself

::
Anon-To: myself
Encrypt-Subject: Squeamish

##
Subject: Lovely_SPAM

What a peculiar subject.

================================================================

Then, when you get the message, run testcrypt and enter:
the key [Squeamish]
the plaintext subject [Lovely_SPAM]
the encrypted subject
...
[EOF]

The program only kicks out the hex codes for the plaintext
you entered and decoded ciphertext; if you want to compare
things, write your own code or use the wetware.
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "idea.h"
#include "md5.h"

void
printbytes(const unsigned char* bytes, const int count)
{
  int i;

  for (i = 0; i < count; i++)
    printf("%2.2hx", *(bytes + i));
  return;
}

void
scanbytes(const char* buf, unsigned char* bytes, const int count)
{
  int i;
  char s[]="0xxx" ;

  for (i = 0; i < count; i++) {
    s[2] = *(buf + 2*i) ;
    s[3] = *(buf + 2*i + 1) ;
    *(bytes + i) = (unsigned char) strtol(s, NULL, 16);
  }
  return;
}

int
main(void)
{ /* IDEA-encrypt MD5-hash of subject line with MD5-hash of subjkey */
  struct MD5Context subjkeyDigest, subjectDigest ;
  struct IdeaCfbContext subjcontext ;
  char subjkey[80], input[80], ctbuf[80] ;
  unsigned char subjIDEAkey[16], subjPT[16] ;
  unsigned char subjPT2[24], subjCT[24] ; /* includes IV */

  fgets(subjkey, sizeof(subjkey), stdin);
  subjkey[strlen(subjkey) - 1] = '\0';
  fgets(input, sizeof(input), stdin);
  input[strlen(input) - 1] = '\0';
  MD5Init(&subjkeyDigest);
  MD5Update(&subjkeyDigest, subjkey, strlen(subjkey));
  MD5Final(subjIDEAkey, &subjkeyDigest);
  MD5Init(&subjectDigest);
  MD5Update(&subjectDigest, input, strlen(input));
  MD5Final(subjPT, &subjectDigest);
  printf("Subject digest: ");
  printbytes(subjPT, 16);
  putc('\n', stdout);
  while (fgets(ctbuf, sizeof(ctbuf), stdin)) {
    scanbytes(ctbuf, subjCT, 24);
    ideaCfbInit(&subjcontext, subjIDEAkey);
    ideaCfbDecrypt(&subjcontext, subjCT, subjPT2,24);
    ideaCfbDestroy(&subjcontext);
    printf("Subject: ");
    printbytes(subjPT2 + 8, 16);
    putc('\n', stdout);
  }
  return 1;
}
