/*
 * send.c        1.6 11/2/95
 *	Fixed several bugs in process_partial()
 *	Insert commas between recipients on the To line.
 *	Fixed problems from not re-initializing some variables
 *	for each mail message.
 *
 * send.c        1.5 9/13/95
 *	Mail2news now uses "Newsgroups:" not group.name@gateway.
 *
 * send.c        1.4 9/10/95
 *	"null:" sends mail to a bit bucket
 *	"post:" posts to the following newsgroup
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include "mixmaster.h"
#include "crypt.h"


#include <sys/file.h>

#ifndef LOCK_SH
#define LOCK_SH 1    /* shared lock */
#define LOCK_EX 2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif


int	mix_server()
{
	return(1); /* dummy which always reports failure (true) */
}

int	attempt_socket(fp)
FILE	*fp;
{
	return(1); /* dummy which always reports failure (true) */
}

int process_pool()
{
	FILE	*fptr,*in;
	char	name[80],temp[256],*names[256],*foo, line[256];
	int	i,j,k,final, gateway_flag, subject;
	unsigned char bar;
	BUFFER	*maildest, *groupdest, *buff, *mess;

	update_random();
	do {
	  final = 0;
	  gateway_flag = 0;
	  subject = 0;
	  i = file_list("mail*", names);
	  if(i>POOLSIZE) {
	    j = (our_randombyte() % i) ; /* 0 to (i-1) */
	    in = fopen(names[j],"r");
	    if(in == NULL) return(0);

	    maildest = new_buffer();
	    groupdest = new_buffer();
	    buff = new_buffer();

	    /* Is it a final hop? */
	    fgets(name,255,in); 
	    if(strstr(name,final_hop)) {
	       final = 1;
	    } else {
	       /* is it also not an intermed hop ? */
	       if(!strstr(name,intermed_hop)) {
	          fclose(in);
	          strcpy(name,"bad-");
	          in = tempfile(name);
	          fprintf(in,"Placeholder\n");
	          fclose(in);
	          fprintf(stderr,"%s not a valid mail file!\n",names[j]);
	          fprintf(stderr,"Moving to %s\n",name);
	          sprintf(line,"/bin/mv %s %s",names[j],name);
	          /* I am using popen not system because it is rumored to
	             be more secure. I would use exec but it is such a pain
	             in the but to do that just to move a file
	          */
	          in = popen(line,"w");
	          pclose(in);
	          goto endofloop; /* Try another mail file */
	       }
	    }

	    if(!final) {
	       /* This is a dummy op. No socket support in this version */
	       final = attempt_socket(in); /* try to open a socket */ 
	    }
	    if(!final) goto skip; /* attemp socket returns true if it fails */

	    /* Read in the destination line */
	    fgets(name,255,in); /* this is the destination */
	    while(!strstr(name,"END\n")) {
	       name[strlen(name)-1] = 0; /* strip return */
	       SafeToLowerStr(name);
	       /*
	       for(k=0;k<strlen(name);k++) {
	          safe_tolower(name[k]);
	       }
	       */
	       foo = name;
	       if(destination_block(1,&foo)) { /* last blocking check */
	          add_to_buffer(maildest,"null:",6); /* bit bucket message */
	       }
	       if(strstr(name,"post: ")) {	 /* group address */
	         if( strstr(NEWS,"mail-to-news") && strlen(MAILtoNEWS) > 2 && !gateway_flag) {
	             /* add gateway to the list of destinations if it is not already there */
		     if(maildest->length > 1) {
	               add_to_buffer(maildest,", ",2);
		     }
	             add_to_buffer(maildest,MAILtoNEWS,strlen(MAILtoNEWS));
	             gateway_flag = 1; /* don't add the gateway nextime */
	          }
	          /* put a comma infront of the group unless it is first */
	          if(groupdest->length > 1) {
	             add_to_buffer(groupdest,", ",2);
	          }
	             add_to_buffer(groupdest,name+6,strlen(name)-6);
	       } else {
	          if(maildest->length > 1) {
	            add_to_buffer(maildest,", ",2); 
		  }
	          add_to_buffer(maildest,name,strlen(name));
	       }
	       if(fgets(name,255,in)==NULL) break; /* get next destination line */
	    }

	    if(strstr(maildest->message,"null:")) goto skip; /* bit bucket message */

	    mess = new_buffer();
	    while(fgets(temp,255,in)!=NULL){
	      if(subject == 0) {
	        if(strncmp(temp,"Subject: ",strlen("Subject: ")) == 0 ) subject = 1;
	        if(strncmp(temp,"\n",1) == 0 ) subject = -1;
	      }
	      add_to_buffer(mess,temp,strlen(temp));
	    }

	    clear_buffer(buff);
	    if(maildest->length > 1) {  /* There are mail addresses */

	       fptr = popen(SENDMAIL,"w");
	       if(fptr == NULL) return(-1);
	       fprintf(fptr,"To: %s^chain=2^alpha=middle-man\n",maildest->message); /* add a To: headder line */
	       if(gateway_flag) { /* mail to news being used */
		 fprintf(fptr,"Newsgroups: %s\n",groupdest->message);
	       }
	       /* Must have a subject */
	       if(subject <= 0) {
	          fprintf(fptr,"Subject: None\n");
	       }

               fwrite(mess->message,1,mess->length,fptr);
               pclose(fptr);
     	    }

	    clear_buffer(buff);
	    if(groupdest->length > 1 && strlen(NEWS) > 1 && !gateway_flag) {  /* Post through inews */

	       add_to_buffer(buff,NEWS,strlen(NEWS));

	       fptr = popen(buff->message,"w");
	       if(fptr == NULL) return(-1);
	       /* put the groups in the newsgroups header */
	       fprintf(fptr,"Newsgroups: %s\n",groupdest->message);

	       /* Must have a subject */
	       if(subject <= 0) {
	          fprintf(fptr,"Subject: None\n");
	       }
               fwrite(mess->message,1,mess->length,fptr);
               pclose(fptr);
     	    }

     	    skip: 0;	/* Skip to here if message is for bit bucket */
	    fclose(in);
	    unlink(names[j]);
	  }
	  endofloop: 0;
	} while(i-1 > POOLSIZE);
	return(1);
}

int process_latent()
{
	int	num,i;
	unsigned ctime, stime;
	FILE	*fptr,*out;
	char	*names[256],line[256],foo[80];

	num = file_list("latent*",names);
	for(i=0;i<num;i++) {
	  if((fptr = fopen(names[i],"r"))!=NULL) {
	    fgets(line,255,fptr);
	    sscanf(line,"%s %u",foo,&stime);
	    ctime = time(NULL);
	    if(ctime > stime) {
	      /* now open up a mail file and put the body there */
	      sprintf(foo,"mail");
	      if((out = tempfile(foo))!=NULL){
		while(fgets(line,255,fptr)!=NULL) fputs(line,out);
	        fclose(out);
	      }
	    fclose(fptr);
	    unlink(names[i]);
	    } /* passed time */
	  } /* if could open latent */
	} /* for */
}


int process_partial()
{
	int	num,i;
	unsigned char j;
	unsigned ctime, stime;
	struct timeval timestamp;
	FILE	*fptr,*out,*lockptr;
	char	*names[256],line[256],foo[80];

	mix_lock("pac",&lockptr);
	num = file_list("pac*",names);
	for(i=0;i<num;i++) {
	  if((fptr = fopen(names[i],"r"))!=NULL) {
	    fread(&j,1,1,fptr);
	    stime = (unsigned)j;
	    fread(&j,1,1,fptr);
	    stime += (unsigned)j * 256;
	    fread(&j,1,1,fptr);
	    stime += (unsigned)j * 256 * 256;
	    fread(&j,1,1,fptr);
	    stime += (unsigned)j * 256 * 256 * 256;

	    gettimeofday(&timestamp,0);
	    ctime = timestamp.tv_sec;

	    if((ctime - stime) > PACKETEXP){ /* packet is too old */
	      fclose(fptr);
	      unlink(names[i]);
	    } else {
	      fclose(fptr);
	    } /* passed expiration time */
	  } /* if could open packet */
	} /* for */
	mix_unlock("pac",lockptr);
}

int packetID_housekeeping()
{
        FILE    *fptr,*lockptr;
        char    line[256],ID[50];
	struct timeval timestamp;
        unsigned i,now,then;
	BUFFER	*buff;

	mix_lock(IDLOG,&lockptr);
	buff = new_buffer();
        gettimeofday(&timestamp,0);
        now = timestamp.tv_sec;
	if((fptr = open_mix_file(IDLOG,"r")) == NULL) return(-1);
	
	while(fgets(line,255,fptr)!=NULL) {
          sscanf(line,"%s %u", ID, &then);
	  if((now-then) < IDEXP) 
		add_to_buffer(buff,line,strlen(line));
	}
	fclose(fptr);
	if((fptr = open_mix_file(IDLOG,"w")) == NULL) return(-1);
	fwrite(buff->message,1,buff->length,fptr);
	fclose(fptr);
	free_buffer(buff);
	mix_unlock(IDLOG,lockptr);
}
