/*
 * type2.c        2.6 11/2/95
 *	Destination and subject fields filled out
 *	with nulls to ensure no leakage of information.
 *	new command line flag -O.
 *	  same as -o but puts a "To: " line at the top
 *
 * type2.c        2.5 9/20/95
 *	Remailer choice of 0 causes mixmaster to choose a remailer
 *	at random from type2.list
 *
 * type2.c        2.4 9/10/95
 *	Change sendmail calls to use To: in body, not command line.
 *
 *
 * type2.c        2.3 5/10/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include <stdio.h> 
 
#include <string.h>

#ifndef i386
#include <malloc.h>
#endif

#include "mixmaster.h" 
#include "crypt.h" 
#include "des.h"

#include <sys/file.h>

#ifndef LOCK_SH
#define LOCK_SH 1    /* shared lock */
#define LOCK_EX 2    /* exclusive lock */
#define LOCK_NB 4    /* don't block when locking */
#define LOCK_UN 8    /* unlock */
#endif


int merge_packets(BUFFER *body, byte *messageID, byte packet, byte numpackets)
{
	char	line[1024],foo[256], *destination[256], *subject[256];
	char	filename[256];
	FILE	*new, *old, *out, *lockptr,*lockptr2;
	int	i,j,k,status,tmpint;
	unsigned char	fileID[16],tmparray[256];
	struct timeval	then,now;
	long int	length, tmplength,seconds;
	byte	len[4],tmp,*byteptr,arrived,numdest,numsub;
	BUFFER	*buff;


	/* open mail file */
	sprintf(filename,"pac%02x%02x%02x%02x%02x%02x",
	  messageID[0],messageID[1],messageID[2],messageID[3],
	  messageID[4],messageID[5]);

	if((old = open_mix_file(filename,"r+"))!=NULL) { /* if file exists */
	  strcpy(foo,"tmp1");
	  if((out = tempfile(foo))==NULL)  return(-1);
	  fread(tmparray,4,1,old); /* dump old time stamp */
	  fread(fileID,16,1,old);
	  /* Check message ID */
	  if(R_memcmp(fileID,messageID,16)!=0) {
	    fprintf(stderr,"messageID does not match fileID!\n");
	    fclose(old);
	    fclose(out);
	    unlink(foo);
	    return(-2);
	  }

	  gettimeofday(&now,0);
	  seconds = now.tv_sec;
/*	  tmparray[0]= seconds % 256; /* low byte */
	  tmparray[0]= seconds & 0xFF; /* low byte */
	  seconds = seconds / 256;
/*	  tmparray[1]= seconds % 256; /* second */
	  tmparray[1]= seconds & 0xFF; /* second */
	  seconds = seconds / 256;
/*	  tmparray[2]= seconds % 256; /* third */
	  tmparray[2]= seconds & 0xFF; /* third */
	  seconds = seconds / 256;
/*	  tmparray[3]= seconds % 256; /* high byte */
	  tmparray[3]= seconds & 0xFF; /* high byte */

	  fwrite(tmparray,4, 1, out); /* write new timestamp */
	  fwrite(messageID,16,1,out);

	  fread(&numpackets,1,1,old);
	  fwrite(&numpackets,1,1,out);

	  fread(&arrived,1,1,old);
	  arrived++;
	  fwrite(&arrived,1,1,out);

	  fread(&tmp,1,1,old); /* get packet number */
	  j=1;
	  while(tmp<packet && j < arrived) {
	    j++;  /* this keeps us from running off the end of the file */
	    fwrite(&tmp,1,1,out);
	    fread(len,4,1,old);
	    fwrite(len,4,1,out);
	    length = len[3];
	    length = length * 256 + len[2];
	    length = length * 256 + len[1];
	    length = length * 256 + len[0];

	    /* move the this packet to the out file */
	    while(length > 0) {
	       tmpint = length % 1024;
	       if (tmpint==0) tmpint=1024;
	       fread(line,tmpint,1,old);
	       fwrite(line,tmpint,1,out);
	       length -= tmpint;
	    }
	    fread(&tmp,1,1,old); /* get next packet number */
	  }

	  if(tmp == packet) {
	    fprintf(stderr,"Problem! Packet number collision!\n");
	    fclose(old);
	    fclose(out);
	    unlink(foo);
	    return(-4);
	  }
	  /* put the new packet in the out file */
	  fwrite(&packet,1,1,out);
	  byteptr = body->message;
	  fwrite(byteptr,4,1,out); /* write the length */
	  length = byteptr[3];
	  length = length * 256 + byteptr[2];
	  length = length * 256 + byteptr[1];
	  length = length * 256 + byteptr[0];
	  fwrite((body->message) + 4 , length, 1, out);

	  while(j < arrived) {
	    j++;  /* this keeps us from running off the end of the file */
	    fwrite(&tmp,1,1,out);
	    fread(len,4,1,old);
	    fwrite(len,4,1,out);
	    length = len[3];
	    length = length * 256 + len[2];
	    length = length * 256 + len[1];
	    length = length * 256 + len[0];
	    /* move the this packet to the out file */
	    while(length > 0) {
	       tmpint = length % 1024;
	       if (tmpint==0) tmpint=1024;
	       fread(line,tmpint,1,old);
	       fwrite(line,tmpint,1,out);
	       length -= tmpint;
	    }
	    fread(&tmp,1,1,old);
	  }
	  fclose(old);
	  if(arrived < numpackets) {
	    if((new = open_mix_file(filename,"w"))==NULL) return(-3);
	    /* move the this packet to the out file */
	    rewind(out);
	    while((length=fread(line,1,1024,out)) > 0) {
	       fwrite(line,length,1,new);
	    }
	    fclose(out);
	    unlink(foo);
	    fclose(new);
	  
	  } else { /* we have the whole message now */
	    unlink(filename); 
	    strcpy(filename,"tmp2");
	    if((new = tempfile(filename))==NULL) return(-3);
	    rewind(out);
	    fread(tmparray,1, 4,out); /* dump time stamp */

	    fread(fileID,1,16,out);
	    fread(&numpackets,1,1,out);
	    fread(&arrived,1,1,out);
	    for(i=1; i<= numpackets;i++) {
	      fread(&tmp,1,1,out);
              fread(len,1,4,out);
              length = len[3];
              length = length * 256 + len[2];
              length = length * 256 + len[1];
              length = length * 256 + len[0];
	      /* move the this packet to the out file */
	      while(length > 0) {
	         tmpint = length % 1024;
	         if (tmpint==0) tmpint=1024;
	         fread(line,tmpint,1,out);
	         fwrite(line,tmpint,1,new);
	         length -= tmpint;
	      }
	    }
	    fclose(out);
	    unlink(foo); /* out file */

	    /* ok, whole message is in new now */
	    rewind(new);
            /* get destination list */
	    fread(&numdest,1,1,new);
            for(i=0;i<numdest;i++) {
              destination[i] = (char *) malloc(80 * sizeof(char));
              fread(destination[i],80,1,new);
            }
	    fread(&numsub,1,1,new);
            for(i=0;i<numsub;i++) {
              subject[i] = (char *) malloc(80 * sizeof(char));
              fread(subject[i],80,1,new);
            }

	    if(destination_block(numdest,destination)) {
              fclose(new);
	      unlink(filename); /* tmp file */
	      return(-1);
	    }

	    strcpy(foo,"mail");
	    mix_lock(foo,&lockptr2);
	    if((out = tempfile(foo))==NULL) return(-3);


            /* put the destination list in the file one per line */
            fwrite(final_hop,1,strlen(final_hop),out);
            for(i=0;i<numdest;i++) {
              fwrite(destination[i],strlen(destination[i]),1,out);
              fwrite("\n",1,1,out);
            }
            fwrite("END\n",1,4,out);

            /* insert disclaimers */
            buff = new_buffer();
            disclaimer(buff);
            fwrite(buff->message,buff->length,1,out);
            free_buffer(buff);

            /* put the header lines on seperate lines in file */
            for(i=0;i<numsub;i++) {
              fwrite(subject[i],strlen(subject[i]),1,out);
              fwrite("\n",1,1,out);
            }
            fwrite("\n",1,1,out);

            /* compression would go here */

            /* Write out the message */
            while((length=fread(line,1,1024,new))>0) {
               fwrite(line,1,length,out);
            }
            fclose(new);
	    fclose(out);
	    unlink(filename); /* tmp file */
	    mix_unlock(foo,lockptr2);
	  } /* end else */


	/* The file did not exist */
	} else { /* this is a new message */
	  if((out = open_mix_file(filename,"w"))==NULL) return(-3);
	  gettimeofday(&now,0);
	  seconds = now.tv_sec;
/*	  tmparray[0]= seconds % 256; /* low byte */
	  tmparray[0]= seconds & 0xFF; /* low byte */
	  seconds = seconds / 256;
/*	  tmparray[1]= seconds % 256; /* second */
	  tmparray[1]= seconds & 0xFF; /* second */
	  seconds = seconds / 256;
/*	  tmparray[2]= seconds % 256; /* third */
	  tmparray[2]= seconds & 0xFF; /* third */
	  seconds = seconds / 256;
/*	  tmparray[3]= seconds % 256; /* high byte */
	  tmparray[3]= seconds & 0xFF; /* high byte */

	  fwrite(tmparray,4, 1, out); /* write new timestamp */
	  fwrite(messageID,16,1,out);

	  fwrite(&numpackets,1,1,out);
	  tmp = 1;
	  fwrite(&tmp,1,1,out); /* first message part */

	  /* put the new packet in the out file */
	  fwrite(&packet,1,1,out); /* which part is this */
	  byteptr = body->message;
	  fwrite(byteptr,4,1,out);
	  length = byteptr[3];
	  length = length * 256 + byteptr[2];
	  length = length * 256 + byteptr[1];
	  length = length * 256 + byteptr[0];
	  fwrite((body->message) +4 , length, 1, out);
	  fclose(out);
	}
}


/* returns 1 if no ID number conflict. 0 if there is */
int check_packetID(byte *ID)
{
	FILE	*fptr,*lockptr;
	char	line[256],temp[256];
	unsigned i;
	struct timeval now;

	gettimeofday(&now,0);
	mix_lock(IDLOG,&lockptr);
	if((fptr = open_mix_file(IDLOG,"r+"))==NULL) {
	   mix_unlock(IDLOG,lockptr);
	   return(1);
	}
	sprintf(line,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
	  ,ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9]
	  ,ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
	while(fgets(temp,256,fptr)!=NULL) {
	   if(strstr(temp,line)) { /* if ID number is found */
	      fclose(fptr);
	      mix_unlock(IDLOG,lockptr);
	      return(0);
	   }
	}
	/* ID number is new */
	fwrite(line,strlen(line),1,fptr);
	fprintf(fptr," %u \n",now.tv_sec);
	mix_unlock(IDLOG, lockptr);
	fclose(fptr);
	return(1);
}




disclaimer(BUFFER *buff)
{
	char	line[256];

	sprintf(line,"From: %s <%s>\n",REMAILERNAME,REMAILERADDR);
	add_to_buffer(buff,line,strlen(line));
        sprintf(line,"X-Comment1: This message did not originate from the\n");
	add_to_buffer(buff,line,strlen(line));
        sprintf(line,"X-Comment2: above address. It was automatically remailed\n");
	add_to_buffer(buff,line,strlen(line));
        sprintf(line,"X-Comment3: by an anonymous mail service. Please report\n");
	add_to_buffer(buff,line,strlen(line));
        sprintf(line,"X-Comment4: problems or inappropriate use to\n");
	add_to_buffer(buff,line,strlen(line));
        sprintf(line,"X-Comment5: <%s>\n",COMPLAINTS);
	add_to_buffer(buff,line,strlen(line));
}

/* Decryptes buffer back to the buffer. */
/* The length of the buffer must be a multiple of 8 */
int crypt_in_buffer(key,iv,buff,encrypt)
unsigned char	*key,*iv;  /* key is 24 long and iv is 8 long */
BUFFER		*buff;
int		encrypt;   /* 1 = encrypt, 0 = decrypt */
{
	BUFFER	*tmp;
	byte	*ptr,line[1024];
	int	i,j,k,flag,len;
	DES3_CBC_CTX	des_context;

        if(buff->length % 8) return(1); 
        DES3_CBCInit(&des_context,key,iv,encrypt);
        tmp = new_buffer();
        i = buff->length;
        len = i; /* we want the same length a the end */
        ptr = buff->message; 
        while (i > 0) {
           j = (i % 1024);
           if(j==0) j=1024;
           if(flag = DES3_CBCUpdate(&des_context,line,ptr,j)) break;
           add_to_buffer(tmp,line,j);
           ptr += j;
           i-=j;
        }
        clear_buffer(buff);
        add_to_buffer(buff,tmp->message,len);
        free_buffer(tmp);
        return(flag);
}

/*
the first line that needs to be worried
about contains "Remailer-Type:"
*/
int	type_2(char *tmpfile)
{
	BUFFER	*b1, *b2, *b3;
	BUFFER	*headers[21],*body;
	char	address[80],*destination[256],*subject[80];
	char	lowdest[256],buff[256];
	char	line[1024],line2[1024],ptr;
	int	i,j,k,status,len;
	byte	numdest,numsub;
	FILE	*fptr,*lockptr, *block;
	byte	innerkey[24], ivarray[19][8];
	byte	tmpbyte,packet,numpackets;
	byte	digest[20],new_digest[20],*ID;
	byte	key[MAX_ENCRYPTED_KEY_LEN], packetID[16], iv[8], tmpiv[8];
	byte	messageID[16],*byteptr;
	long int	length;
	unsigned now;
	R_DIGEST_CTX  digest_context;
	R_RSA_PRIVATE_KEY privkey;
	R_ENVELOPE_CTX rsa_context;

	if((fptr = fopen(tmpfile,"r")) == NULL) return(-1);

	/* first off, de-armor the file */
	while(fgets(line,256,fptr)!=NULL) {
	   if(strstr(line,begin_remailer)) break;
	}
	if(!strstr(line,begin_remailer)) { /* did we find begin? */
	  fprintf(stderr,"Did not find begin_remailer\n");
	  fclose(fptr);
	  return(-1);
	}

	fgets(line,256,fptr); /* Read in length of de-armored message */
	sscanf(line,"%d",&i);

	/* get the checksum line */
	if(fgets(line,256,fptr)==NULL) {
	   fclose(fptr);
	   return(-1);
	}
	R_DecodePEMBlock(digest,&len,line,strlen(line)-1);
#ifdef DEBUGGING
fprintf(stderr,"Length of digest = %d\n",len); /* debug */
#endif
	b1 = new_buffer();
	while(fgets(line,256,fptr)!=NULL) {
	   if(strstr(line,end_remailer)) break;
	   R_DecodePEMBlock(line2,&len,line,strlen(line)-1);
	   add_to_buffer(b1,line2,len);
	}
	fclose(fptr);
	len = i;
	if(len > b1->length) {
	   fprintf(stderr,"Message too small!\n");
	   return(-1);
	}
	R_DigestInit(&digest_context,DA_MD5);
	R_DigestUpdate(&digest_context,b1->message,len);
	R_DigestFinal(&digest_context,new_digest,&len);
	add_to_random(new_digest,len);

	ID = digest;
#ifdef DEBUGGING
/* debug */ fprintf(stderr,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	        ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	        ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
#endif
	ID = new_digest;
#ifdef DEBUGGING
/* debug */ fprintf(stderr,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\n",
	        ID[0],ID[1],ID[2],ID[3],ID[4],ID[5],ID[6],ID[7],ID[8],ID[9],
	        ID[10],ID[11],ID[12],ID[13],ID[14],ID[15]);
#endif
	if(memcmp(digest,new_digest,16)!=0) {
	  fprintf(stderr,"Message checksum does not match!\n");
	  return(-1);
	}

	for(i=0;i<20;i++) {  /* the current first header will be removed */
	  headers[i] = new_buffer();
	  add_to_buffer(headers[i],b1->message + (i * HEADERSIZE),HEADERSIZE);
	}
	/* copy the first header to the end */
	headers[20] = new_buffer();
	add_to_buffer(headers[20],headers[0]->message, headers[0]->length);

	body = new_buffer();
	add_to_buffer(body,b1->message + (20*HEADERSIZE), PACKETSIZE + 4);
	reset_buffer(b1);

	/* decrypt top header */
	byteptr = headers[0]->message;
	if(get_rsa_priv_key(byteptr,&privkey)!=0) {
	   fprintf(stderr,"Unable to get private key!\n");
	   return(-1);
	}
	byteptr+=16;
	tmpbyte = *byteptr;
	len = tmpbyte;
	byteptr++;
	memcpy(key,byteptr,len);
	byteptr += len;
	memcpy(iv,byteptr,8);
	byteptr += 8;
	if((i=R_OpenInit(&rsa_context,EA_DES_EDE3_CBC,key,len,iv,&privkey))!=0) {
	   fprintf(stderr,"R_OpenInit error #%d",i);
	}
	R_OpenUpdate(&rsa_context,line,&len,byteptr,INNERHEAD);
	add_to_buffer(b1,line,len);
	R_OpenFinal(&rsa_context,line,&len);
	add_to_buffer(b1,line,len);
	add_to_random(b1->message,b1->length);

	free_buffer(headers[0]);

	byteptr = b1->message;
	for(i=0;i<16;i++) packetID[i] = byteptr[i];
	byteptr += 16;
	R_memcpy(innerkey,byteptr,24);
	byteptr += 24;
	tmpbyte = *byteptr;
	byteptr++;

	if(tmpbyte == 0) { /* intermediate packet */
#ifdef DEBUGGING
printf("intermed hop\n"); /* debug */
#endif
	  for(i=0;i<19;i++) {
	     R_memcpy(ivarray[i],byteptr,8);
	     byteptr += 8;
	  }
	  memcpy(address,byteptr,80);
	  crypt_in_buffer(innerkey,ivarray[18],body,0); /* decrypt back into the buffer */
	  add_to_random(body->message,body->length);
	  for(i=1; i<=20; i++) {
	    crypt_in_buffer(innerkey,ivarray[i-1],headers[i],0); /* decrypt back into the buffer */
	  }
	  mix_lock("mail",&lockptr);
	  strcpy(line,"mail");
	  if((fptr = tempfile(line))==NULL) return(-1);
	  fprintf(fptr,"temp");  /* make sure the file is created */
	  fclose(fptr);
	  if(check_packetID(packetID)){
	    if(send_new_packet(headers,body,address,line,0,0)<0) {
	      unlink(line);
	      mix_unlock("mail",lockptr);
	      return(-1);
	    }
	  } else {
	    unlink(line);
	  }
	  mix_unlock("mail",lockptr);


	} else if(tmpbyte == 1) {  /* final hop */
#ifdef DEBUGGING
printf("final hop\n"); /* debug */
#endif
	  for(i=0;i<16;i++) messageID[i] = byteptr[i];
	  byteptr += 16;
	  for(i=0;i<8;i++) iv[i] = byteptr[i];
	  byteptr += 8;
	  if(!check_packetID(packetID)) return(-1);
	  crypt_in_buffer(innerkey,iv,body,0); /* decrypt back into the buffer */
	  add_to_random(body->message,body->length);

	  /* get destination list */
	  byteptr = body->message;
	  length = byteptr[3]; /*high byte */
	  length = length * 256 + byteptr[2]; /*3rd byte */
	  length = length * 256 + byteptr[1]; /*2nd byte */
	  length = length * 256 + byteptr[0]; /*low byte*/
	  byteptr += 4;
	  k = length;
	  numdest = *byteptr;
	  byteptr++;
	  k--;
	  for(i=0;i<numdest;i++) {
	    destination[i] = (char *) malloc(80 * sizeof(char));
	    memcpy(destination[i],byteptr,80);
	    byteptr += 80;
	    k -= 80;
	  }
	  numsub = *byteptr;
	  byteptr++;
	  k--;
	  for(i=0;i<numsub;i++) {
	    subject[i] = (char *) malloc(80 * sizeof(char));
	    memcpy(subject[i],byteptr,80);
	    byteptr += 80;
	    k -= 80;
	  }
	  /* put the message in b2 */
	  b2 = new_buffer();
	  add_to_buffer(b2,byteptr,k);

	  if(destination_block(numdest, destination)) return(-1);

	  /* open mail file */
	  mix_lock("mail",&lockptr);
	  strcpy(line,"mail");
	  if((fptr = tempfile(line))==NULL) return(-1);

          fwrite(final_hop,1,strlen(final_hop),fptr);
	  /* put the destination list in the file, one per line */
	  for(i=0;i<numdest;i++) {
	    fwrite(destination[i],1,strlen(destination[i]),fptr);
	    fwrite("\n",1,1,fptr);
	  }
	  fwrite("END\n",1,4,fptr);

	  /* insert disclaimers */
	  b3 = new_buffer();
	  disclaimer(b3);
	  fwrite(b3->message,1,b3->length,fptr);
	  free_buffer(b3);

	  /* put the header lines on seperate lines in file */
	  for(i=0;i<numsub;i++) {
	    fwrite(subject[i],1,strlen(subject[i]),fptr);
	    fwrite("\n",1,1,fptr);
	  }
	  fwrite("\n",1,1,fptr);

	  /* decompression would go here */

	  fwrite(b2->message,1,b2->length,fptr);
	  fclose(fptr);
	  mix_unlock("mail",lockptr);

	} else if(tmpbyte == 2) { /* partial message */
#ifdef DEBUGGING
printf("packet final hop\n"); /* debug */
#endif
	  tmpbyte = *byteptr;
	  packet = tmpbyte;
	  byteptr +=1;
	  tmpbyte = *byteptr;
	  numpackets = tmpbyte;
	  byteptr +=1;
	  for(i=0;i<16;i++) messageID[i] = byteptr[i];
	  byteptr += 16;
	  for(i=0;i<8;i++) iv[i] = byteptr[i];
	  byteptr += 8;
	  if(!check_packetID(packetID)) return(-1);
	  crypt_in_buffer(innerkey,iv,body,0); /* decrypt back into the buffer */
	  add_to_random(body->message,body->length);

	  mix_lock("pac",&lockptr);
	  merge_packets(body, messageID, packet, numpackets);
	  mix_unlock("pac",lockptr);

	} else {
#ifdef DEBUGGING
	  fprintf(stdout,"Not a known packet type\n"); /* debug */
#endif
	  return(-1);
	}
	return(0);
}

int read_remailer_list(FILE *ptr, REMAILER *list)
{
	char	line[256],tmp[256],foo[256];
	int	num,i;
	int	ID[16];

	rewind(ptr);
	num = 0;
	while(fgets(line,255,ptr)!=NULL) {
	  num++;
	  memset(&list[num], 0, sizeof(list[num]));
	  sscanf(line,"%s %s %s %s",list[num].shortname,list[num].name,
	  	tmp,list[num].version);
	  sscanf(tmp,"%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x%2x",
	     ID,ID+1,ID+2,ID+3,ID+4,ID+5,ID+6,ID+7,ID+8,ID+9,
             ID+10,ID+11,ID+12,ID+13,ID+14,ID+15);
          for(i=0;i<16;i++) {
             list[num].key_ID[i] = ID[i];
          }
	}
	return(num);
}

/* send packet just generated */
int send_new_packet(headbuff,bodybuff, address,outfile,outfileflag, client)
BUFFER	**headbuff, *bodybuff;
char	*outfile,*address;
int	client,outfileflag;
{
	int	i,j,k,n,len;
	BUFFER	*outbuffer,*tmpbuffer;
	FILE	*fptr;
	char	temp[80],line[1024];
	unsigned char *ptr;
	byte	tempbyte, digest[20];
	R_DIGEST_CTX	digest_context;

	tmpbuffer = new_buffer();
	for(i=1;i<=20;i++) {
	  add_to_buffer(tmpbuffer,headbuff[i]->message,headbuff[i]->length);
	  reset_buffer(headbuff[i]);
	}
	add_to_buffer(tmpbuffer,bodybuff->message,bodybuff->length);
	reset_buffer(bodybuff);

	/* build output file */
	outbuffer = new_buffer();
	/* If a client mailing directly then add a To: line */
	if(strlen(outfile)<=1 || outfileflag) {
 	  add_to_buffer(outbuffer, "To: ", strlen("To: "));
	  add_to_buffer(outbuffer, address, strlen(address));
	}
	add_to_buffer(outbuffer, "\n\n::\n",strlen("\n\n::\n"));
	add_to_buffer(outbuffer, remailer_type, strlen(remailer_type));
	add_to_buffer(outbuffer, VERSION, strlen(VERSION));
	add_to_buffer(outbuffer, two_n, strlen(two_n));
	add_to_buffer(outbuffer, begin_remailer,strlen (begin_remailer));
	sprintf(line,"%d\n",tmpbuffer->length); /* Write out length */
#ifdef DEBUGGING
/* debug */	fprintf(stdout,"%s\n",outbuffer->message); /* Write out length */
#endif
	add_to_buffer(outbuffer, line,strlen(line));

	/* Ok, now make a MD5 checksum and prepend it. */
	R_DigestInit(&digest_context,DA_MD5);
	R_DigestUpdate(&digest_context,tmpbuffer->message,tmpbuffer->length);
	R_DigestFinal(&digest_context,digest,&len);
	if(len!=16) fprintf(stderr,"Big problems! Digest not 16 bytes\n");
	R_EncodePEMBlock(line,&len,digest,16);
	add_to_buffer(outbuffer,line,len);
	add_to_buffer(outbuffer,"\n",1);
	

	/* armor and add message */
	j = tmpbuffer->length;
	ptr = tmpbuffer->message;
	while(j>0) {
	   n = (j % 30); /* this must be a mult of 3 */
	   if(n==0) n=30;/* 30 will give 40 char lines */
	   R_EncodePEMBlock(line,&len,ptr,n);
	   add_to_buffer(outbuffer,line,len);
	   add_to_buffer(outbuffer,"\n",1);
	   ptr +=n;
	   j-=n;
	}
        free_buffer(tmpbuffer);
        add_to_buffer (outbuffer, end_remailer, strlen (end_remailer));

	if(strlen(outfile)<=1) {
          fptr = popen(SENDMAIL,"w");
          if(fptr == NULL) {
            fprintf(stderr,"Error: Unable to open pipe to %s\n",SENDMAIL);
            return(-1);
          }
          fwrite(outbuffer->message,sizeof(char),outbuffer->length,fptr);
	  pclose(fptr);
	} else if(strstr(outfile,"stdout")) {
          fwrite(outbuffer->message,sizeof(char),outbuffer->length,stdout);
	} else {
	  fptr = fopen(outfile,"w");
          if(fptr == NULL) return(-1);
	  if(!client) { /* then we are a remailer and should add some headers */
	    fprintf(fptr,"%s",intermed_hop);
	    fprintf(fptr,"%s\nEND\n",address);
	  }
          fwrite(outbuffer->message,sizeof(char),outbuffer->length,fptr);
	  fclose(fptr);
	}
	free_buffer(outbuffer);
	return(1);
}

/* this actualy makes the message block and sends it */
int build_message(in_ptr, numdest, destination, remailer_chain, numsub, subject, outfile, outfileflag, remailer_list, num_remailers)
FILE	*in_ptr;
int	*remailer_chain,num_remailers, outfileflag;
byte numsub, numdest;
char	**destination, **subject, *outfile;
REMAILER 	*remailer_list;
{
	int	hop,i,j,k,n,numpackets,packet,status;
	long int	chunk,tmpchunk;
	byte	iv[8],tmpiv[8];
	unsigned char	ivarray[19][8], innerkey[24],digest[16];
	BUFFER	*bodybuff, *headbuff[21], *message, *tempbuff,*b1,*b2;
	char	line[1024],dest_card[80];
	unsigned char	*key[5],packetID[16],messageID[16];
	byte	md5[16];
	byte	tmpbyte,*ptr;
	char	*user[2];
	R_DIGEST_CTX	digest_context;
	R_ENVELOPE_CTX	rsa_context;
	R_RSA_PUBLIC_KEY  pubKey,*keyPtr[5];
	unsigned int	numPubKeys,keylen;


	/* compress the file */
	/* ?? Compression would go here ?? */

	message = new_buffer();
	for(i=1;i<=20;i++) headbuff[i] = new_buffer();

	/* prepend destinations to body */
	tmpbyte = numdest;
	add_to_buffer(message,&tmpbyte,1);
	for(i=0;i<numdest;i++) {
	  add_to_buffer(message,destination[i],80);
	}
	/* add message header lines to body */
	tmpbyte = numsub;
	add_to_buffer(message,&tmpbyte,1);
	for(i=0;i<numsub;i++) {
	  add_to_buffer(message,subject[i],80);
	}
	/* add the file to body */
	while((i=fread(line,1,256,in_ptr))>0) {
	   if(i<0) {
	      exit(-1); /* file error */
	   }
	   add_to_buffer(message,line,i);
	}
	fclose(in_ptr);
	add_to_random(message->message, message->length);
	numpackets = message->length / PACKETSIZE;
	if(message->length % PACKETSIZE != 0) numpackets++;

	bodybuff = new_buffer();

	for(i=0;i<16;i++) messageID[i] = our_randombyte();



	/* Loop to make one packet at a time */
	for(packet = 1; packet <= numpackets; packet++){
	  /* put the packet in bodybuff, and put the rest back in message */
	  chunk = message->length;
	  if(chunk > PACKETSIZE) chunk = PACKETSIZE;
	  clear_buffer(bodybuff);

	  tmpchunk = chunk;
	  tmpbyte = tmpchunk&0xFF;
	  add_to_buffer(bodybuff,&tmpbyte,1); /* prepend length of data low byte*/
	  tmpchunk = tmpchunk/256;
	  tmpbyte = tmpchunk&0xFF;
	  add_to_buffer(bodybuff,&tmpbyte,1); /* prepend length of data 2nd byte*/
	  tmpchunk = tmpchunk/256;
	  tmpbyte = tmpchunk&0xFF;
	  add_to_buffer(bodybuff,&tmpbyte,1); /* prepend length of data 3rd byte*/
	  tmpchunk = tmpchunk/256;
	  tmpbyte = tmpchunk&0xFF;
	  add_to_buffer(bodybuff,&tmpbyte,1); /* prepend length of data high byte*/

	  add_to_buffer(bodybuff,message->message,chunk);
	  tempbuff = new_buffer();
	  add_to_buffer(tempbuff,(message->message)+chunk,message->length - chunk);
	  free_buffer(message);
	  message = tempbuff;


	  for(i=bodybuff->length + 1; i<=PACKETSIZE+4;i++){
	    tmpbyte = our_randombyte();
	    add_to_buffer(bodybuff,&tmpbyte,1);
	  }

	  /* Create fake header cards */
	  for(i=remailer_chain[0]+1;i<=20;i++){
	    reset_buffer(headbuff[i]);
	    while(headbuff[i]->length < HEADERSIZE) {
	      tmpbyte = our_randombyte();
	      add_to_buffer(headbuff[i],&tmpbyte,1);
	    }
	  }

	  for(hop = remailer_chain[0]; hop >= 1; hop--){
	    /* Check to see if this remailer should be chosen randomly */
	    if(remailer_chain[hop] <= 0) {
	      do {
	        tmpbyte = our_randombyte();
	      } while (tmpbyte >= num_remailers);
	      tmpbyte ++; /* range of 1 to num_remailers */
	      remailer_chain[hop] = -1 * tmpbyte;
	      /* The last hop has to be the same for all packets */
	      if(hop == remailer_chain[0])
	           remailer_chain[hop] = abs(remailer_chain[hop]);
	    }
	    /* Get RSA key for remailer */
	    if(get_rsa_key(remailer_list[abs(remailer_chain[hop])].key_ID,
	    	&pubKey)!=0) {
	       fprintf(stderr,"Can't get public key!\n");
	       return(-1);
	    } 
	    numPubKeys = 1;
	    keyPtr[0] = &pubKey;
	    key[0] = malloc(MAX_ENCRYPTED_KEY_LEN);
	    i = R_SealInit(&rsa_context,key,&keylen,iv,numPubKeys,keyPtr,
	    	EA_DES_EDE3_CBC,rand_struct());
	    if(i != 0) {
	      fprintf(stderr,"R_SealInit error %x!!!\n",i);
	      exit(-1);
	    }

	    /* make packet ID and innerkey */
	    for(i=0;i<16;i++) packetID[i] = our_randombyte();
	    for(i=0;i<24;i++) innerkey[i] = our_randombyte();
	    /* make the iv array */
	    for(i=0;i<19;i++) {
	      for(j=0;j<8;j++) ivarray[i][j] = our_randombyte();
	    }
	    

	    /* Now build the current header */
	    reset_buffer(headbuff[hop]);
	    add_to_buffer(headbuff[hop],packetID,16); /* also like another IV */
	    add_to_buffer(headbuff[hop],innerkey,24); /* Key used to encrypt headers and body */
	    if(hop == remailer_chain[0]){ /* if this is the last hop */
	      if(numpackets == 1) {
		tmpbyte = 1; /* packet type = final hop */
		add_to_buffer(headbuff[hop],&tmpbyte,1);
	      } else {
		tmpbyte = 2; /* partial message */
		add_to_buffer(headbuff[hop],&tmpbyte,1);
		tmpbyte = packet; /* which packet is this */
		add_to_buffer(headbuff[hop],&tmpbyte,1);
		tmpbyte = numpackets; /* out of how many */
		add_to_buffer(headbuff[hop],&tmpbyte,1);
	      }
	      add_to_buffer(headbuff[hop],messageID,16);
	      add_to_buffer(headbuff[hop],ivarray[18],8);
	    } else { /* this is not the last hop */
		tmpbyte = 0; /* packet type = intermediate packet */
		add_to_buffer(headbuff[hop],&tmpbyte,1);
	    }



	    /* Add header stuff for intermediate hops */
	    if(hop < remailer_chain[0]){
	      /* insert the array of IVs */
	      for(i=0;i<19;i++) {
	         add_to_buffer(headbuff[hop],ivarray[i],8);
	      }
	      add_to_buffer(headbuff[hop],remailer_list[abs(remailer_chain[hop+1])].name,80);
	    }


	    /* Make an append an MD5 checksum of the packet */
	    R_DigestInit(&digest_context,DA_MD5);
	    R_DigestUpdate(&digest_context,headbuff[hop]->message,
	         headbuff[hop]->length);
	    R_DigestFinal(&digest_context,digest,&i);
	    add_to_buffer(headbuff[hop],&digest,16);

	    /* Now padd pre-encrypted header to standard size */
	    while(headbuff[hop]->length < INNERHEAD) {
	      tmpbyte = our_randombyte();
	      add_to_buffer(headbuff[hop], &tmpbyte,1);
	    }


	    /* Done building headbuff[hop] so now RSA it */
	    tempbuff = new_buffer();
	    i = headbuff[hop]->length;
	    ptr = headbuff[hop]->message;
	    while (i > 0) {
	       j = (i % 1024); 
	       if(j==0) j=1024;
	       R_SealUpdate(&rsa_context,line,&k,ptr,j);
	       add_to_buffer(tempbuff,line,k);
	       ptr += j;
	       i-=j;
	    }
	    R_SealFinal(&rsa_context,line,&k);
	    add_to_buffer(tempbuff,line,k);
	    clear_buffer(headbuff[hop]);

	    /* Prepend RSA key ID */
	    add_to_buffer(headbuff[hop],remailer_list[abs(remailer_chain[hop])].key_ID,16);
	    /* prepend keys and IV to header */
	    tmpbyte = keylen;
	    add_to_buffer(headbuff[hop],&tmpbyte,1);
	    add_to_buffer(headbuff[hop],key[0],tmpbyte);
	    add_to_buffer(headbuff[hop],iv,8);
	    /* add encryped header */
	    add_to_buffer(headbuff[hop],tempbuff->message,tempbuff->length);
	    free_buffer(tempbuff);

	    /* pad out encrypted header to standard size */
	    while(headbuff[hop]->length < HEADERSIZE) {
	      tmpbyte = our_randombyte();
	      add_to_buffer(headbuff[hop], &tmpbyte,1);
	    }

	    /* encrypt body */
	    crypt_in_buffer(innerkey,ivarray[18],bodybuff,1);

	    /* encrypt all later headers */
	    i=0; /* this is the index for ivarray */
	    for(j=hop+1;j<=20;j++) {
	       crypt_in_buffer(innerkey,ivarray[i],headbuff[j],1);
	       i++;
	    }

	  } /* hop loop for a given packet */
	  if(strlen(outfile) > 1 && !strstr(outfile,"stdout") && numpackets > 1) {
	    sprintf(line,"%s.%d",outfile,packet);
	    send_new_packet(headbuff,bodybuff, remailer_list[abs(remailer_chain[1])].name,line,outfileflag,1);
	  } else {
	    send_new_packet(headbuff,bodybuff, remailer_list[abs(remailer_chain[1])].name,outfile,outfileflag,1);
	  }
	} /* end loop proccessing packets */
	free_buffer(bodybuff);
	free_buffer(message);
	for(i=1;i<=20;i++) free_buffer(headbuff[i]);
}


void get_chain(REMAILER *remailer_list, int num_remailers, int *chain)
{
	int	i,j,k;
	char	line[256];

	for(i=1;i<=num_remailers;i++) {
	  fprintf(stderr,"#%d %s\n",i,remailer_list[i].name);
	}
	fprintf(stderr,"Choose the remailers you want to use in your chain.\n");
	fprintf(stderr,"Hit return when you are done.\n");
	fprintf(stderr,"Enter remailer number: ");
	fgets(line,255,stdin);
	chain[0]=0;
	while(line[0] >='0' && line[0]<='9') {
	  j = atoi(line);
	  /* remailer 0 means choose randomly */
	  if (j>=0 && j<=num_remailers && chain[0] < 20) {
	    chain[0]++;
	    chain[chain[0]] = j; /* because chain[0] holds the number of elements */
	  } else {
	    fprintf(stderr,"Invalid choice");
	  }
	  fprintf(stderr,"Enter remailer number: ");
	  fgets(line,255,stdin);
	}
}


int	chain_2(int argc, char *argv[])
{
	FILE	*in, *list_ptr;
	char	line[256],filename[80]="",*destination[80],outfile[80]="";
	char	*subject[80];
	int	remailer_chain[80];
	byte	numdest=0, numsub=0;
	int	i,j,k,status,num_remailers,outfileflag=0;
	REMAILER remailer_list[256];
	int	filter = 0;

	if((list_ptr = open_mix_file(REMAILERLIST,"r")) == NULL) {
	  fprintf(stderr,"Could not open %s\n",REMAILERLIST);
	  return(-1);
	}
	num_remailers = read_remailer_list(list_ptr,remailer_list);
	fclose(list_ptr);
	remailer_chain[0]=0;

	/* what is in those arguments */
	/* Here is the expected format */
	/* mixmaster [-c][-f][filename][-[o,O] outfile][-to who@where][-s "subject"][-l 1 2 3 4] */
	/* if no outfile given, then pipe to sendmail. outfile = stdout send to stdout */
	for(i=1; i<argc; i++) {
	  if(strstr(argv[i],"-c")) {
	    /* nop */
	  } else if(strstr(argv[i],"-h") || strstr(argv[i],"--help")) {
	    /* Print help and exit */
	    printf("Mixmaster (C) Copyright Lance M. Cottrell 1995\n");
	    printf("Released under the GNU public license.\n");
	    printf("Client Mode command line arguments:\n");
	    printf("mixmaster [-c][-f][filename][-[o,O] outfile][-to who@where][-s \"subject\"][-l 1 2 3 4]\n");
	    exit(-1);
	  } else if(strstr(argv[i],"-f")) {
	    /* set filter mode */
	    filter = 1;
	  } else if(strstr(argv[i],"-s")) {
	    if(i < argc - 1) i++;
	    subject[0] = (char *)malloc(80 * sizeof(char));
	    strncpy(subject[0],"Subject: ", 79);
	    subject[0][79]='\0';
	    strcat(subject[0],argv[i]);
            j= strlen(subject[0]);
	    if(strstr(subject[0],"\r")) subject[0][j-1]=0;
	    numsub = 1;
	  } else if(strstr(argv[i],"-o")) {
	    if(i < argc - 1) i++;
	    if(argv[i][0] == '/') {
	      strcpy(outfile,argv[i]);
	    } else {
	      sprintf(outfile, "%s/%s", cur_dir, argv[i]);
	    }
	  } else if(strstr(argv[i],"-O")) {
	    if(i < argc - 1) i++;
	    if(argv[i][0] == '/') {
	      strcpy(outfile,argv[i]);
	    } else {
	      sprintf(outfile, "%s/%s", cur_dir, argv[i]);
	    }
	    outfileflag=1;
	  } else if(strstr(argv[i],"-to")) {
	    if(i < argc - 1) i++;
	    destination[0] = (char *)malloc(80 * sizeof(char));
	    strncpy(destination[0],argv[i],79); destination[0][79]='\0';
            j= strlen(destination[0]);
	    if(strstr(destination[0],"\r")) destination[0][j-1]=0;
	    numdest = 1;
	  } else if(strstr(argv[i],"-l")) {
	    i++;
	    j=0;
	    while(i < argc && j < 20){
	      j++;
	      remailer_chain[j] = atoi(argv[i]);
	      /* remailer = 0 means random remailer */
	      if(remailer_chain[j] <0 || remailer_chain[j] > num_remailers){
		fprintf(stderr,"Invalid remailer number!\n");
		exit(-1);
	      }
	      i++;
	    }
	    remailer_chain[0] = j;
	  } else {
	    if(strlen(filename)!=0) {
	      fprintf(stderr,"problem with the command line\n");
	      return(-1);
	    }
	    strcpy(filename,argv[i]);
	  }
	}



	if(numdest==0) {
	  if(!filter) fprintf(stderr,"Enter final destinations (one per line return when done).\n");
	  do {
	    if(!filter)fprintf(stderr,"Enter destination :");
	    fgets(line,255,stdin);
	    i = strlen(line);
	    if(line[i-1] < ' ') line[i-1] = 0;
	    if(strlen(line) >= 2) {
	      destination[numdest] = (char *)malloc(80 * sizeof(char));
	      strncpy(destination[numdest],line,79);
	      destination[numdest][79] = '\0';
	      numdest++;
	    }
	  } while(strlen(line) >=2 || numdest == 0);
	}
	if(numdest==0 && filter) exit(-1); /* no destination and in filter mode */

	if(numsub==0) {
	  if(!filter)fprintf(stderr,"Enter message headers (one per line return when done).\n");
	  if(!filter)fprintf(stderr,"You must include the header name, e.g. 'Subject: foo'\n");
	  do {
	    if(!filter)fprintf(stderr,"Enter header :");
	    fgets(line,255,stdin);
	    i = strlen(line);
	    if(line[i-1] < ' ') line[i-1] = 0;
	    if(strlen(line) >= 2) {
	      subject[numsub] = (char *)malloc(80 * sizeof(char));
	      strncpy(subject[numsub],line,79);
	      subject[numsub][79] = '\0';
	      numsub++;
	    }
	  } while(strlen(line) >=2);
	}

	if(remailer_chain[0] == 0 && !filter) {
	  get_chain(remailer_list, num_remailers, remailer_chain);
	}
	if(remailer_chain[0] == 0) {
	  return(-1);
	}

	/* if file = stdin then I will take stdin */
	if(strlen(filename)==0 && !filter){
	  fprintf(stderr,"Please enter the name of the file to chain: ");
	  fgets(filename,255,stdin);
	  i = strlen(filename);
	  if(filename[i-1] < ' ') filename[i-1] = 0;
	}
	if(strcmp(filename,"stdin")==0 || strlen(filename)==0) {
	  in = stdin;
	} else {
	  if(filename[0] != '/') { /* not a full pathname */
	    strcpy(line,cur_dir);
	    strcat(line,"/");
	    strcat(line,filename);
	  } else {
	    strcpy(line,filename);
	  }
	  if((in=fopen(line,"r"))==NULL) {
	    fprintf(stderr,"Could not open file %s\n",filename);
	    return(-1);
	  }
	}

	/* ok, that should be everything we need to know */

#ifdef DEBUGING
printf("filtermode %d\n",filter); /*debug*/
printf("source file %s\n",filename); /*debug*/
printf("#destinations %d\n",numdest); /*debug*/
for(i=0;i<numdest;i++) printf("destination %d  %s\n",i,destination[i]); /*debug*/
for(i=1;i<=remailer_chain[0];i++) printf("remailer %d\n",remailer_chain[i]); /*debug*/
for(i=0;i<numsub;i++) printf("header %d  %s\n",i,subject[i]); /*debug*/
#endif

	status = build_message(in, numdest, destination, remailer_chain, numsub, subject, outfile,outfileflag,remailer_list,num_remailers);

	fclose(in);
}


