#!/bin/sh
# Quickremail v1.0
# Summary: An easy interface to install an anonymous remailer.
# Copyright (c) 1996 Mark Miller <markm@voicenet.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
instdir=`pwd`
echo -n "Are you going to run a Type I or Type II remailer or both? [1/2/b] "
read line
if [ ! $line ]; then
	echo "You must specify either \"1\", \"2\", or \"b\"." 1>&2
	exit 1
elif [ $line = "1" ]; then
	type1=1
	type2=0
elif [ $line = "2" ]; then
	type2=1
	type1=0
elif [ $line = "b" ]; then
	type1=1
	type2=1
else
	echo "You must specify either \"1\", \"2\", or \"b\"." 1>&2
	exit 1
fi
unset line
echo -n "Do you have permission to run crontab? [Y/n] "
read line
if [ ! $line ]; then
	usecron=YES
elif [ $line = "n" ]; then
	usecron=NO
else
	usecron=YES
fi
unset line
if [ $type1 = "1" ]; then
	echo -n "Do you want to run the Ghio remailer package? [Y/n] "
	read line
	if [ ! $line ]; then
		remailer=ghio
	elif [ $line = "n" ]; then
		remailer=freedom
	else
		remailer=ghio
	fi
	unset line
	echo -n "What do you want the email address of the remailer to be? [$USER@$HOSTNAME] "
	read line
	if [ ! $line ]; then
		raddress=$USER@$HOSTNAME
	else
		raddress=$line
	fi
	unset line
	echo -n "What is the email address to which you want complaints sent? [$USER@$HOSTNAME] "
	read line
	if [ ! $line ]; then
		rcomplain=$USER@$HOSTNAME
	else
		rcomplain=$line
	fi
	unset line
	echo -n "What do you want the name that appears in the \"From: \" line to say? [Anonymous] "
	read line
	if [ ! $line ]; then
		name=Anonymous
	else
		name=$line
	fi
	unset line
	echo -n "What is the name of the mail spool the remailer will be using? [$MAIL] "
	read line
	if [ ! $line ]; then
		spool=$MAIL
	else
		spool=$line
	fi
	unset line 
	echo -n "Do you want to keep a file showing the remailer's statistics?  If you are "
	echo -n "going to also run Mixmaster using this account, then you should answer \"n\". [Y/n] "
	read line
	if [ ! $line ]; then
		stats=YES
	elif [ $line = "n" ]; then
		stats=NO
	else
		stats=YES
	fi
	unset line
	echo -n "Where is the sendmail executable? [/usr/lib/sendmail] "
	read line
	if [ ! $line ]; then
		sendmail=/usr/lib/sendmail
	else
		sendmail=$line
	fi
	unset line
	echo -n "Do you want to enable PGP encryption? [Y/n] "
	read line
	if [ ! $line ]; then
		usepgp=YES
	elif [ $line = "n" ]; then
		usepgp=NO
	else
		usepgp=YES
	fi
	unset line
	if [ $usepgp = "YES" ]; then
		echo -n "Where is the PGP executable located? [`which pgp`] "
		read line
		if [ ! $line ]; then
			ppath=`which pgp`
		else
			ppath=$line
		fi
		unset line
		echo -n "Where will the public and secret keys be held? [$HOME/.pgp] "
		read line
		if [ ! $line ]; then
			pgppath=$HOME/.pgp
		else
			pgppath=$line
		fi
		unset line
		echo "You will now need to generate a key pair that this remailer will use."
		pgp -kg -u "$name <$raddress>"
		echo "Enter the PGP passphrase you used to protect the key:"
		stty -echo
		read pgppass
		stty echo
	fi
	echo -n "Do you want users to be able to post to Usenet? [y/N] "
	read line
	if [ ! $line ]; then
		post=NO
	elif [ $line = "y" ]; then
		post=YES
	else
		post=NO
	fi
	unset line
	if [ $post = "YES" ]; then
		echo -n "Where is the inews executable? [`which inews`] "
		read line
		if [ ! $line ]; then
			inews=`which inews`
		else
			inews=$line
		fi
		unset line
		echo -n "What is the address of the NNTP server? [127.0.0.1] "
		read line
		if [ ! $line ]; then
			nntp=127.0.0.1
		else
			nntp=$line
		fi
		unset line
		if [ $remailer = "freedom" ]; then
			echo -n "What do you want to appear in the \"Organization: \" header? "
			read line
			organization=$line
			unset line
		fi
	fi
	if [ $remailer = "freedom" ]; then
		remaildir=$instdir/freedom
		echo stats=\"$stats\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo post=\"$post\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo usepgp=\"$usepgp\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo remaildir=\"$remaildir\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo pgppath=\"$pgppath\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo spool=\"$spool\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo sendmail=\"$sendmail\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo ppath=\"$ppath\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo inews=\"$inews\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo pgppass=\"$pgppass\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo name=\"$name\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo raddress=\"$raddress\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo rcomplain=\"$rcomplain\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo organization=\"$organization\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		. /tmp/vars.$$
		rm -f /tmp/vars.$$
		sed -e "s/@STATS@/$stats/" \
		 	-e "s/@POST@/$post/" \
			-e "s/@USEPGP@/$usepgp/" \
			-e "s/@REMAILDIR@/$remaildir/" \
			-e "s/@PGPPATH@/$pgppath/" \
			-e "s/@SPOOL@/$spool/" \
			-e "s/@SENDMAIL@/$sendmail/" \
			-e "s/@PPATH@/$ppath/" \
			-e "s/@INEWS@/$inews/" \
			-e "s/@PGPPASS@/$pgppass/" \
			-e "s/@NAME@/$name/" \
			-e "s/@RADDRESS@/$raddress/" \
			-e "s/@RCOMPLAIN@/$rcomplain/" \
			-e "s/@ORGANIZATION@/$organization/" config.h.in > config.h
		zcat freedom99.1.tar.gz | tar xf -
		mv config.h freedom
		cd freedom
		make
		if [ $usepgp = "YES" ]; then
			pgp -kxa "$name <$raddress>" freedom-key
			mv freedom-key.asc freedom-key
		fi
		sed -e "s/remailer@wherever/$raddress/g" \
			 -e "s/remailer-admin@wherever/$rcomplain/g" freedom-help > /tmp/help.$$
		mv /tmp/help.$$ freedom-help
		cd ..
	elif [ $remailer = "ghio" ]; then
		mkdir ghio
		if [ $stats=YES ]; then
			statsdata=statsdata
		else
			statsdata=""
		fi
		remaildir=$instdir/ghio
		cp ghio.remailer.2.tar.gz ghio
		cd ghio
		zcat ghio.remailer.2.tar.gz | tar xf -
		cd ..
		anonfrom="$name <$raddress>"
		echo remaildir=\"$remaildir\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo anonfrom=\"$anonfrom\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo raddress=\"$raddress\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo rcomplain=\"$rcomplain\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo spool=\"$spool\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo ppath=\"$ppath\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo pgppass=\"$pgppass\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo pgppath=\"$pgppath\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo inews=\"$inews\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo nntp=\"$nntp\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo sendmail=\"$sendmail\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo statsdata=\"$statsdata\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		. /tmp/vars.$$
		rm -f /tmp/vars.$$
		sed -e "s/@REMAILDIR@/$remaildir/" \
			-e "s/@ANONFROM@/$anonfrom/" \
			-e "s/@RADDRESS@/$raddress/" \
			-e "s/@RCOMPLAIN@/$rcomplain/" \
			-e "s/@SPOOL@/$spool/" \
			-e "s/@PPATH@/$ppath/" \
			-e "s/@PGPPASS@/$pgppass/" \
			-e "s/@PGPPATH@/$pgppath/" \
			-e "s/@INEWS@/$inews/" \
			-e "s/@NNTP@/$nntp/" \
			-e "s/@SENDMAIL@/$sendmail/" \
			-e "s/@STATSDATA@/$statsdata/" remailer.c.in > remailer.c
		mv remailer.c ghio
		cd ghio
		gcc -O2 -s -o remailer remailer.c
		if [ $usepgp = "YES" ]; then
			pgp -kxa "$name <$raddress>" remailer-key
			mv remailer-key.asc remailer-key
		fi
		sed "s/\[addr\]/$raddress/g" remailer-help > /tmp/help.$$
		mv /tmp/help.$$ remailer-help
		cd ..
	fi
	if [ $usecron = "YES" ]; then
		if [ $type2 = "0" ]; then
			reordercom=mail-reorder
		else
			reordercom=mail-out
		fi
		echo -n "Do you want to use reordering? [Y/n] "
		read line
		if [ ! $line ]; then
			reorder=YES
		elif [ $line = "n" ]; then
			reorder=NO
		else
			reorder=YES
		fi
		unset line
		if [ $reorder = "YES" ]; then
			zcat reorder.tar.gz | tar xf -
			mv reorder reorder1
			cd reorder1/Rnd
			make
			cd ../..
			remailcom="$remaildir\/remailer"
			reorderdir=$instdir/reorder1
			echo reorderdir=\"$reorderdir\" | sed 's/\//\\\//g' > /tmp/var.$$
			. /tmp/var.$$
			rm -f /tmp/var.$$
			sed -e "s/@REMAILCOM@/$remailcom/" \
				-e "s/@REORDERDIR@/$reorderdir/" mail-in.in > mail-in
			sed -e "s/@REMAILCOM@/$remailcom/" \
				-e "s/@REORDERDIR@/$reorderdir/" mail-out.in > mail-out
			sed -e "s/@REMAILCOM@/$remailcom/" \
				-e "s/@REORDERDIR@/$reorderdir/" mail-reorder.in > mail-reorder
			mv mail-in reorder1
			mv mail-out reorder1
			mv mail-reorder reorder1
			crontab -l 2>/dev/null 1>/tmp/file.cron.$$
			echo "*/10 * * * * $instdir/reorder1/$reordercom" >> /tmp/file.cron.$$
			crontab /tmp/file.cron.$$
			rm -f /tmp/file.cron.$$
		fi
	fi
	if [ $type2 = "0" ]; then
		if [ $reorder = "YES" ]; then
			if [ -f $HOME/.forward ]; then
				echo "You already have a .forward file.  You will need to pipe all mail to the"
				echo "command $instdir/reorder1/mail-in."
			else
				echo "\"|$instdir/reorder1/mail-in\"" > $HOME/.forward
			fi
		else
			if [ -f $HOME/.forward ]; then
				echo "You already have a .forward file.  You will need to pipe all mail to the"
				echo "command $instdir/$remailer/remailer."
			else
				echo "\"|$instdir/$remailer/remailer\"" > $HOME/.forward
			fi
		fi
	fi
	echo "Installation of Type I remailer complete."
	echo "Be sure to read the documentation and edit the help file."
fi
if [ $type2 = "1" ]; then
	echo "On what system are you compiling Mixmaster?  If you are compiling this for a system"
	echo -n "not listed, type \"all\". [linux/sunos/alpha/solaris/hpux/bsdi/freebsd] "
	read systype
	echo "Enter the passphrase for Mixmaster"
	stty -echo
	read mixpass
	stty echo
	zcat mix-2.0.3.tar.gz | tar xf -
	mixdir=$instdir/Mix
	cd Mix/Src
	echo "Now compiling Mixmaster.  This may take a few minutes."
	make $systype PASS=$mixpass MIXPATH=$mixdir >/dev/null
	cd ../..
	if [ $type1 = "1" ]; then
		mixaddr=$raddress
		mixcomplain=$rcomplain
		mixinews=$inews
		mixpost=$post
		mixreorderenable=$reorder
		if [ $reorder = "YES" ]; then
			mixtype1=$instdir/reorder1/mail-in
		else
			mixtype1=$instdir/$remailer/remailer
		fi
	fi
	if [ ! $mixaddr ]; then
		echo -n "What do you want the email address of the remailer to be? [$USER@$HOSTNAME] "
		read line
		if [ ! $line ]; then
			mixaddr=$USER@$HOSTNAME
		else
			mixaddr=$line
		fi
		unset line
	fi
	if [ ! $mixcomplain ]; then
		echo -n "What is the email address to which you want complaints sent? [$USER@$HOSTNAME] "
		read line
		if [ ! $line ]; then
			mixcomplain=$USER@$HOSTNAME
		else
			mixcomplain=$line
		fi
		unset line
	fi
	if [ ! $mixpost ]; then
		echo -n "Do you want to allow Usenet posting? [y/N] "
		read line
		if [ ! $line ]; then
			mixpost=NO
		elif [ $line = "y" ]; then
			mixpost=YES
		else
			mixpost=NO
		fi
		unset line
		if [ $mixpost = "YES" ]; then
			echo -n "What is the path to inews?  Type \"mail-to-news\" to use a mail-to-news gateway. [`which inews`] "
			read line
			if [ ! $line ]; then
				mixinews=`which inews`
			else
				mixinews=$line
			fi
			unset line
		fi
		if [ $mixinews = "mail-to-news" ]; then
			echo -n "What is the address of the mail2news gateway? "
			read mail2news
		fi
	fi
	echo -n "What name do you want to appear in the \"From: \" header? [Mixmaster] "
	read line
	if [ ! $line ]; then
		mixname=Mixmaster
	else
		mixname=$line
	fi
	unset line
	echo -n "What do you want the short name (what will be in the type2.list file) to be? "
	read mixshort
	echo -n "What do you want the message pool size to be? [5] "
	read line
	if [ ! $line ]; then
		mixreorder=5
	else
		mixreorder=$line
	fi
	unset line
	echo -n "Where is your mail spool file? [$MAIL] "
	read line
	if [ ! $line ]; then
		mixspool=$MAIL
	else
		mixspool=$line
	fi
	unset line
	if [ $mixpost = "YES" ]; then
		sed "s/#NEWS/NEWS/" mixmaster.conf.in > /tmp/mix.conf.$$
		mv /tmp/mix.conf.$$ mixmaster.conf.in
		if [ $mixinews = "mail-to-news" ]; then
			sed "s/#MAILtoNEWS/MAILtoNEWS/" mixmaster.conf.in > /tmp/mix.conf.$$
			mv /tmp/mix.conf.$$ mixmaster.conf.in
		fi
	fi
	if [ $type1 = "1" ]; then
		sed "s/#TYPE1/TYPE1/" mixmaster.conf.in > /tmp/mix.conf.$$
		mv /tmp/mix.conf.$$ mixmaster.conf.in
	fi
	echo mixname=\"$mixname\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mixaddr=\"$mixaddr\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mixcomplain=\"$mixcomplain\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mixreorder=\"$mixreorder\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mixinews=\"$mixinews\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mail2news=\"$mail2news\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	echo mixtype1=\"$mixtype1\" | sed 's/\//\\\//g' >> /tmp/vars.$$
	. /tmp/vars.$$
	rm -f /tmp/vars.$$
	sed -e "s/@MIXNAME@/$mixname/" \
		-e "s/@MIXSHORT@/$mixshort/" \
		-e "s/@MIXADDR@/$mixaddr/" \
		-e "s/@MIXCOMPLAIN@/$mixcomplain/" \
		-e "s/@MIXREORDER@/$mixreorder/" \
		-e "s/@MIXINEWS@/$mixinews/" \
		-e "s/@MAIL2NEWS@/$mail2news/" \
		-e "s/@MIXTYPE1@/$mixtype1/" mixmaster.conf.in > mixmaster.conf
	mv mixmaster.conf Mix
	cd Mix
	echo "Now generating the key.  This will take a while."
	./mixmaster -G
	cd ..
	if [ ! $mixreorderenable ]; then
		if [ $usecron = "YES" ]; then
			echo "Do you want to enable reordering? [Y/n] "
			read line
			if [ ! $line ]; then
				mixreorderenable=YES
			elif [ $line = "n" ]; then
				mixreorderenable=NO
			else
				mixreorderenable=YES
			fi
			unset line
		fi
	fi
	if [ $mixreorderenable = "YES" ]; then
		zcat reorder.tar.gz | tar xf -
		mv reorder reorder2
		cd reorder2/Rnd
		make
		cd ../..
		mixreorderdir=$instdir/reorder2
		mixremailcom="$instdir/Mix/mixmaster -R -S -L >> $mixspool"
		echo mixremailcom=\"$mixremailcom\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		echo mixreorderdir=\"$mixreorderdir\" | sed 's/\//\\\//g' >> /tmp/vars.$$
		. /tmp/vars.$$
		rm -f /tmp/vars.$$
		sed -e "s/@REORDERDIR@/$mixreorderdir/" \
			-e "s/@REMAILCOM@/$mixremailcom/" mail-in.in > mail-in
		sed -e "s/@REORDERDIR@/$mixreorderdir/" \
			-e "s/@REMAILCOM@/$mixremailcom/" mail-out.in > mail-out
		sed -e "s/@REORDERDIR@/$mixreorderdir/" \
			-e "s/@REMAILCOM@/$mixremailcom/" mail-reorder.in > mail-reorder
		mv mail-in reorder2
		mv mail-out reorder2
		mv mail-reorder reorder2
	fi
	if [ $mixreorderenable = "YES" ]; then
		if [ -f $HOME/.forward ]; then
			echo "You already have a .forward file.  You need to pipe all mail to the"
			echo "command $instdir/reorder2/mail-in."
		else
			echo "\"|$instdir/reorder2/mail-in\"" > $HOME/.forward
		fi
		crontab -l 2>/dev/null 1>/tmp/file.cron.$$
		echo "5,15,25,35,45,55 * * * * $instdir/reorder2/mail-reorder" >> /tmp/file.cron.$$
		crontab /tmp/file.cron.$$
		rm -f /tmp/file.cron.$$
	else
		if [ -f $HOME/.forward ]; then
			echo "You already have a .forward file.  You need to pipe all mail to the"
			echo "command $instdir/Mix/mixmaster -R -S -L >> $mixspool."
		else
			echo "\"|$instdir/Mix/mixmaster -R -S -L >> $mixspool\"" > $HOME/.forward
		fi
	fi
	echo "Installation of Type II remailer complete."
	echo "Be sure to read the documentation and edit the help file."
fi
