/*
*
*   Remail 1.97: an anonymous remailer for Waffle 1.65
*
*   Cypherpunx wr1te K0d3!
*
*   Copyright (C) 1994  Patrick Oonk (kafka@desert.hacktic.nl)
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Compile with Borland C++
*/

#include <alloc.h>
#include <dos.h>
#include <fcntl.h>
#include <fstream.h>
#include <io.h>
#include <iostream.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>
#include <time.h>

#define MAXLINELEN 1024

char *AnonId(char *buf, char *addr);
char *getStatic( char *field, char *buffer);
char *to2addr(char *to);
int checkforum(char *forum);
int fcopy(char *infile, char *outfile);
void AddInfoFile(FILE *msg);
void AddToDb(char *id, char *addr);
void SendHelp(char *from, char *UnixDate);
void bounce(FILE *f, char *from, char *UnixDate);
void main(int argc, char *argv[]);
void ping(char *from, char *UnixDate);
void sendmail(char *from, char *to, char *fname);
void wipe(FILE *f);

static char uucpname[128];
static char my_name[20];
static char node[50];
static char organ[128];
static char spool[128];
static char tz[6];
static char waffle[128];

static int internal_rmail=0;
static int penet=0;
static int verbose=0;

void main(int argc, char *argv[])
{
    FILE *f;
    FILE *in;
    FILE *info;
    FILE *pgp;

    char *fname;
    char *iname;
    char *templ = "XXXXXX";
    char UnixDate[30] = "\0";
    char buffer[128] = "\0";
    char c[MAXLINELEN] = "\0";
    char cmd[128] = "\0";
    char env[100];
    char from[60] = "\0";
    char id[10];
//    char my_name[20];
    char oldenv[100];
    char passphrase[128];
    char subj[128] = "\0";
    char tmp[128];
    char to822[1024]="\0";
    char to[1024] = "\0";

    const char *Days[]={"Mon","Tue","Wed","Thu","Fri","Sat","Sun",NULL};
    const char *Months[]={"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                          "Jul","Aug","Sep","Oct","Nov","Dec", NULL};

    struct dosdate_t d;
	struct time t;

    int encrypted = 0;
    int ch;
    int x;
    int penet=0;
    int allow_test=0;
    int x_remailer=1;
    int update_usenet=1;
    int ping_cmd=0;
    int help_cmd=0;
    long int pos;

    printf("Remail 1.97: Cypherpunks write code!\n");

    if (argc < 2)
    {
        printf("Usage: remail [options] remailer-username < msg\n");
        printf(" -r       Use internal rmail\n");
        printf(" -t       Do not allow posting to alt.test, misc.test\n");
        printf(" -v[1][2] Verbose\n");
        printf(" -noxr    Do not add 'X-Remailer-Software' header to news\n");
        printf(" -noupdu  Do not update the 'usenet' file\n");
        printf(" -help    Send the help file to sender\n");
        printf(" -penet   Act like anon.penet.fi\n");
        printf(" -ping    Send a ping acknowledgement\n\n");
        printf("Example: remail -v -r -penet anon < msg\n");
        return;
    }

    strcpy(my_name,argv[argc-1]);   // name of this remailer

    if (argc > 2)
        for(x=1; x < argc; x++)
        {
            if (strstr("-penet",argv[x]) != NULL)
               penet=1;
            if (strstr("-v",argv[x]) != NULL)
               verbose=1;
            if (strstr(argv[x],"-v2") != NULL)
               verbose=2;
            if (strstr("-t",argv[x]) != NULL)
                allow_test=1;
            if (strstr("-r",argv[x]) != NULL)
                internal_rmail=1;
            if (strstr("-noxr",argv[x]) != NULL)
                x_remailer=0;
            if (strstr("-noupdu",argv[x]) != NULL)
                update_usenet=0;
            if (strstr("-help",argv[x]) != NULL)
                help_cmd=1;
            if (strstr("-ping",argv[x]) != NULL)
                ping_cmd=1;
        }

    if (verbose && penet) printf("\n* Running in PENET mode");

    strncpy(passphrase,getenv("REMAILERPASS"),sizeof(passphrase));

    getStatic("uucpname", uucpname);
    getStatic("node", node);
    getStatic("timezone", tz);
    getStatic("organ", organ);
    getStatic("waffle", waffle);
    getStatic("spool", spool);

    gettime(&t);
    _dos_getdate(&d);

    sprintf(UnixDate, "%s, %d %s %d %02d:%02d:%02d %s", Days[d.dayofweek], \
            d.day, Months[d.month-1], d.year,t.ti_hour, t.ti_min, t.ti_sec, tz);

    if ((in = fopen("in","w+t")) == NULL)
        perror("in");

    while (fgets(c, sizeof(c), stdin) != NULL)
        fputs(c,in);

    fseek(in, 0L, SEEK_SET);

    // try to read fields from header
    if (verbose) printf("\n* Reading header\n");

    while (strlen(fgets(c, sizeof(c), in)) != 1 && ! feof(in))
    {
        if (verbose==2) printf("%s",c);

        if (strstr(c, "Subject: ") == c)
        {
            strncpy(subj, &c[9], sizeof(subj));
            subj[strlen(subj)-1] = '\0';
        }

        if (strstr(c, "From: ") == c)
        {
            strcpy(from,&c[6]);
            from[strlen(from)-1] = '\0';
        }

        if (strstr(c, "X-Anon-To: ") == c)
            strncpy(to,&c[11], sizeof(to));

        if (strstr(c, "Request-Remailing-To: ") == c)
            strncpy(to,&c[22], sizeof(to));

        if (strstr(c, "Encrypted: PGP") == c)
            encrypted = 1;
     }



    if (ping_cmd)
    {
        ping(from,UnixDate);
        exit(0);
    }

    if (!penet)
    {
        if (strstr(from, "MAILER-DAEMON") != NULL)
        {
            printf("\n* Ignoring mail from %s",from);
            wipe(in);  fclose(in);  unlink("in");
            exit(0);
        }
    }

    strncpy(tmp, subj,sizeof(tmp));
    strupr(tmp);

    if ((strstr(tmp, "HELP") == tmp) || help_cmd)
    {
        SendHelp(from, UnixDate);
        wipe(in);  fclose(in);  unlink("in");
        exit(0);
    }


    if (strlen(to) > 0)
        to[strlen(to)-1] = '\0';


    pos = ftell(in);
    fgets(c, sizeof(c), in);

    if (strstr(c,"-----BEGIN PGP MESSAGE-----"))
        encrypted=1;

    fseek(in, pos, SEEK_SET);


    // if no X-Anon-To: or Request-Remailing-To:
    // and no Encryption: PGP are specified
    // we go looking for the header pasting token (::)
    if (strlen(to) == 0 && ! encrypted)
        {
        if (verbose) printf("\n* Searching for header pasting token");


        while (strlen(fgets(c, sizeof(c), in)) != 1 && ! feof(in))
            {
            if (verbose) printf("%s",c);
            if (strstr(c, "::") != NULL)
                {
                if (verbose) printf("\n* Found header pasting token");

                while (strlen(fgets(c, sizeof(c), in)) != 1 && ! feof(in))
                    {
                    if (verbose) printf("%s",c);

                    if (strstr(c, "X-Anon-To: ") == c)
                        strncpy(to,&c[11], sizeof(to));

                    if (strstr(c, "Request-Remailing-To: ") == c)
                        strncpy(to,&c[22], sizeof(to));

                    if (strstr(c, "Encrypted: PGP") == c)
                        encrypted = 1;

                    }

               if (strlen(to) > 0)
                   to[strlen(to)-1] = '\0';

               }
               break;
            }
        }

    if ( encrypted )
    {
        if (verbose) printf("\n* Reading PGP message");

        if((pgp = fopen("msg.pgp", "wt")) == NULL)
        {
            perror("\n'msg.pgp'");
            wipe(in);  fclose(in);  unlink("in");
            exit(-1);
        }

        while ((ch = getc(in)) != EOF)
        {
            putc(ch, pgp);
        }
        fclose(pgp);

        sprintf(env,"PGPPASS=%s",passphrase);
        putenv(env);

        if (verbose)
        {
            if (system("pgp +verbose=2 +force +batchmode msg.pgp msg") != 0)
            {
                perror("\nError executing PGP");
                exit(-1);
                wipe(in);  fclose(in);  unlink("in");
            }
        }
        else
        {
            if (system("pgp +verbose=0 +force +batchmode msg.pgp msg") != 0)
            {
                perror("\nError executing PGP");
                exit(-1);
            }
        }

        putenv("PGPPASS=");
        unlink("msg.pgp");

        if (verbose==2) printf("\n* Opening PGP result file 'msg'");

        if ((pgp = fopen("msg", "r+t")) == NULL)
        {
            perror("\n'msg'");
            exit(-1);
        }

        while (strlen(fgets(c, MAXLINELEN, pgp)) != 1 && ! feof(pgp))
        {
            if (strstr(c, "::")  == c)
            {
                while ((strlen(fgets(c, MAXLINELEN, pgp)) != 1) && (! feof(pgp)))
                {
                    if (strstr(c, "X-Anon-To: ") == c)
                        strncpy(to,&c[11], sizeof(to));

                    if (strstr(c, "Request-Remailing-To: ") == c)
                        strncpy(to,&c[22], sizeof(to));

                    if (strstr(c, "Subject: ") == c)
                        strncpy(subj, &c[9], sizeof(subj));

                }

            }
            // remove the lf fgets leaves in string
            subj[strlen(subj)-1] = '\0';
            to[strlen(to)-1] = '\0';
            break;
        }

    }

    if (strlen(to ) == 0)
    {
        printf("\n\a No recipient found");
        bounce(in,from,UnixDate);
        wipe(in);fclose(in);unlink("in");
        exit(-1);
    }


    if (! allow_test)
    {
        if ((strstr(to,"alt.test") != NULL) || (strstr(to,"misc.test") != NULL))
        {
            printf("\n\a* Discard post to alt.test or misc.test");
            wipe(in);fclose(in);unlink("in");
            exit(-1);
        }
    }

    if (penet)
        AnonId(id,from);

    // mail
    if (strstr(to, "@") != NULL)    // || (strstr(to, "!") != NULL))
    {
        fname = mktemp(templ);

        if((f = fopen(fname, "wt")) == NULL)
        {
            perror(fname);
            exit(1);
        }

        strncpy(to822,to2addr(to), sizeof(to822));

        if (internal_rmail)
        {
            fprintf(f, "From %s %s remote from %s\n", my_name, UnixDate,uucpname );
            fprintf(f, "Received: by %s (remail-1.97)\n",node);
            fprintf(f, "    via UUCP; %s\n",UnixDate);
            fprintf(f, "    for %s\n",to822);
        }

        if (penet)
            fprintf(f, "From: <%s@%s> (Nobody)\n", id, node);
        else
            fprintf(f, "From: <%s@%s>\n", my_name, node);
        fprintf(f, "To: %s\n", to);
        fprintf(f, "Subject: %s\n", subj);


        fprintf(f, "Date: %s\n", UnixDate);

        if (penet)
            fprintf(f, "Reply-To: <%s@%s> ( Nobody )\n",id, node);

        fprintf(f, "Remailed-By: %s@%s\n", my_name, node);
        fprintf(f, "X-Remailer-Software: Remail for Waffle 1.97\n\n");
        if ( encrypted )
        {
            while ((ch = getc(pgp)) != EOF )
                putc(ch, f);

            putc('\n', f);

            if (verbose==2) printf("\n- Wiping file 'msg'");

            wipe(pgp);

            fclose(pgp);

            unlink("msg");
        }
        else
        {
            while ((ch = getc(in)) != EOF )
                putc(ch, f);
        }

        // attach remailer info file
        if (penet)
            AddInfoFile(f);

        fclose(f);

        printf("\nRemailing to: %s\n", to);

        sendmail(my_name,to822,fname);

        f = fopen(fname, "wt");
        wipe(f);fclose(f);unlink(fname);

    }
    else    // news
    {
        fname = mktemp(templ);

        f = fopen(fname, "wt");

        if (update_usenet)
            checkforum(to);

        fprintf(f, "Path: %s!%s\n", my_name, uucpname, buffer);

        if (penet)
            fprintf(f, "From: <%s@%s> (Nobody)\n", id, node);
        else
            fprintf(f, "From: %s@%s\n", my_name, node );

        fprintf(f, "Subject: %s\n", subj);
        fprintf(f, "Date: %s\n", UnixDate);
        fprintf(f, "Newsgroups: %s\n", to);
        fprintf(f, "Remailed-By: %s@%s\n", my_name, node);

        if (x_remailer)
            fprintf(f, "X-Remailer-Software: Remail for Waffle 1.97\n");

        fprintf(f, "Organization: %s - Anonymous Remailing Service\n", organ);
        fprintf(f, "Message-ID: <anon.gate.%d%d%d%d@%s>\n\n",d.day,t.ti_hour, t.ti_min, t.ti_sec, node);

        if ( encrypted )
        {
            while ((ch = getc(pgp)) != EOF )
            {
                putc(ch , f);
            }
            putc('\n', f);

            if (verbose==2) printf("\n- Wiping file 'msg'");

            wipe(pgp);

            fclose(pgp);

            unlink("msg");
            }
        else
        {
            while ((ch = getc(in)) != EOF)
                putc(ch, f);
        }

        // attach remailer info file
        if (penet)
            AddInfoFile(f);

        fclose(f);

        printf("\nPosting to: %s\n", to);

        if (verbose)
            sprintf(cmd, "rnews -v -u %s < %s", my_name, fname);
        else
            sprintf(cmd, "rnews -u %s < %s", my_name, fname);

        if (system(cmd) != 0)
        {
            perror("\n\aError executing PGP");
            f = fopen(fname, "wt");
            wipe(f); fclose(f); unlink(fname);
            exit(-1);
        }

        f = fopen(fname, "wt");
        wipe(f); fclose(f); unlink(fname);
        }

    wipe(in); fclose(in); unlink("in");
}

char *getStatic( char *field, char *buffer)
{
    ifstream Static;
    char s[128];

	buffer[0] = '\0';

    if (verbose==2)
        printf("\n* Retrieving field '%s' from Waffle static file: '%s'", field, getenv("WAFFLE"));

    Static.open(getenv("WAFFLE"));

    if (!Static)
        printf("\n\a* getStatic: Unexpected EOF in '%s'", getenv("WAFFLE"));

    while ( Static )        // while EOF is not reached
    {

        Static.getline(buffer, 128);     // get line from file

		// check if line contains a field
        if (strstr(buffer, field) == buffer )
        {

			int i=0;
			while( buffer[i] != ':' && buffer[i] != ' ' && buffer[i] != '\0')
            {
				s[i] = buffer[i];
				i++;
            }
			s[i] = '\0';

			char *p = buffer;
            p += strlen(field);

			 // now we know for sure it's the right line in the phile
			if (strlen(s) == strlen(field))
            {
				while((p[0] == ' ' || p[0] == ':') && ! p[0] == '\0')
					p++;
            }

			strcpy(buffer, p);
            break;

        }
    }

    Static.close();

    if (strlen(buffer) == 0)
        printf("\n\a* getStatic: Could not find field '%s' in file '%s'", field, getenv("WAFFLE"));

    return (buffer);
}



void wipe(FILE *f)
{
    struct time t;
    long len;
    long n;

    gettime(&t);
    srand(t.ti_hour * t.ti_min * t.ti_sec);

    fseek(f, 0L, SEEK_END);
    len = ftell(f);
    fseek(f, 0L, SEEK_SET);

    for (n=0;n < len;n++)
        fputc(rand()%255, f);

    fseek(f, 0L, SEEK_SET);

    for (n=0;n < len;n++)
        fputc('\0', f);
}

void AddInfoFile( FILE *msg)
{
    char *iname;
    FILE *info;
    char buffer[128] = "\0";
    int c;

    iname = getStatic("remailerinfo", buffer);
    if ( strlen(iname) != 0)
    {
        if ((info = fopen(iname,"rt")) != NULL)
        {
            putc('\n',msg);
            while ((c = getc(info)) != EOF)
                putc(c, msg);
            fclose(info);
        }
        else
            perror(iname);

    }
}


char *AnonId(char *buf, char *addr)
{
    FILE *id;
    FILE *db;
    char nid[128];
    char ndb[128];
    char buffer[128];
    int n;
    int found=0;
    char c[80];
    char rfc822[1024];


    strncpy(rfc822,to2addr(addr),sizeof(rfc822));

    sprintf(ndb,"%s/%s",waffle,"/system/aliases");

    // first we look if the address is already registered
    if( (db = fopen(ndb,"rt")) != NULL )
    {
        if (verbose) printf("\n* Checking if sender has an anon ID assigned");

        while (!feof(db) && ! found)
        {
            fgets(c,sizeof(c),db);
            if ((strstr(c, rfc822) != NULL) && (strstr(c, "an") == c))
            {
                strtok(c," ");
                strcpy(buf, strtok(c, " "));
                found =1;
            }
        }
        fclose(db);
    }
    else
        perror(ndb);

    if ( ! found )  // register addres
    {
        if (verbose) printf("\n* Allocating anon ID");

        sprintf(nid,"%s/%s",waffle,"/system/id");

        if((id = fopen(nid,"rt")) != NULL)
        {
            fscanf(id, "%d",&n);
            n ++;
        }
        else
        {
            perror(nid);
            n = 0;
        }

        sprintf(buf,"an%d",n);

        fclose(id);

        if((id = fopen(nid,"wt")) != NULL)
            fprintf(id,"%d",n);
        else
            perror(nid);

        fclose(id);
        AddToDb(buf,rfc822);
    }

    return buf;
}


void AddToDb(char *id, char *addr)
{
    FILE *db;
    char fname[128];

    if (verbose) printf("\n* Registering anon ID");

    sprintf(fname,"%s/%s",waffle,"/system/aliases");

    if((db = fopen(fname,"a+")) != NULL)
        {
        fprintf(db,"\n%s %s",id,addr);
        }
    else
        perror(fname);

    fclose(db);
}


int checkforum(char *group)
{
    FILE *f;
    char c[128];
    char buffer[128];
    int found = 0;
    char g[1024];
    int n=0;


    if((f = fopen(getStatic("remailerusenet",buffer),"a+")) != NULL)
    {
        if (strstr(group,",") != NULL)
        {
            while (group[n] != ',')
            {
                g[n] = group[n];
                n++;
            }
            g[n] = '\0';
        }
        else
            strncpy(g, group, sizeof(g));

        while (!feof(f))
        {
            fgets(c, sizeof(c), f);

            if (strstr(c, g) == c)
               found = 1;

        }

        if (! found )
        {
            fseek(f, 0L, SEEK_END);
            fprintf(f, "\n%s", group);
        }
        fclose(f);

    }
    else
        perror(buffer);

    return found;
}


void bounce(FILE *f, char *from, char *UnixDate)
{

    FILE *out;
    char *fname;
    int c;
    char *templ = "XXXXXX";

    if (verbose) printf("\n* Bouncing message");

    fseek(f, 0L, SEEK_SET);

    fname = mktemp(templ);

    out = fopen(fname, "wt");

    fprintf(out, "From %s %s remote from %s\n", my_name, UnixDate, uucpname);
    fprintf(out, "From: <%s@%s>\n", my_name,node);
    fprintf(out, "To: %s\n", from);
    fprintf(out, "Subject: Message could not be remailed\n");
    fprintf(out, "Date: %s\n", UnixDate);
    fprintf(out, "X-Remailer-Software: Remail for Waffle 1.97\n\n");


    fputs("To get help, send a message with subject \"HELP\"\n\n",out);
    fputs("Your message could not be remailed, reason\n",out);
    fputs("RECIPIENT NOT FOUND\n\n",out);
    fputs("There are three common mistakes which I have seen in messages using\n",out);
    fputs("these remailers.  The first is to leave the \"::\" off.  Sometimes people\n",out);
    fputs("are not sure whether the text they write goes into the header or the\n",out);
    fputs("message body.  They may think they are putting it into the header, but\n",out);
    fputs("it is actually in the body.  The \"::\" is needed if it will be in the\n",out);
    fputs("body.  The second mistake is leaving off the blank line after the\n",out);
    fputs("material to be added to the header.  In that case the whole message gets\n",out);
    fputs("added to the header (up to the first blank in the message), causing\n",out);
    fputs("considerable confusion for the remailer and generally not allowing\n",out);
    fputs("the mail to be forwarded.  The third mistake is to misspell\n",out);
    fputs("\"Request-Remailing-To:\".\n\n",out);
    fputs("If you sent a PGP encrypted message:\n",out);
    fputs("As with ordinary remailing commands, certain mistakes are more common.\n",out);
    fputs("The most frequent is to forget the \"Encrypted: PGP\" header line,\n",out);
    fputs("which must be either in the message header itself, or be put there\n",out);
    fputs("with the \"::\" pasting token. Another common\n",out);
    fputs("mistake is to forget the \"::\" within the encrypted message itself,\n",out);
    fputs("or to forget the blank line after the \"Request-Remailing-To\" line\n",out);
    fputs("within the encrypted text.\n\n",out);

    fputs("              ---------- Unsent message follows ----------\n\n",out);

    while ((c = getc(f)) != EOF)
            putc(c, out);

    fputs("\n              --------------------------------------------\n",out);

    fclose(out);

    sendmail(my_name, to2addr(from), fname);

    unlink(fname);

}


void SendHelp(char *from, char *UnixDate)
{

    FILE *out;
    FILE *f;
    char fname[128];
    int c;

    if (verbose) printf("\n* Sending help file");

    getStatic("remailerhelp", fname);

    if (verbose==2) printf("\n* sendhelp: opening help file");

    if ((f = fopen(fname, "rt")) == NULL)
    {
        perror(fname);
        return;
    }

    if (verbose==2) printf("\n* sendhelp: opening msg file");
    if ((out = fopen("out","wt")) != NULL)
    {
        fprintf(out, "From %s %s remote from %s\n", my_name, UnixDate, uucpname);
        fprintf(out, "From: <%s@%s>\n", my_name,node);
        fprintf(out, "To: %s\n", from);
        fprintf(out, "Subject: Your help request to %s@%s\n",my_name,node);
        fprintf(out, "Date: %s\n", UnixDate);
        fprintf(out, "X-Remailer-Software: Remail for Waffle 1.97\n\n");

        while ((c = getc(f)) != EOF)
            putc(c, out);

        fclose(out);
        fclose(f);

        if (verbose==2) printf("\n* sendhelp: calling sendmail");
        strncpy(from,to2addr(from),sizeof(*from));
        sendmail(my_name,from,"out");
    }
    else
        perror("\n* sendhelp: 'out'");
}


char *to2addr(char *to)
{
    int n=0;
    char sys[60];
    char tmp[1024];
    char *c;

    sprintf(sys,"@%s",node);

    strncpy(tmp, to, sizeof(tmp));

    c = strtok(tmp," ");

    if (strlen(c) < strlen(to))
    {
        while (strstr(c,"@") == NULL)
            c = strtok(NULL," ");
    }

    if (strstr(c,sys) != NULL)
    {
        for (n=0;c[n]!='@';n++);
        c[n]='\0';
    }

    if (verbose==2) printf("\n* to2addr: %s", c);

    return(c);
}

void sendmail(char *from, char *to, char *msg)
{
    FILE *f;
    char fname[128];

    char c[1024]="\0";
    char smarthost[128];
    char target[128];
    char cmd[128];

    int found = 0;
    int n;

    if (internal_rmail && (strstr(to,"@") != NULL ))
    {
        printf("\n* sendmail: Using internal rmail");
        getStatic("smarthost", smarthost);

        // make file name for aliases file
        sprintf(fname,"%s/system/aliases", waffle);

        // see if there's an alias for this user
        f = fopen(fname,"rt");
        if (verbose) printf("\n* sendmail: opening alias file %s", fname);
        while (! feof(f) && ! found)
        {
            fgets(c,sizeof(c), f);

            if (strstr(c,to) == to)
            {
                strtok(c,"\t ");
                strncpy(to, strtok(NULL,"\t "), strlen(to));
                found=1;
            }
        }
        fclose(f);

        // find next seq number (in /waffle/uucp/sequence)
        sprintf(fname,"%s/uucp/sequence",waffle);
        if (verbose==2) printf("\n* sendmail: Opening sequence file %s",fname);

        if((f = fopen(fname,"rt+")) != NULL)
        {
            fscanf(f, "%d", &n);
        }
        else
        {
            perror(fname);
            exit(1);
        }

        if (n==9999) n = 0;

        // write new sequence number
        if (verbose==2) printf("\n* sendmail: Writing new sequence number %d",n);
        fseek(f,0L, SEEK_SET);
        fprintf(f,"%d",n+1);
        fclose(f);

        // assemble filename for .dat file
        sprintf(target, "%s/%s/%d.dat", spool, smarthost, n);

        // copy message to .dat file
        if (verbose==2) printf("\n* sendmail: Copying message file '%s' to '%s'",msg,target);
        fcopy(msg, target);

        // assemble name for .cmd file
        sprintf(fname,"%s/%s/%d.cmd", spool, smarthost, n);

        // create .cmd file
        if (verbose==2) printf("\n* sendmail: Creating cmd file '%s'",fname);
        if ((f = fopen(fname,"wt")) != NULL)
        {
            fprintf(f,"S %d.DAT D.%s%d %s - %d.DAT 0666\n", n, uucpname, n, from, n);
            fprintf(f,"S %d.XQT X.%s%d %s - %d.XQT 0666\n", n, uucpname, n, from, n);
            fclose(f);
        }
        else
        {
            perror("\n* sendmail: .dat");
        }

        // create .xqt file
        sprintf(fname,"%s/%s/%d.xqt", spool, smarthost, n);
        if (verbose==2) printf("\n* sendmail: Creating xqt file '%s'", fname);
        if ((f = fopen(fname,"wt")) != NULL)
        {
            fprintf(f, "U %s %s\n", from, uucpname);
            fputs("Z\n",f);
            fprintf(f, "F D.%s%d\n", uucpname, n);
            fprintf(f, "I D.%s%d\n", uucpname, n);
            fprintf(f, "C rmail %s\n", to);
            fclose(f);
        }
        else
        {
            perror("\n* sendmail: .xqt");
        }
    }
    else
    {
        printf("\n* sendmail: Using external rmail\n");
        if (verbose==2) printf("\n* sendmail: to: %s\n", to);
        if (verbose)
            sprintf(cmd, "rmail -v -f %s -u %s \"%s\" < %s", my_name, my_name, to, msg);
        else
            sprintf(cmd, "rmail -f %s -u %s \"%s\" < %s", my_name, my_name, to, msg);

        if (verbose==2)
            printf("\n* sendmail: %s",cmd);

        if (system(cmd) != 0)
        {
            f = fopen(msg, "wt");
            wipe(f); fclose(f); unlink(fname);
            perror("\nError executing RMAIL");
            exit(-1);
        }
    }
}

int fcopy(char *infile, char *outfile)
{
	FILE *in, *out;

	if ((in = fopen(infile, "rt")) == NULL)
	{
		fprintf(stderr, "%s: cannot open.\n", infile);
        return -1;
	}

	if ((out = fopen(outfile, "wt")) == NULL)
	{
		fprintf(stderr, "%s: cannot open.\n", outfile);
        fclose(in);
        return -1;
	}

	while (!feof(in))
		fputc(fgetc(in), out);

	fclose(in);
	fclose(out);
    return 1;
}


void ping(char *from, char *UnixDate)
{

    FILE *out;
    char cmd[128] = "\0";
    char id[10];

    if (verbose) printf("\n* Sending ping reply");

    if ((out = fopen("out","wt")) != NULL)
        {
        fprintf(out, "From %s %s remote from %s\n", my_name, UnixDate, uucpname);
        fprintf(out, "From: <%s@%s>\n", my_name,node);
        fprintf(out, "To: %s\n", from);
        fprintf(out, "Subject: Your PING command to %s@%s\n",my_name,node);
        fprintf(out, "Date: %s\n", UnixDate);
        fprintf(out, "X-Remailer-Software: Remail for Waffle 1.97\n\n");
        fprintf(out, "PONG\n\n");

        if (penet)
            {
            AnonId(id,from);
            fprintf(out,"Allocated anonymous account %s@%s\n", id, node);
            }

        fclose(out);

        if (internal_rmail)
            sendmail(my_name,to2addr(from),"out");
        else
            {
            if (verbose)
                sprintf(cmd, "rmail -v -f %s -u %s \"%s\" < out", my_name, my_name, to2addr(from));
            else
                sprintf(cmd, "rmail -f %s -u %s \"%s\" < out", my_name, my_name, to2addr(from));

            if (system(cmd) != 0)
                {
                perror("\n\a* ping: rmail.exe");
                unlink("out");
                exit(-1);
                }

            }
        unlink("out");
        }
    else
        perror("\n'out'");
}


