#ifndef ASN_H
#define ASN_H

#include "cryptlib.h"
#include "queue.h"

// NOTE: these tags and flags are NOT COMPLETE!
enum ASNTag {INTEGER=0x02, BIT_STRING=0x03, SEQUENCE=0x10};
enum ASNIdFlag {CONSTRUCTED = 0x20};

unsigned int DERLengthEncode(unsigned int length, byte *output);
unsigned int DERLengthEncode(unsigned int length, BufferedTransformation &);

#ifdef THROW_EXCEPTIONS
#define BERDecodeError() throw BERDecodeErr()
#else
#define BERDecodeError() assert (FALSE)
#endif

class BERDecodeErr {};

boolean BERLengthDecode(BufferedTransformation &, unsigned int &);

class BERSequenceDecoder : public BufferedTransformation
{
public:
    BERSequenceDecoder(BufferedTransformation &inQueue);
    ~BERSequenceDecoder();

    void Put(byte inByte) {}
    void Put(const byte *inString, unsigned int length) {}

    unsigned long MaxRetrieveable()
        {return inQueue.MaxRetrieveable();}
    int Get(byte &outByte)
        {return inQueue.Get(outByte);}
    unsigned int Get(byte *outString, unsigned int getMax)
        {return inQueue.Get(outString, getMax);}

private:
    BufferedTransformation &inQueue;
    boolean definiteLength;
    unsigned int length;
};

class DERSequenceEncoder : public ByteQueue
{
public:
    DERSequenceEncoder(BufferedTransformation &outQueue);
    ~DERSequenceEncoder();
private:
    BufferedTransformation &outQueue;
};

#endif

