/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Serpent_Standard {
    static final String NAME = "Serpent_Standard";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = Serpent_Properties.isTraceable("Serpent_Algorithm");
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    static final int PHI = -1640531527;
    static final byte[][] Sbox = new byte[][]{{3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}};
    static final byte[][] SboxInverse = new byte[][]{{13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}};
    static final byte[] IPtable = new byte[]{0, 32, 64, 96, 1, 33, 65, 97, 2, 34, 66, 98, 3, 35, 67, 99, 4, 36, 68, 100, 5, 37, 69, 101, 6, 38, 70, 102, 7, 39, 71, 103, 8, 40, 72, 104, 9, 41, 73, 105, 10, 42, 74, 106, 11, 43, 75, 107, 12, 44, 76, 108, 13, 45, 77, 109, 14, 46, 78, 110, 15, 47, 79, 111, 16, 48, 80, 112, 17, 49, 81, 113, 18, 50, 82, 114, 19, 51, 83, 115, 20, 52, 84, 116, 21, 53, 85, 117, 22, 54, 86, 118, 23, 55, 87, 119, 24, 56, 88, 120, 25, 57, 89, 121, 26, 58, 90, 122, 27, 59, 91, 123, 28, 60, 92, 124, 29, 61, 93, 125, 30, 62, 94, 126, 31, 63, 95, 127};
    static final byte[] FPtable = new byte[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125, 2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94, 98, 102, 106, 110, 114, 118, 122, 126, 3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107, 111, 115, 119, 123, 127};
    static final byte xFF = -1;
    static final byte[][] LTtable = new byte[][]{{16, 52, 56, 70, 83, 94, 105, -1}, {72, 114, 125, -1, -1, -1, -1, -1}, {2, 9, 15, 30, 76, 84, 126, -1}, {36, 90, 103, -1, -1, -1, -1, -1}, {20, 56, 60, 74, 87, 98, 109, -1}, {1, 76, 118, -1, -1, -1, -1, -1}, {2, 6, 13, 19, 34, 80, 88, -1}, {40, 94, 107, -1, -1, -1, -1, -1}, {24, 60, 64, 78, 91, 102, 113, -1}, {5, 80, 122, -1, -1, -1, -1, -1}, {6, 10, 17, 23, 38, 84, 92, -1}, {44, 98, 111, -1, -1, -1, -1, -1}, {28, 64, 68, 82, 95, 106, 117, -1}, {9, 84, 126, -1, -1, -1, -1, -1}, {10, 14, 21, 27, 42, 88, 96, -1}, {48, 102, 115, -1, -1, -1, -1, -1}, {32, 68, 72, 86, 99, 110, 121, -1}, {2, 13, 88, -1, -1, -1, -1, -1}, {14, 18, 25, 31, 46, 92, 100, -1}, {52, 106, 119, -1, -1, -1, -1, -1}, {36, 72, 76, 90, 103, 114, 125, -1}, {6, 17, 92, -1, -1, -1, -1, -1}, {18, 22, 29, 35, 50, 96, 104, -1}, {56, 110, 123, -1, -1, -1, -1, -1}, {1, 40, 76, 80, 94, 107, 118, -1}, {10, 21, 96, -1, -1, -1, -1, -1}, {22, 26, 33, 39, 54, 100, 108, -1}, {60, 114, 127, -1, -1, -1, -1, -1}, {5, 44, 80, 84, 98, 111, 122, -1}, {14, 25, 100, -1, -1, -1, -1, -1}, {26, 30, 37, 43, 58, 104, 112, -1}, {3, 118, -1, -1, -1, -1, -1, -1}, {9, 48, 84, 88, 102, 115, 126, -1}, {18, 29, 104, -1, -1, -1, -1, -1}, {30, 34, 41, 47, 62, 108, 116, -1}, {7, 122, -1, -1, -1, -1, -1, -1}, {2, 13, 52, 88, 92, 106, 119, -1}, {22, 33, 108, -1, -1, -1, -1, -1}, {34, 38, 45, 51, 66, 112, 120, -1}, {11, 126, -1, -1, -1, -1, -1, -1}, {6, 17, 56, 92, 96, 110, 123, -1}, {26, 37, 112, -1, -1, -1, -1, -1}, {38, 42, 49, 55, 70, 116, 124, -1}, {2, 15, 76, -1, -1, -1, -1, -1}, {10, 21, 60, 96, 100, 114, 127, -1}, {30, 41, 116, -1, -1, -1, -1, -1}, {0, 42, 46, 53, 59, 74, 120, -1}, {6, 19, 80, -1, -1, -1, -1, -1}, {3, 14, 25, 100, 104, 118, -1, -1}, {34, 45, 120, -1, -1, -1, -1, -1}, {4, 46, 50, 57, 63, 78, 124, -1}, {10, 23, 84, -1, -1, -1, -1, -1}, {7, 18, 29, 104, 108, 122, -1, -1}, {38, 49, 124, -1, -1, -1, -1, -1}, {0, 8, 50, 54, 61, 67, 82, -1}, {14, 27, 88, -1, -1, -1, -1, -1}, {11, 22, 33, 108, 112, 126, -1, -1}, {0, 42, 53, -1, -1, -1, -1, -1}, {4, 12, 54, 58, 65, 71, 86, -1}, {18, 31, 92, -1, -1, -1, -1, -1}, {2, 15, 26, 37, 76, 112, 116, -1}, {4, 46, 57, -1, -1, -1, -1, -1}, {8, 16, 58, 62, 69, 75, 90, -1}, {22, 35, 96, -1, -1, -1, -1, -1}, {6, 19, 30, 41, 80, 116, 120, -1}, {8, 50, 61, -1, -1, -1, -1, -1}, {12, 20, 62, 66, 73, 79, 94, -1}, {26, 39, 100, -1, -1, -1, -1, -1}, {10, 23, 34, 45, 84, 120, 124, -1}, {12, 54, 65, -1, -1, -1, -1, -1}, {16, 24, 66, 70, 77, 83, 98, -1}, {30, 43, 104, -1, -1, -1, -1, -1}, {0, 14, 27, 38, 49, 88, 124, -1}, {16, 58, 69, -1, -1, -1, -1, -1}, {20, 28, 70, 74, 81, 87, 102, -1}, {34, 47, 108, -1, -1, -1, -1, -1}, {0, 4, 18, 31, 42, 53, 92, -1}, {20, 62, 73, -1, -1, -1, -1, -1}, {24, 32, 74, 78, 85, 91, 106, -1}, {38, 51, 112, -1, -1, -1, -1, -1}, {4, 8, 22, 35, 46, 57, 96, -1}, {24, 66, 77, -1, -1, -1, -1, -1}, {28, 36, 78, 82, 89, 95, 110, -1}, {42, 55, 116, -1, -1, -1, -1, -1}, {8, 12, 26, 39, 50, 61, 100, -1}, {28, 70, 81, -1, -1, -1, -1, -1}, {32, 40, 82, 86, 93, 99, 114, -1}, {46, 59, 120, -1, -1, -1, -1, -1}, {12, 16, 30, 43, 54, 65, 104, -1}, {32, 74, 85, -1, -1, -1, -1, -1}, {36, 90, 103, 118, -1, -1, -1, -1}, {50, 63, 124, -1, -1, -1, -1, -1}, {16, 20, 34, 47, 58, 69, 108, -1}, {36, 78, 89, -1, -1, -1, -1, -1}, {40, 94, 107, 122, -1, -1, -1, -1}, {0, 54, 67, -1, -1, -1, -1, -1}, {20, 24, 38, 51, 62, 73, 112, -1}, {40, 82, 93, -1, -1, -1, -1, -1}, {44, 98, 111, 126, -1, -1, -1, -1}, {4, 58, 71, -1, -1, -1, -1, -1}, {24, 28, 42, 55, 66, 77, 116, -1}, {44, 86, 97, -1, -1, -1, -1, -1}, {2, 48, 102, 115, -1, -1, -1, -1}, {8, 62, 75, -1, -1, -1, -1, -1}, {28, 32, 46, 59, 70, 81, 120, -1}, {48, 90, 101, -1, -1, -1, -1, -1}, {6, 52, 106, 119, -1, -1, -1, -1}, {12, 66, 79, -1, -1, -1, -1, -1}, {32, 36, 50, 63, 74, 85, 124, -1}, {52, 94, 105, -1, -1, -1, -1, -1}, {10, 56, 110, 123, -1, -1, -1, -1}, {16, 70, 83, -1, -1, -1, -1, -1}, {0, 36, 40, 54, 67, 78, 89, -1}, {56, 98, 109, -1, -1, -1, -1, -1}, {14, 60, 114, 127, -1, -1, -1, -1}, {20, 74, 87, -1, -1, -1, -1, -1}, {4, 40, 44, 58, 71, 82, 93, -1}, {60, 102, 113, -1, -1, -1, -1, -1}, {3, 18, 72, 114, 118, 125, -1, -1}, {24, 78, 91, -1, -1, -1, -1, -1}, {8, 44, 48, 62, 75, 86, 97, -1}, {64, 106, 117, -1, -1, -1, -1, -1}, {1, 7, 22, 76, 118, 122, -1, -1}, {28, 82, 95, -1, -1, -1, -1, -1}, {12, 48, 52, 66, 79, 90, 101, -1}, {68, 110, 121, -1, -1, -1, -1, -1}, {5, 11, 26, 80, 122, 126, -1, -1}, {32, 86, 99, -1, -1, -1, -1, -1}};
    static final byte[][] LTtableInverse = new byte[][]{{53, 55, 72, -1, -1, -1, -1, -1}, {1, 5, 20, 90, -1, -1, -1, -1}, {15, 102, -1, -1, -1, -1, -1, -1}, {3, 31, 90, -1, -1, -1, -1, -1}, {57, 59, 76, -1, -1, -1, -1, -1}, {5, 9, 24, 94, -1, -1, -1, -1}, {19, 106, -1, -1, -1, -1, -1, -1}, {7, 35, 94, -1, -1, -1, -1, -1}, {61, 63, 80, -1, -1, -1, -1, -1}, {9, 13, 28, 98, -1, -1, -1, -1}, {23, 110, -1, -1, -1, -1, -1, -1}, {11, 39, 98, -1, -1, -1, -1, -1}, {65, 67, 84, -1, -1, -1, -1, -1}, {13, 17, 32, 102, -1, -1, -1, -1}, {27, 114, -1, -1, -1, -1, -1, -1}, {1, 3, 15, 20, 43, 102, -1, -1}, {69, 71, 88, -1, -1, -1, -1, -1}, {17, 21, 36, 106, -1, -1, -1, -1}, {1, 31, 118, -1, -1, -1, -1, -1}, {5, 7, 19, 24, 47, 106, -1, -1}, {73, 75, 92, -1, -1, -1, -1, -1}, {21, 25, 40, 110, -1, -1, -1, -1}, {5, 35, 122, -1, -1, -1, -1, -1}, {9, 11, 23, 28, 51, 110, -1, -1}, {77, 79, 96, -1, -1, -1, -1, -1}, {25, 29, 44, 114, -1, -1, -1, -1}, {9, 39, 126, -1, -1, -1, -1, -1}, {13, 15, 27, 32, 55, 114, -1, -1}, {81, 83, 100, -1, -1, -1, -1, -1}, {1, 29, 33, 48, 118, -1, -1, -1}, {2, 13, 43, -1, -1, -1, -1, -1}, {1, 17, 19, 31, 36, 59, 118, -1}, {85, 87, 104, -1, -1, -1, -1, -1}, {5, 33, 37, 52, 122, -1, -1, -1}, {6, 17, 47, -1, -1, -1, -1, -1}, {5, 21, 23, 35, 40, 63, 122, -1}, {89, 91, 108, -1, -1, -1, -1, -1}, {9, 37, 41, 56, 126, -1, -1, -1}, {10, 21, 51, -1, -1, -1, -1, -1}, {9, 25, 27, 39, 44, 67, 126, -1}, {93, 95, 112, -1, -1, -1, -1, -1}, {2, 13, 41, 45, 60, -1, -1, -1}, {14, 25, 55, -1, -1, -1, -1, -1}, {2, 13, 29, 31, 43, 48, 71, -1}, {97, 99, 116, -1, -1, -1, -1, -1}, {6, 17, 45, 49, 64, -1, -1, -1}, {18, 29, 59, -1, -1, -1, -1, -1}, {6, 17, 33, 35, 47, 52, 75, -1}, {101, 103, 120, -1, -1, -1, -1, -1}, {10, 21, 49, 53, 68, -1, -1, -1}, {22, 33, 63, -1, -1, -1, -1, -1}, {10, 21, 37, 39, 51, 56, 79, -1}, {105, 107, 124, -1, -1, -1, -1, -1}, {14, 25, 53, 57, 72, -1, -1, -1}, {26, 37, 67, -1, -1, -1, -1, -1}, {14, 25, 41, 43, 55, 60, 83, -1}, {0, 109, 111, -1, -1, -1, -1, -1}, {18, 29, 57, 61, 76, -1, -1, -1}, {30, 41, 71, -1, -1, -1, -1, -1}, {18, 29, 45, 47, 59, 64, 87, -1}, {4, 113, 115, -1, -1, -1, -1, -1}, {22, 33, 61, 65, 80, -1, -1, -1}, {34, 45, 75, -1, -1, -1, -1, -1}, {22, 33, 49, 51, 63, 68, 91, -1}, {8, 117, 119, -1, -1, -1, -1, -1}, {26, 37, 65, 69, 84, -1, -1, -1}, {38, 49, 79, -1, -1, -1, -1, -1}, {26, 37, 53, 55, 67, 72, 95, -1}, {12, 121, 123, -1, -1, -1, -1, -1}, {30, 41, 69, 73, 88, -1, -1, -1}, {42, 53, 83, -1, -1, -1, -1, -1}, {30, 41, 57, 59, 71, 76, 99, -1}, {16, 125, 127, -1, -1, -1, -1, -1}, {34, 45, 73, 77, 92, -1, -1, -1}, {46, 57, 87, -1, -1, -1, -1, -1}, {34, 45, 61, 63, 75, 80, 103, -1}, {1, 3, 20, -1, -1, -1, -1, -1}, {38, 49, 77, 81, 96, -1, -1, -1}, {50, 61, 91, -1, -1, -1, -1, -1}, {38, 49, 65, 67, 79, 84, 107, -1}, {5, 7, 24, -1, -1, -1, -1, -1}, {42, 53, 81, 85, 100, -1, -1, -1}, {54, 65, 95, -1, -1, -1, -1, -1}, {42, 53, 69, 71, 83, 88, 111, -1}, {9, 11, 28, -1, -1, -1, -1, -1}, {46, 57, 85, 89, 104, -1, -1, -1}, {58, 69, 99, -1, -1, -1, -1, -1}, {46, 57, 73, 75, 87, 92, 115, -1}, {13, 15, 32, -1, -1, -1, -1, -1}, {50, 61, 89, 93, 108, -1, -1, -1}, {62, 73, 103, -1, -1, -1, -1, -1}, {50, 61, 77, 79, 91, 96, 119, -1}, {17, 19, 36, -1, -1, -1, -1, -1}, {54, 65, 93, 97, 112, -1, -1, -1}, {66, 77, 107, -1, -1, -1, -1, -1}, {54, 65, 81, 83, 95, 100, 123, -1}, {21, 23, 40, -1, -1, -1, -1, -1}, {58, 69, 97, 101, 116, -1, -1, -1}, {70, 81, 111, -1, -1, -1, -1, -1}, {58, 69, 85, 87, 99, 104, 127, -1}, {25, 27, 44, -1, -1, -1, -1, -1}, {62, 73, 101, 105, 120, -1, -1, -1}, {74, 85, 115, -1, -1, -1, -1, -1}, {3, 62, 73, 89, 91, 103, 108, -1}, {29, 31, 48, -1, -1, -1, -1, -1}, {66, 77, 105, 109, 124, -1, -1, -1}, {78, 89, 119, -1, -1, -1, -1, -1}, {7, 66, 77, 93, 95, 107, 112, -1}, {33, 35, 52, -1, -1, -1, -1, -1}, {0, 70, 81, 109, 113, -1, -1, -1}, {82, 93, 123, -1, -1, -1, -1, -1}, {11, 70, 81, 97, 99, 111, 116, -1}, {37, 39, 56, -1, -1, -1, -1, -1}, {4, 74, 85, 113, 117, -1, -1, -1}, {86, 97, 127, -1, -1, -1, -1, -1}, {15, 74, 85, 101, 103, 115, 120, -1}, {41, 43, 60, -1, -1, -1, -1, -1}, {8, 78, 89, 117, 121, -1, -1, -1}, {3, 90, -1, -1, -1, -1, -1, -1}, {19, 78, 89, 105, 107, 119, 124, -1}, {45, 47, 64, -1, -1, -1, -1, -1}, {12, 82, 93, 121, 125, -1, -1, -1}, {7, 94, -1, -1, -1, -1, -1, -1}, {0, 23, 82, 93, 109, 111, 123, -1}, {49, 51, 68, -1, -1, -1, -1, -1}, {1, 16, 86, 97, 125, -1, -1, -1}, {11, 98, -1, -1, -1, -1, -1, -1}, {4, 27, 86, 97, 113, 115, 127, -1}};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Serpent_Standard: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Serpent_Standard." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        int[] nArray = new int[132];
        int n2 = 0;
        int n3 = byArray.length / 4;
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            ++n4;
        }
        if (n4 < 8) {
            nArray[n4++] = 1;
        }
        n4 = 8;
        int n5 = 0;
        while (n4 < 16) {
            n = nArray[n5] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n5++;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        n5 = 8;
        while (n4 < 8) {
            nArray[n4++] = nArray[n5++];
        }
        n3 = 132;
        while (n4 < n3) {
            n = nArray[n4 - 8] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n4;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        int[] nArray2 = new int[n3];
        n4 = 0;
        while (n4 < 33) {
            int n6 = (35 - n4) % 32;
            int n7 = nArray[4 * n4];
            int n8 = nArray[4 * n4 + 1];
            int n9 = nArray[4 * n4 + 2];
            int n10 = nArray[4 * n4 + 3];
            n5 = 0;
            while (n5 < 32) {
                int n11 = Serpent_Standard.getBit(n7, n5) | Serpent_Standard.getBit(n8, n5) << 1 | Serpent_Standard.getBit(n9, n5) << 2 | Serpent_Standard.getBit(n10, n5) << 3;
                int n12 = Serpent_Standard.S(n6, n11);
                int n13 = 4 * n4;
                nArray2[n13] = nArray2[n13] | Serpent_Standard.getBit(n12, 0) << n5;
                int n14 = 4 * n4 + 1;
                nArray2[n14] = nArray2[n14] | Serpent_Standard.getBit(n12, 1) << n5;
                int n15 = 4 * n4 + 2;
                nArray2[n15] = nArray2[n15] | Serpent_Standard.getBit(n12, 2) << n5;
                int n16 = 4 * n4 + 3;
                nArray2[n16] = nArray2[n16] | Serpent_Standard.getBit(n12, 3) << n5;
                ++n5;
            }
            ++n4;
        }
        int[][] nArray3 = new int[33][4];
        n4 = 0;
        n2 = 0;
        while (n4 < 33) {
            nArray3[n4][0] = nArray2[n2++];
            nArray3[n4][1] = nArray2[n2++];
            nArray3[n4][2] = nArray2[n2++];
            nArray3[n4][3] = nArray2[n2++];
            ++n4;
        }
        n4 = 0;
        while (n4 < 33) {
            nArray3[n4] = Serpent_Standard.IP(nArray3[n4]);
            ++n4;
        }
        return nArray3;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])object;
        int[] nArray2 = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24};
        int[] nArray3 = Serpent_Standard.IP(nArray2);
        int n2 = 0;
        while (n2 < 32) {
            nArray3 = Serpent_Standard.R(n2, nArray3, nArray);
            ++n2;
        }
        nArray2 = Serpent_Standard.FP(nArray3);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        byte[] byArray2 = new byte[]{(byte)n3, (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])object;
        int[] nArray2 = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24};
        int[] nArray3 = Serpent_Standard.FPinverse(nArray2);
        int n2 = 31;
        while (n2 >= 0) {
            nArray3 = Serpent_Standard.Rinverse(n2, nArray3, nArray);
            --n2;
        }
        nArray2 = Serpent_Standard.IPinverse(nArray3);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        byte[] byArray2 = new byte[]{(byte)n3, (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecryptGetP(int n, int n2, int n3, Object object) {
        int[][] nArray = (int[][])object;
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = Serpent_Standard.FPinverse(nArray2);
        int n4 = 31;
        while (n4 >= 0) {
            nArray3 = Serpent_Standard.Rinverse(n4, nArray3, nArray, n, n2);
            --n4;
        }
        nArray2 = Serpent_Standard.IPinverse(nArray3);
        int n5 = nArray2[0];
        int n6 = nArray2[1];
        int n7 = nArray2[2];
        int n8 = nArray2[3];
        byte[] byArray = new byte[]{(byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24), (byte)n7, (byte)(n7 >>> 8), (byte)(n7 >>> 16), (byte)(n7 >>> 24), (byte)n8, (byte)(n8 >>> 8), (byte)(n8 >>> 16), (byte)(n8 >>> 24)};
        return byArray;
    }

    private static int getBit(int n, int n2) {
        return n >>> n2 & 1;
    }

    private static int getBit(int[] nArray, int n) {
        return nArray[n / 32] >>> n % 32 & 1;
    }

    private static void setBit(int[] nArray, int n, int n2) {
        if ((n2 & 1) == 1) {
            int n3 = n / 32;
            nArray[n3] = nArray[n3] | 1 << n % 32;
            return;
        }
        int n4 = n / 32;
        nArray[n4] = nArray[n4] & ~(1 << n % 32);
    }

    private static int getNibble(int n, int n2) {
        return n >>> 4 * n2 & 0xF;
    }

    private static int[] IP(int[] nArray) {
        return Serpent_Standard.permutate(IPtable, nArray);
    }

    private static int[] IPinverse(int[] nArray) {
        return Serpent_Standard.permutate(FPtable, nArray);
    }

    private static int[] FP(int[] nArray) {
        return Serpent_Standard.permutate(FPtable, nArray);
    }

    private static int[] FPinverse(int[] nArray) {
        return Serpent_Standard.permutate(IPtable, nArray);
    }

    private static int[] permutate(byte[] byArray, int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        while (n < 128) {
            Serpent_Standard.setBit(nArray2, n, Serpent_Standard.getBit(nArray, byArray[n] & 0x7F));
            ++n;
        }
        return nArray2;
    }

    private static int[] xor128(int[] nArray, int[] nArray2) {
        return new int[]{nArray[0] ^ nArray2[0], nArray[1] ^ nArray2[1], nArray[2] ^ nArray2[2], nArray[3] ^ nArray2[3]};
    }

    private static int S(int n, int n2) {
        return Sbox[n][n2] & 0xF;
    }

    private static int Sinverse(int n, int n2) {
        return SboxInverse[n][n2] & 0xF;
    }

    private static int[] Shat(int n, int[] nArray) {
        int[] nArray2 = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] | Serpent_Standard.S(n, Serpent_Standard.getNibble(nArray[n2], n3)) << n3 * 4;
                ++n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int[] ShatInverse(int n, int[] nArray) {
        int[] nArray2 = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] | Serpent_Standard.Sinverse(n, Serpent_Standard.getNibble(nArray[n2], n3)) << n3 * 4;
                ++n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int[] LT(int[] nArray) {
        return Serpent_Standard.transform(LTtable, nArray);
    }

    private static int[] LTinverse(int[] nArray) {
        return Serpent_Standard.transform(LTtableInverse, nArray);
    }

    private static int[] transform(byte[][] byArray, int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        while (n < 128) {
            int n2 = 0;
            int n3 = 0;
            while (byArray[n][n3] != -1) {
                n2 ^= Serpent_Standard.getBit(nArray, byArray[n][n3] & 0x7F);
                ++n3;
            }
            Serpent_Standard.setBit(nArray2, n, n2);
            ++n;
        }
        return nArray2;
    }

    private static int[] R(int n, int[] nArray, int[][] nArray2) {
        int[] nArray3;
        int[] nArray4 = Serpent_Standard.xor128(nArray, nArray2[n]);
        int[] nArray5 = Serpent_Standard.Shat(n, nArray4);
        if (n >= 0 && n <= 30) {
            nArray3 = Serpent_Standard.LT(nArray5);
        } else if (n == 31) {
            nArray3 = Serpent_Standard.xor128(nArray5, nArray2[32]);
        } else {
            throw new RuntimeException("Round " + n + " is out of 0.." + 31 + " range");
        }
        return nArray3;
    }

    private static int[] Rinverse(int n, int[] nArray, int[][] nArray2) {
        int[] nArray3 = new int[4];
        if (n >= 0 && n <= 30) {
            nArray3 = Serpent_Standard.LTinverse(nArray);
        } else if (n == 31) {
            nArray3 = Serpent_Standard.xor128(nArray, nArray2[32]);
        } else {
            throw new RuntimeException("Round " + n + " is out of 0.." + 31 + " range");
        }
        int[] nArray4 = Serpent_Standard.ShatInverse(n, nArray3);
        int[] nArray5 = Serpent_Standard.xor128(nArray4, nArray2[n]);
        return nArray5;
    }

    private static int[] Rinverse(int n, int[] nArray, int[][] nArray2, int n2, int n3) {
        int[] nArray3 = new int[4];
        if (n >= 0 && n <= 30) {
            nArray3 = Serpent_Standard.LTinverse(nArray);
        } else if (n == 31) {
            nArray3 = Serpent_Standard.xor128(nArray, nArray2[32]);
        } else {
            throw new RuntimeException("Round " + n + " is out of 0.." + 31 + " range");
        }
        int[] nArray4 = Serpent_Standard.ShatInverse(n, nArray3);
        if (n == n2) {
            nArray4[0] = n3 | n3 << 4;
            nArray4[0] = nArray4[0] | nArray4[0] << 8;
            nArray4[0] = nArray4[0] | nArray4[0] << 16;
            nArray4[2] = nArray4[3] = nArray4[0];
            nArray4[1] = nArray4[3];
        }
        int[] nArray5 = Serpent_Standard.xor128(nArray4, nArray2[n]);
        return nArray5;
    }

    public static String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byte by = byArray[n2--];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toReversedString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            --n2;
        }
        return new String(cArray);
    }
}

