/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class MCT {
    static final String VERSION = "$Revision: 1.0$";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    boolean ecb = false;
    boolean cbc = false;
    boolean encrypting = false;
    boolean decrypting = false;
    String dirName;
    String keylengths;
    String cipherName;
    File destination;
    int[] keys = new int[]{128, 192, 256};
    final String eeFileName = "ecb_e_m.txt";
    final String edFileName = "ecb_d_m.txt";
    final String ceFileName = "cbc_e_m.txt";
    final String cdFileName = "cbc_d_m.txt";
    long encBlocks;
    long decBlocks;
    long keyCount;
    Method makeKey;
    Method encrypt;
    Method decrypt;

    public static void main(String[] stringArray) {
        System.out.println("NIST Monte-Carlo Tests data generator/exerciser\n$Revision: 1.0$\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        MCT mCT = new MCT();
        mCT.processOptions(stringArray);
        mCT.run();
    }

    void processOptions(String[] stringArray) {
        Object object;
        Object[] objectArray;
        int n = stringArray.length;
        if (n == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java NIST.MCT\" with no arguments for help)\n\n");
        int n2 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n2 >= n) break;
                string = stringArray[n2];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-e")) {
                this.ecb = true;
                this.cbc = false;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-c")) {
                this.ecb = false;
                this.cbc = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-E")) {
                this.encrypting = true;
                this.decrypting = false;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-D")) {
                this.encrypting = false;
                this.decrypting = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            MCT.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.keylengths != null) {
            int n3 = 0;
            objectArray = new int[3];
            object = new StringTokenizer(this.keylengths, ", \t\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n4 <= 0) {
                    MCT.halt("Negative key length not allowed: " + n4);
                }
                if (n3 == 3) {
                    MCT.halt("Only three key-length values are allowed.");
                }
                objectArray[n3++] = n4;
            }
            if (n3 != 0) {
                this.keys = new int[n3];
                System.arraycopy(objectArray, 0, this.keys, 0, n3);
            }
        }
        if (!this.ecb && !this.cbc) {
            this.cbc = true;
            this.ecb = true;
        }
        if (!this.encrypting && !this.decrypting) {
            this.decrypting = true;
            this.encrypting = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            MCT.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        String string2 = String.valueOf(this.cipherName) + "." + this.cipherName + "_Algorithm";
        try {
            Class<?> clazz = Class.forName(string2);
            objectArray = clazz.getDeclaredMethods();
            n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2].getName();
                int n5 = objectArray[n2].getParameterTypes().length;
                if (((String)object).equals("makeKey") && n5 == 1) {
                    this.makeKey = (Method)objectArray[n2];
                } else if (((String)object).equals("blockEncrypt") && n5 == 3) {
                    this.encrypt = (Method)objectArray[n2];
                } else if (((String)object).equals("blockDecrypt") && n5 == 3) {
                    this.decrypt = (Method)objectArray[n2];
                }
                ++n2;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MCT.halt("Unable to find " + string2 + " class");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MCT.halt("Unable to find " + string2 + "." + noSuchMethodException.getMessage() + " method");
        }
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("MCT: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  MCT: A Monte Carlo Tests data generator/exerciser for any AES\n  candidate cipher algorithm.\n\nSYNTAX\n  java NIST.MCT\n    [ -e | -c ]\n    [ -E | -D ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    <cipher>\n\nDESCRIPTION\n  For a designated candidate AES block cipher algorithm, this command\n  generates and exercises Monte Carlo Tests data for both Encryption\n  and Decryption in Electronic Codebook (ECB) and Cipher Block Chaining\n  (CBC) modes.\n  MCT's output file format is in conformance with the layout described\n  in Section 4 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES) Candidate\n  Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -e   Generate test data for the cipher in ECB mode only.  By default\n       MCT generates both ECB and CBC test suites.\n\n  -c   Generate test data for the cipher in CBC mode only.  By default\n       MCT generates both ECB and CBC test suites.\n\n  -E   Generate Encryption data only for the cipher in one or both of\n       ECB and CBC modes depending on the first two switches.  By default\n       MCT generates both Encryption and Decryption data.\n\n  -D   Generate Decryption data only for the cipher in one or both of\n       ECB and CBC modes depending on the first two switches.  By default\n       MCT generates both Encryption and Decryption data.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where the output files: \"ecb_e_m.txt\",\n       \"ecb_d_m.txt\", \"cbc_e_m.txt\" and \"cbc_d_m.txt\" will be generated.\n       If this destination directory is not specified, those files will\n       be placed in the current user directory.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long l = System.currentTimeMillis();
        if (this.ecb) {
            if (this.encrypting) {
                this.ecbEncrypt("ecb_e_m.txt");
            }
            if (this.decrypting) {
                this.ecbDecrypt("ecb_d_m.txt");
            }
        }
        if (this.cbc) {
            if (this.encrypting) {
                this.cbcEncrypt("cbc_e_m.txt");
            }
            if (this.decrypting) {
                this.cbcDecrypt("cbc_d_m.txt");
            }
        }
        MCT.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        MCT.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        MCT.notify("Total execution time (ms): " + (System.currentTimeMillis() - l));
        MCT.notify("During this time, " + this.cipherName + ":");
        MCT.notify("  Encrypted " + this.encBlocks + " blocks");
        MCT.notify("  Decrypted " + this.decBlocks + " blocks");
        MCT.notify("  Created " + this.keyCount + " session keys");
    }

    void ecbEncrypt(String string) {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.ecbEncryptForKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void ecbDecrypt(String string) {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode - DECRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.ecbDecryptForKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void ecbEncryptForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in ECB-Encrypt mode (long); key size: " + n);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 16;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + MCT.toString(byArray));
            printWriter.println("PT=" + MCT.toString(byArray2));
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
            ++this.encBlocks;
            int n6 = 1;
            while (n6 < 9999) {
                objectArray[0] = byArray3;
                byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                ++n6;
            }
            objectArray[0] = byArray3;
            byArray2 = (byte[])this.encrypt.invoke(null, objectArray);
            ++this.encBlocks;
            printWriter.println("CT=" + MCT.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n7 = n2 - n3;
                n5 = n3 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
            }
            ++n4;
        }
    }

    void ecbDecryptForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in ECB-Decrypt mode (long); key size: " + n);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 16;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + MCT.toString(byArray));
            printWriter.println("CT=" + MCT.toString(byArray2));
            objectArray = new Object[]{byArray2, new Integer(0), object};
            byte[] byArray3 = (byte[])this.decrypt.invoke(null, objectArray);
            ++this.decBlocks;
            int n6 = 1;
            while (n6 < 9999) {
                objectArray[0] = byArray3;
                byArray3 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                ++n6;
            }
            objectArray[0] = byArray3;
            byArray2 = (byte[])this.decrypt.invoke(null, objectArray);
            ++this.decBlocks;
            printWriter.println("PT=" + MCT.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n7 = n2 - n3;
                n5 = n3 - n7;
                while (n6 < n7) {
                    int n8 = n6++;
                    byArray[n8] = (byte)(byArray[n8] ^ byArray3[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n9 = n6++;
                byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
            }
            ++n4;
        }
    }

    void cbcEncrypt(String string) {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - ENCRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.cbcEncryptForKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void cbcDecrypt(String string) {
        PrintWriter printWriter = null;
        File file = new File(this.destination, string);
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            MCT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
        printWriter.println("Monte Carlo Test");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 128;
            while (n < 257) {
                this.cbcDecryptForKey(n, printWriter);
                n += 64;
            }
        }
        catch (Exception exception) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void cbcEncryptForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Encrypt mode (long); key size: " + n);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 16;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray4, 0, byArray3, 0, n3);
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + MCT.toString(byArray));
            printWriter.println("IV=" + MCT.toString(byArray4));
            printWriter.println("PT=" + MCT.toString(byArray2));
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            int n6 = 0;
            while (n6 < 10000) {
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray4[n7] = (byte)(byArray4[n7] ^ byArray2[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
                objectArray[0] = byArray4;
                byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                ++n6;
            }
            printWriter.println("CT=" + MCT.toString(byArray3));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray2[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray3[n5++]);
            }
            ++n4;
        }
    }

    void cbcDecryptForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Decrypt mode (long); key size: " + n);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 16;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        while (n4 < 400) {
            int n5;
            printWriter.println("I=" + n4);
            printWriter.println("KEY=" + MCT.toString(byArray));
            printWriter.println("IV=" + MCT.toString(byArray4));
            printWriter.println("CT=" + MCT.toString(byArray3));
            objectArray = new Object[]{byArray};
            Object object = this.makeKey.invoke(null, objectArray);
            ++this.keyCount;
            objectArray = new Object[3];
            objectArray[1] = new Integer(0);
            objectArray[2] = object;
            int n6 = 0;
            while (n6 < 10000) {
                objectArray[0] = byArray3;
                byArray2 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                n5 = 0;
                while (n5 < n3) {
                    int n7 = n5;
                    byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n5]);
                    ++n5;
                }
                System.arraycopy(byArray3, 0, byArray4, 0, n3);
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                ++n6;
            }
            printWriter.println("PT=" + MCT.toString(byArray2));
            printWriter.println();
            n6 = 0;
            if (n2 > n3) {
                int n8 = n2 - n3;
                n5 = n3 - n8;
                while (n6 < n8) {
                    int n9 = n6++;
                    byArray[n9] = (byte)(byArray[n9] ^ byArray4[n5++]);
                }
            }
            n5 = 0;
            while (n6 < n2) {
                int n10 = n6++;
                byArray[n10] = (byte)(byArray[n10] ^ byArray2[n5++]);
            }
            ++n4;
        }
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            byte by = byArray[--n2];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }
}

