#include <genmap.h>

template <class T>
class WeakSet<T> {
  int size;
  T **pointers;
  public:
  WeakSet() { size = 0; pointer = 0; }
  void add(T* ptr);
  T* iterate(void *&state);
};

void WeakSet<T>::add(T* ptr)
{
  int i;
  for (i = 0; pointers[i] != NULL; i++)
    {
      if (i == size)
	{
	  add more space();
	}
    }
  pointers[i] = ptr;
  GC_register....(&pointers[i]);
}

T* WeakSet<T>::iterate(void*& state)
{
  if (state==NULL)
    state = &pointers[0];
  int i;
  for (;; i++) {
    if (i >= size)
      {
	state = NULL;
	return NULL;
      }
    if (pointers[i])
      {
	state = &pointers[i+1];
	return pointers[i];
      }
  }
}

clas AVector;

class Slice : public GenSeq {
  AVector* _vec;
  size_t _start;
  size_t _length;
public:
  virtual size_t length() { return _length; }
  virtual Root * index(index_t i);
  virtual void replace(GenSeq *new_val, size_t _start=0, size_t _length= NPOS);
};

class AVector : public Slice {
  WeakSet<Slice> slices;
  virtual void replace(GenSeq *new_val, size_t _start=0, size_t _length= NPOS);
};

void
Slice::replace(GenSeq *new_val, size_t start, size_t length)
{
  _vec->replace(new_val, start + _start, length);
}

void
AVector::replace(GenSeq *new_val, size_t start, size_t length)
{
  size_t new_length = new_val->length():
  ... actually update the data ...;

  Slice *slice;
  for (void* state = NULL; slice = slices.iterate(state); )
    {
      if (slice->_start + slice->_length < start)
	{
	  /* Slice comes before change. */
	}
      else if (slice->_start > start + length)
	{
	  /* Slice comes after change. */
	  slice->_start += new_length - length;
	}
      else
	{
	}
    }
  
}

Root*
Slice::index(index_t i)
{
  if (i < 0)
    i += length() + 1;
  if (i >= _length)
    return Missing;
  return _vec->index(i + _start);
}

AVector::foo()
{
  Slice *slice;
  for (void* state = NULL; slice = slices.iterate(state); )
    {
      whatever(slice);
    }
}
