#ifndef UTILH
#define UTILH
/*  t. lord	Tue Oct 15 17:31:52 1991	*/
/*	Copyright (C) 1992 Free Software Foundation, Inc.

This file is GNU software.

GNU software is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "proto.h"

extern void *check_malloc P_((int, char *f, int l));
extern void *check_calloc P_((int, char *f, int l));
extern void *check_realloc P_((void *, int, char *f, int l));
extern void check_free P_((void *, char *f, int l));
extern void (*check_error) P_((char *));
extern void check_abort P_((char *));
extern void *check_palloc P_((int, char *f, int l));
extern void *check_pcalloc P_((int, char *f, int l));
extern void check_pfree P_((void *, int, char *f, int l));

#define ck_malloc(X)		check_malloc(X, __FILE__, __LINE__)
#define ck_palloc(X)		check_palloc(X, __FILE__, __LINE__)
#define ck_calloc(X)		check_calloc(X, __FILE__, __LINE__)
#define ck_pcalloc(X)		check_pcalloc(X, __FILE__, __LINE__)
#define ck_realloc(M, X)	check_realloc(M, X, __FILE__, __LINE__)
#define ck_free(M)		check_free(M, __FILE__, __LINE__)
#define ck_pfree(M,X)		check_pfree(M, X, __FILE__, __LINE__)
#define ck_abort(M)		check_abort(M)

#endif

