/*
 * Electric(tm) VLSI Design System
 *
 * File: drc.h
 * Design-rule check aid
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* the meaning of "DRC_options" */
#define DRCHIERDIALOG   1				/* set to force hierarchical DRC to use dialog */
#define DRCFIRSTERROR   2				/* set to stop after first error in a facet */

extern AIDENTRY *dr_aid;				/* the DRC aid object */
extern INTBIG    dr_ignore_listkey;		/* key for aid:drc.DRC_ignore_list */
extern INTBIG    dr_lastgooddrckey;		/* key for "DRC_last_good_drc" */
extern INTBIG    dr_options;			/* cached options */

void     dr_init(INTBIG*, char*[], AIDENTRY*);
void     dr_done(void);
INTSML   dr_set(INTSML, char*[]);
void     dr_examinenodeproto(NODEPROTO*);
void     dr_slice(void);
void     dr_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void     dr_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void     dr_newobject(INTBIG, INTBIG);
void     dr_killobject(INTBIG, INTBIG);
void     dr_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void     dr_readlibrary(LIBRARY*);
void     dr_eraselibrary(LIBRARY*);

/* intertool prototypes */
INTSML   dr_flatwrite(NODEPROTO*);
INTSML   dr_flatignore(char*);
INTSML   dr_flatunignore(char*);
NETWORK *dr_network(NODEINST*, PORTPROTO*);
INTBIG   drcb_check(NODEPROTO*);
INTSML   drcb_debug(void);
char    *drcb_next_error(INTSML highlight, GEOM **geom1, GEOM **geom2);
char    *drcb_prev_error(void);
char    *drcb_curr_error(INTSML highlight, GEOM **geom1, GEOM **geom2);
void     drcb_reset_dates(void);
INTSML   drcb_initincrementalcheck(NODEPROTO *facet);
INTSML   drcb_checkincremental(GEOM *geom, INTSML partial);
void     drcb_term(void);
INTBIG   drcb_errorcount(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
