;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          CL-PVM 1.6                                   ;;
;;            Institute for Computational Mathematics                    ;;
;;                Kent State University, Kent, OH                        ;;
;;                 Authors:  Liwei Li                                    ;;
;;                           Paul Wang                                   ;;
;;                 (C) 1996 All Rights Reserved                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(proclaim '(optimize (safety 2)))
;;;;;;;;;;;;;;;; File:  pvm3.lsp  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; C-types allowed in lisp interface are                       ;;
;; int, char, float, double, object, void                      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; lisp hack to use % to produce quoted strings (%abc is "abc");;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(eval-when (compile)
(set-macro-character
	   #\%
           #'(lambda (stream char) (values (read-line stream))))
)

(defun fillstr(str chr ps)
 (setf (aref str ps) (character chr)))

(defun fillnum(arr num ps)
 (setf (aref arr ps) num))

(defun filldnum(arr num ps)
 (setf (aref arr ps) (float num 0.1d0)))

(defun carset(des src)
 (set (car des) src))

(defun lst2arr(lst)
 (if (listp lst)
     (setq lst (make-array (list-length lst) :initial-contents lst)))
 (setq lst (car (list lst))))


(Clines
%#include <string.h>
)
(Clines
%#include <ctype.h>
)
(Clines
%#include </vol/pvm/include/pvm3.h>
)
(Clines
%#include </vol/pvm/include/pvmtev.h>
)
(Clines
%#include <sys/time.h>
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;   pvm libarry function                                       ;;
;;   int bufid = pvm_initsend(int enc)                          ;;
;;   Clear default send buffer and specify message encoding.    ;;
;;   enc   Integer  specifying  the  next  message's   encoding ;;
;;         scheme.                                              ;;
;;   bufid Integer returned containing the message buffer       ;;
;;         indentifier Values less than zero indicate an error. ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_initsend(enc)
	   int enc;" 0
%          int bufid;
%          bufid=pvm_initsend(enc);
%          Creturn(bufid);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_initsend for C function call_initsend;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-initsend(int) (int call_initsend))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;   pvm libarry function                                       ;;
;;   int info = pvm_bufinfo(int mid, int *len, int *code,       ;;
;;                      int *tid )                              ;;
;;   Returns information about a message buffer.                ;;
;;   info  Indicate the successfulness of the action.           ;;
;;   mid   Integer specifying a particular message buffer       ;;
;;         identifier.                                          ;;
;;   len   Integer returning the length in bytes of the  entire ;;
;;         message.                                             ;;
;;   code  Integer returning the message label. Useful when     ;;
;;         the message was received with a wildcard msgtag.     ;;
;;   tid   Integer returning the source of the message. Useful  ;;
;;         when the message was received with a wildcard tid.   ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_bufinfo(mid, len, code, tid)
	   int mid; object len, code, tid;" 3
%          int info,ln,cd,td;
%          info=pvm_bufinfo((int)mid, &ln, &cd, &td);
%          fprintf(stderr, "len is %d, code is %d\n", ln, cd);
	   ('nil "vs[0]")
	   ((cons (int ln) "vs[0]") "vs[0]")
	   (set len "vs[0]")
	   ('nil "vs[1]")
	   ((cons (int cd) "vs[1]") "vs[1]")
	   (set code "vs[1]") 
	   ('nil "vs[2]")
	   ((cons (int td) "vs[2]") "vs[2]")
	   (set tid "vs[2]")
%          Creturn(info);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_bufinfo for C function call_bufinfo  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-bufinfo(int object object object) (int call_bufinfo))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;   pvm libarry function                                       ;;
;;   int info = pvm_upkstr(char *cp)                            ;;
;;   Extract the message from the active message buffer to the  ;;
;;   current local message buffer.                              ;;
;;   info Indicate the successfulness of the operation.         ;;
;;   cp   The pointer to the local buffer of the returned msg.  ;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_upkstr(cp)
	   object cp;" 1
%         int i,lln,info,bufsiz;
%         char buf[200];
%         info=pvm_upkstr(buf);
%         lln=strlen(buf);
	  ('nil "vs[0]")
	  ((make-string (int lln)) "vs[0]")
%         for (i=strlen(buf)-1; i>=0; i--)
%         {
	      (fillstr "vs[0]" (char buf[i]) (int i))
%         }
	  (set cp "vs[0]")
%         Creturn(info);
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_upkstr for C function call_upkstr    ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-upkstr(object) (int call_upkstr))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;   pvm libarry function                                       ;;
;;   int info = pvm_pkstr(char *cp)                             ;;
;;   Pack the message into the local buffer.                    ;;
;;   info  Indicate the successfulness of the operation.        ;;
;;   cp    The pointer to the local buffer.                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_pkstr(cp)
	   object cp;" 0
%         int info;
%         char *buf;
%         buf=(char *)calloc(((cp->st).st_dim)+1, sizeof(char));
%         strncpy(buf, cp->st.st_self, cp->st.st_dim);
%         buf[cp->st.st_dim]='\0';
%         info=pvm_pkstr(buf);
%         Creturn(info);
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_pkstr for C function call_pkstr      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-pkstr(object) (int call_pkstr))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;   pvm libarry function                                       ;;
;;   int ntask = pvm_spawn( char *task, char **argv, int flag,  ;;
;;                         char *where, int ntask, int *tids )  ;;
;;   Starts new PVM processes.                                  ;;
;;   task    Character string which is the executable  file     ;;
;;           name of  the  PVM  process to be started.          ;;
;;   argv    Pointer to an array of arguments to  the           ;;
;;           executable.                                        ;;
;;   flag    Integer specifying spawn options.                  ;;
;;   where   Character string specifying where to start  the    ;;
;;           PVM process.                                       ;;
;;   ntask   Integer specifying the number of copies of the     ;;
;;           executable to start.                               ;;
;;   tids    Integer array of length ntask returning the tids   ;;
;;           of the PVM processes started by this pvm_spawn     ;;
;;           call;                                              ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; tids is a return value -- the list of task ids spawn
;;
(defCfun "int call_spawn(tk, av, flag, we, ntask, tid)
	   object tk, av, we, tid; int flag, ntask;" 1
	   ;; tk, av and we are lisp stings
	   ;; fg and nk are lisp fixnums
	   ;; return value of call_spawn is a list of task ids
           %  char *task, *args[20], *where, *tmp, *avs;
           %  int i, *tids;
           %  char **argv = NULL;
           %  object s;
	   %    task=(char *)calloc(((tk->st).st_dim)+1, sizeof(char));
           %    strncpy(task, (tk->st).st_self, (tk->st).st_dim);
	   %    task[(tk->st).st_dim]='\0';
	   %    fprintf(stderr, "It is %s", task);
           %    where=(char *)calloc(((we->st).st_dim)+1, sizeof(char));
           %    strncpy(where, we->st.st_self, we->st.st_dim);
           %    where[we->st.st_dim]='\0';
	   %    avs   =   (av->st).st_self;
	   %    i     =   (av->st).st_dim;
	   %    if ( i > 0 )
	   %    {   argv = args;
	   %        tmp = (char *)calloc(i+1, sizeof(char));
	   %        strncpy(tmp, avs,i);
	   %        tmp[i]='\0';
	   %    /* fill in argv */
	   %        argv[0] = strtok(tmp, " \t");
	   %        for ( i=1; i < 20 && argv[i-1] != NULL; i++ ) 
	   %            argv[i] = strtok(NULL, " \t");
	   %    /* Refinement: check for too many args */
	   %    }
	   %    tids = (int *)calloc(ntask, sizeof(int));
	   %    ntask=pvm_spawn(task, argv, flag, where, ntask, tids);
	        ((make-array (int ntask)) "vs[0]")
           %    for ( i=ntask-1; i >= 0; i-- ) 
	   %    {
		(fillnum "vs[0]" (int tids[i]) (int i))
;;	        ((cons (int tids[i]) "vs[0]") "vs[0]")
	   %    }
	        (set tid "vs[0]")
	   %    Creturn(ntask);
	   %    
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_spawn for C function call_spawn;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-spawn(object object int object int object) (int call_spawn))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm library function                                             ;;
;;    int tid pvm_parent()                                             ;;
;;    Returns the tid of the process that spawned the calling process. ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_parent()" 0
%  int tid;
%  tid=pvm_parent();
%  Creturn(tid);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_parent nfor C function call_parnet ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-parent() (int call_parent))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm library function                                             ;;
;;    int tid pvm_mytid()                                              ;;
;;    Returns the tid of the calling process.                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_mytid()" 0
%  int tid;
%  tid=pvm_mytid();
%  Creturn(tid);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_mytid nfor C function call_mytid   ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-mytid() (int call_mytid))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                      ;;
;;    int info = pvm_send( int tid, int code)                   ;;
;;    Immediately sends the data in the active  message buffer. ;;
;;                                                              ;;
;;    tid     Integer task identifier of destination process.   ;;
;;    msgtag  Integer message tag supplied by  the  user.       ;;
;;            msgtag should be >= 0.                            ;;
;;    info    Integer status code returned by the routine.      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_send(tid, code)
	   int tid, code;" 0
%	   int info;
%          info=pvm_send(tid,code);
%          Creturn(info);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_send for C function call_send  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-send(int int) (int call_send))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                      ;;
;;    int bufid = pvm_recv( int tid, int code)                  ;;
;;    Receive a message.                                        ;;
;;    tid     Integer task identifier of sending process        ;; 
;;            supplied by the user.                             ;;
;;    msgtag  Integer message tag supplied by  the  user.       ;;
;;            should be >= 0.                                   ;;
;;    bufid   Integer returns the value of the new active       ;; 
;;            receive buffer  identifier.   Values less than    ;;
;;            zero indicate an error.                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_recv(tid, code)
	   int tid, code;" 0
%          int bufid;
%          bufid=pvm_recv(tid, code);
%          Creturn(bufid);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_recv for C function call_recv  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-recv(int int) (int call_recv))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                      ;;
;;    Tells the local pvmd that this process is leaving PVM.    ;;
;;    int info = pvm_exit()                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_exit()" 0
%          int info;
%          info=pvm_exit();
%          Creturn(info);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_exit for C function call_exit  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-exit() (int call_exit))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                                    ;;
;;    Adds one or more hosts to the virtual machine                           ;;
;;    int info = pvm_addhosts(char **names, int count, int *svp)              ;;
;;    names   An array of strings naming the hosts  to  be  added.            ;;
;;    count   Integer specifying the length of array hosts.                   ;;
;;    svp     Integer array of  length  nhost  which  returns  thestatus  for ;;
;;            each host.                                                      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_addhosts(names, count, svp)
           object names, svp; int count;" 1
;; names is lisp string
;; svp is lisp fixarray
%    char **hosts, *htptr, *tmp;
%    char **hostsnm=NULL;
%    int  *status,sz,i,info; 
%    htptr=(names->st).st_self;
%    sz=(names->st).st_dim;
%    if (sz > 0)
%    {
%       hosts=(char *)calloc(count, sizeof(char*));
%       hostsnm=hosts;   
%       tmp=(char *)calloc(sz+1, sizeof(char));
%       strncpy(tmp, htptr, sz);
%       tmp[sz]='\0';
%       hostsnm[0]=strtok(tmp, " \t"); 
%       for (i=1; i<count && hostsnm[i-1] != NULL; i++)
%           hostsnm[i]=strtok(NULL, " \t");
%    }
%    status=(int *)calloc(count, sizeof(int));
%    info=pvm_addhosts(hostsnm, count, status);
     ('nil "vs[0]")
%    for (i=count-1; i>=0; i--)
%    {
	 ((cons (int status[i]) "vs[0]") "vs[0]")
%    }
     (set svp "vs[0]")
;;%    free(hosts);
%    Creturn(info);
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_addhosts for C function call_addhosts     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-addhosts(object int object) (int call_addhosts))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                                        ;;
;;    Deletes hosts from the virtual machine.                                     ;;
;;    int info = pvm_delhosts(char **hosts, int nhost, int*infos)                 ;;
;;    hosts   An array of pointers to character strings containing the names of   ;;
;;            machines to be deleted.                                             ;;
;;    nhost   Integer specifying the number of hosts to be deleted.               ;;
;;    infos   Integer array of length nhost which contains the status code        ;;
;;            returned by the routine for the individual hosts.                   ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_delhosts(names, nhost, infos)
	  object names, infos; int nhost;" 1
%    char **hosts, *htptr, *tmp;
%    char **hostsnm=NULL;
%    int  *status,sz,i,info; 
%    htptr=(names->st).st_self;
%    sz=(names->st).st_dim;
%    if (sz > 0)
%    {
%       hosts=(char *)calloc(nhost, sizeof(char*));
%       hostsnm=hosts;   
%       tmp=(char *)calloc(sz+1, sizeof(char));
%       strncpy(tmp, htptr, sz);
%       tmp[sz]='\0';
%       hostsnm[0]=strtok(tmp, " \t"); 
%       for (i=1; i<nhost && hostsnm[i-1] != NULL; i++)
%           hostsnm[i]=strtok(NULL, " \t");
%    }
%    status=(int *)calloc(nhost, sizeof(int));
%    info=pvm_delhosts(hostsnm, nhost, status);
     ('nil "vs[0]")
%    for (i=nhost-1; i>=0; i--)
%    {
	 ((cons (int status[i]) "vs[0]") "vs[0]")
%    }
     (set infos "vs[0]")
;;%    free(hosts);
%    Creturn(info);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_delhosts for C function call_delhosts     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-delhosts(object int object) (int call_delhosts))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    pvm libarry function                                      ;;
;;    Disposes of a message buffer.                             ;;
;;    int info = pvm_freebuf(int bufid)                         ;;
;;    bufid   Integer message buffer identifier.                ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defCfun "int call_freebuf(bufid)
	   int bufid;" 0
%    int info;                                               
%    info=pvm_freebuf(bufid);
%    Creturn(info);
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define lisp wrap-around function pvm_freebuf for C function call_freebuf       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defentry pvm-freebuf(int) (int call_freebuf))

;;
;;
;; int info = pvm_catchout( FILE *ff )
;;
;;
(defCfun "int call_catchout(ff)
           object ff;" 0
%    int info;
%    info=pvm_catchout((ff->sm).sm_fp);
%    return (info);
)
(defentry pvm-catchout(object) (int call_catchout))

;; 
;;
;; int info = pvm_config( int *nhost, int *narch, struct pvmhostinfo **hostp )
;;
;;
(defCfun "int call_config(nhost, narch, hostp)
	   object nhost, narch, hostp; "5
%     int place_0, place_1;
%     int info,ll;
%     int hi_tid;
%     int i,j;
%     int hi_speed;
%     object tmp;
%     char hi_labc,hi_name;
%     struct pvmhostinfo *hstp;
%     int MAXNUM=50;
%     int MAXLEN=100;
%     hstp=(struct pvmhostinfo *)calloc(MAXNUM, sizeof(struct pvmhostinfo));
%     for (i=0; i<MAXNUM; i++)
%     {
%         hstp[i].hi_name=(char *)calloc(MAXLEN, sizeof(char));
%         hstp[i].hi_name=(char *)calloc(MAXLEN-30, sizeof(char));
%     }
%     info=pvm_config(&place_0, &place_1, &hstp);
      ('nil "vs[2]")
      ('nil "vs[3]")
      ('nil "vs[4]")
      ((make-array (int place_0)) "vs[2]")
%     for (i=place_0-1; i>=0; i--)
%     {
%        hi_tid=hstp[i].hi_tid;
;;	 (print (int hi_tid))
%        ll=strlen(hstp[i].hi_name);
         ('nil "vs[0]")
	 ((make-string (int ll)) "vs[0]")
%        for (j=0; j<ll; j++)
%        {
%          hi_labc=(hstp[i].hi_name)[j];
	   (fillstr "vs[0]" (char hi_labc) (int j))
%        }
%        ll=strlen((*hstp).hi_arch);
         ('nil "vs[1]")
	 ((make-string (int ll)) "vs[1]")
%        for (j=0; j<ll; j++)
%        {
%          hi_labc=(hstp[i].hi_arch)[j];
	   (fillstr "vs[1]" (char hi_labc) (int j))
%        }
%        hi_speed=hstp[i].hi_speed;
	 ((list (int hi_tid) "vs[0]" "vs[1]" (int hi_speed)) tmp)
;;	 (print tmp)
	 (fillnum "vs[2]" tmp (int i))
%     }
      ((cons (int place_0) "vs[3]") "vs[3]")
      ((cons (int place_1) "vs[4]") "vs[4]")
      (set nhost "vs[3]")
      (set narch "vs[4]")
      (set hostp "vs[2]")
%     Creturn(info);     	 
)
(defentry pvm-config(object object object) (int call_config))

;;
;; 
;; int info = pvm_hostsync( int host, struct timeval *clk,struct timeval *delta)
;;
;;
(defCfun "int call_hostsync(host, clk, delta)
	   int host; object clk, delta;" 2
%      int info;
%      unsigned long tvsec;
%      long tvusec;
%      struct timeval timehost;
%      struct timeval timediff;
%      info=pvm_hostsync(host, &timehost, &timediff);
       ('nil "vs[0]")
%      tvsec=timehost.tv_sec;
%      tvusec=timehost.tv_usec;
       ((list (int tvsec) (int tvusec)) "vs[0]")
       (set clk "vs[0]")
       ('nil "vs[1]")
%      tvsec=timediff.tv_sec;
%      tvusec=timediff.tv_usec;
       ((list (int tvusec) (int tvusec)) "vs[1]")
       (set delta "vs[1]")
%      Creturn(info);
)
(defentry pvm-hostsync(int object object) (int call_hostsync))


;;
;;
;;int cc = pvm_reg_rm( struct pvmhostinfo **hip )
;;
;;
(defCfun "int call_reg_rm(hip)
	   object hip; " 3
%     int ll,cc,i,j;
%     int hitid;
%     int hispeed;
%     int MAXLEN=50;
%     char hinmar;
%     object tmp;
%     struct pvmhostinfo myhip;
%	 myhip.hi_name=(char *)calloc(MAXLEN, sizeof (char));
%        myhip.hi_arch=(char *)calloc(MAXLEN-30, sizeof (char));
%     cc=pvm_reg_rm(&myhip);
      ('nil "vs[2]")
         ('nil "vs[0]")
%        hitid=myhip.hi_tid;
%        ll= strlen(myhip.hi_name);
	 ((make-string (int ll)) "vs[0]")
%        for (j=0; j<=ll-1; j++)
%        {
%          hinmar=(myhip.hi_name)[j];
	   (fillstr "vs[0]" (char hinmar) (int j))
%        }
         ('nil "vs[1]")
%        ll= strlen(myhip.hi_arch);
	 ((make-string (int ll)) "vs[1]")
%        for (j=0; j<=ll-1; j++)
%        {
%          hinmar=(myhip.hi_arch)[j];
	   (fillstr "vs[1]" (char hinmar) (int j))
%        }
%        hispeed=myhip.hi_speed;
         ((list (int hitid) "vs[0]" "vs[1]" (int hispeed)) "vs[2]")
      (set hip "vs[2]")
)
(defentry pvm-reg_rm(object) (int call_reg_rm))

;;
;;
;; int info = pvm_gettmask( int who, Pvmtmask mask )
;;
;;
(defCfun "int call_gettmask(who, mask)
	   int who; object mask;" 1
%     int i,info,ll;
%     Pvmtmask mymask;
%     info=pvm_gettmask(who, mymask);
%     ll=TEV_MASK_LENGTH;
      ('nil "vs[0]")
      ((make-string (int ll)) "vs[0]")
%     for(i=TEV_MASK_LENGTH-1; i>=0; i--)
%     {
       (fillstr "vs[0]" (char mymask[i]) (int i))
%     }
      (set mask "vs[0]")
%     Creturn(info);
)

(defentry pvm-gettmask(int object) (int call_gettmask))

;;
;;
;; int info = pvm_settmask( int who, Pvmtmask mask )
;;
;;
(defCfun "int call_settmask(who, mask)
	   int who; object mask;" 0
%     int i,info;
%     char tmp;
%     Pvmtmask mymask;
%     for (i=0; i<(mask->st).st_dim; i++)
%     {
%        mymask[i]=((mask->st).st_self)[i];
%     }
%     mymask[(mask->st).st_dim]='\0';
%     info=pvm_settmask(who, mymask);
%     Creturn(info);
)
)
(defentry pvm-settmask(int object) (int call_settmask))

;;
;;
;; int info = pvm_tasks( int where, int *ntask, struct pvmtaskinfo **taskp )
;;
;;
(defCfun "int call_tasks(where,ntask,taskp)
	   int where; object ntask, taskp; " 3
%     int i,j,info;
%     int ntsk;
%     int ll, titid, tiptid, tihost, tiflag;
%     char tiaout;
%     object tmp;
%     struct pvmtaskinfo *tskp;
%     int MAXNUM=50;
%     int MAXLEN=30;
%     tskp=(struct pvmtaskinfo *)calloc(MAXNUM, sizeof(struct pvmtaskinfo));
%     for (i=0; i<MAXNUM; i++)
%     {
%         tskp[i].ti_a_out=(char *)calloc(MAXLEN, sizeof(char));
%     }
%     info=pvm_tasks(where, &ntsk, &tskp);
      ('nil "vs[0]")
      ((cons (int ntsk) "vs[0]") "vs[0]")
      (set ntask "vs[0]")
      ('nil "vs[2]")
      ((make-array (int ntsk)) "vs[2]")
%     for (i=ntsk-1; i>=0; i--)
%     {
%       titid=tskp[i].ti_tid;
%       tiptid=tskp[i].ti_ptid;
%       tihost=tskp[i].ti_host;
%       tiflag=tskp[i].ti_flag;
%       ll=strlen(tskp[i].ti_a_out);
	('nil "vs[1]")
	((make-string (int ll)) "vs[1]")
%       for (j=0; j<ll; j++)
%       {
%          tiaout=(tskp[i].ti_a_out)[j];
	   (fillstr "vs[1]" (char tiaout) (int j))
%       }
        ((list (int titid) (int tiptid) (int tihost) (int tiflag) "vs[1]")  tmp)
	(fillnum "vs[2]" tmp (int i))
%       }
        (set taskp "vs[2]")
%	Creturn(info);
)
(defentry pvm-tasks(int object object) (int call_tasks))

;;
;;
;; int bufid = pvm_trecv( int tid, int msgtag, struct timeval *tmout )
;;
;;
(defCfun "int call_trecv(tid, msgtag, tmout)
	   int tid, msgtag; object tmout;" 0
%      int bufid;
%      struct timeval mytmout;
%      mytmout.tv_sec=MP(MMcar(tmout));
%      mytmout.tv_usec=MP(MMcdr(tmout));
%      bufid=pvm_trecv(tid, msgtag, &mytmout);
%      Creturn(bufid);
)
(defentry pvm-trecv(int int object) (int call_trecv))

;;
;;
;; int info = pvm_packf( const char *fmt, ... )
;;
;;
(defCfun "int call_packf(lst) 
	    object lst; " 0
%      int info,sz,cc;
%      int inits,vh,vl,vu;
%      int initflag;
%      int intcnt,intstd;
%      int apspace;
%      char bg;
%      char *fmt;
%      char *tmp;
%      object rest;
%      int n, i,cnt, std, isv;
%      object first;
%      object lstlen;
%      object car_arg;
%      object lar_arg;
%      char *argpt;
%      int parac=0;
       (print lst)
       ((list-length lst) lstlen)
%      parac=fix(lstlen);
       (print (int parac))
%      if (parac > 0) 
%      {
	 ((car lst)  first)
	 (print first)
         ((cdr lst) rest)
%        tmp=(first->st).st_self;
%        sz=(first->st).st_dim;
%        if (sz > 0)
%        {
%           fmt=(char *)calloc(sz+1, sizeof(char));
%           strncpy(fmt, tmp, sz);
%           fmt[sz]='\0';
	    (print (int sz))
%           argpt=fmt;
%        }
%      }
%      for(i=0; i<sz; i++) 
%      {   
	  (print (char argpt[i]))
%       }
%      if (argpt[0]=='%' && argpt[1]=='+') {
	  ((car rest) car_arg)
	  ((cdr rest) rest)
%         inits=fix(car_arg);
	  (print (int inits))
	  (print rest)
	  (pvm-initsend (int inits))
%	  argpt +=2;
%      }
       (pvm-pkstr first) 
%      while (*argpt != '\0') 
%      {
	   (print (char *argpt))
%          if (*argpt++=='%')
%          {
	   (print (char *argpt))
%             intcnt=1;
%             intstd=1;
%             isv=1;
%             if (*argpt=='*') { 
		 ((car rest) car_arg)
         	 (print car_arg)
		 ((cdr rest) rest)
%                 intcnt=fix(car_arg);
		 (print (int intcnt))
%                isv=0;
%                argpt++;
%             }
%             else
%                 if (isdigit(*argpt)) {
%                         intcnt=atoi(argpt);
%                         isv=0;
%                         while(isdigit(*++argpt));
%                 }
%             if (*argpt=='.') {
%                    isv=0;
%                    if (*++argpt='*') {
			  ((car rest) car_arg)
         	          (print lar_arg)
			  ((cdr rest) rest)
%			  intstd=fix(car_arg);
%                         argpt++;
%                    } else
%                          if (isdigit(*argpt)) {
%                                  intstd=atoi(argpt);
%                                  while(isdigit(*++argpt));
%                          }
%              }
%              for (cc =1; cc;) {
%                  switch (*argpt++) {
%                  case 'h':
%                        vh = 1;
%                        break;
%                  case 'l':
%                        vl=1;
%                        break;
%                  case 'u':
%                        vu = 1;
%                        break;
%                  default:
%                        argpt--;
%                        cc=0;
%                  }
%              }
				((car rest) lar_arg)
				(print lar_arg)
				((lst2arr lar_arg) car_arg) 
				((cdr rest) rest)
				(print car_arg)
				(print (int intcnt))
				(print (int intstd))
%              switch(*argpt++) {
%              case 'c':
		       (pvm-pkbyte car_arg (int intcnt) (int intstd))
%                      break;
%              case 'd':
%                      if (vl) {
                          (pvm-pklong car_arg (int intcnt) (int intstd))
%                      } else {
%                         if (vh) {
			     (pvm-pkshort car_arg (int intcnt) (int intstd))
%                      } else {
                             (pvm-pkint car_arg (int intcnt) (int intstd))
%                               }
%                      }
%                        break;
%              case 'f':
%                        if (vl) {
			      (pvm-pkdouble car_arg (int intcnt) (int intstd))
%                        } else {
			      (pvm-pkfloat car_arg (int intcnt) (int intstd))
%                                 }
%                        break;
%              case 'x':
%                          if (vl) {
			      (pvm-pkdcplx car_arg (int intcnt) (int intstd))
%                       } else {
			      (pvm-pkcplx car_arg (int intcnt) (int intstd))
%                       }
%                       break;
%              case 's':
		       (pvm-pkstr car_arg)
%            }
%          }
%       }    
)
(defentry pvm-packf(object) (int call_packf))

;;
;; int info = pvm_unpackf( const char *fmt, ... )
;;
;;
(defCfun "int call_unpackf(lst) 
	    object lst; " 0
%      int info,sz,cc;
%      int inits,vh,vl,vu;
%      int initflag;
%      int intcnt,intstd;
%      int apspace;
%      char bg;
%      char *fmt;
%      char *tmp;
%      object rest;
%      int n, i,cnt, std, isv;
%      object first;
%      object lstlen;
%      object car_arg;
%      object lar_arg;
%      char *argpt;
%      int parac=0;
       (print lst)
       ((list-length lst) lstlen)
%      parac=fix(lstlen);
       (print (int parac))
%      if (parac > 0) 
%      {
	 ((car lst)  first)
	 (print first)
         ((cdr lst) rest)
%        tmp=(first->st).st_self;
%        sz=(first->st).st_dim;
%        if (sz > 0)
%        {
%           fmt=(char *)calloc(sz+1, sizeof(char));
%           strncpy(fmt, tmp, sz);
%           fmt[sz]='\0';
	    (print (int sz))
%           argpt=fmt;
%        }
%      }
%      for(i=0; i<sz; i++) 
%      {   
	  (print (char argpt[i]))
%       }

%      while (*argpt != '\0') 
%      {
	   (print (char *argpt))
%          if (*argpt++=='%')
%          {
	   (print (char *argpt))
%             intcnt=1;
%             intstd=1;
%             isv=1;
%             if (*argpt=='*') { 
		 ((car rest) car_arg)
         	 (print car_arg)
		 ((cdr rest) rest)
%                 intcnt=fix(car_arg);
		 (print (int intcnt))
%                isv=0;
%                argpt++;
%             }
%             else
%                 if (isdigit(*argpt)) {
%                         intcnt=atoi(argpt);
%                         isv=0;
%                         while(isdigit(*++argpt));
%                 }
%             if (*argpt=='.') {
%                    isv=0;
%                    if (*++argpt='*') {
			  ((car rest) car_arg)
         	          (print lar_arg)
			  ((cdr rest) rest)
%			  intstd=fix(car_arg);
%                         argpt++;
%                    } else
%                          if (isdigit(*argpt)) {
%                                  intstd=atoi(argpt);
%                                  while(isdigit(*++argpt));
%                          }
%              }
%              for (cc =1; cc;) {
%                  switch (*argpt++) {
%                  case 'h':
%                        vh = 1;
%                        break;
%                  case 'l':
%                        vl=1;
%                        break;
%                  case 'u':
%                        vu = 1;
%                        break;
%                  default:
%                        argpt--;
%                        cc=0;
%                  }
%              }
				((car rest) car_arg)
				((cdr rest) rest)
				(print (int intcnt))
				(print (int intstd))
%              switch(*argpt++) {
%              case 'c':
		       (pvm-upkbyte car_arg (int intcnt) (int intstd))
%                      break;
%              case 'd':
%                      if (vl) {
                          (pvm-upklong car_arg (int intcnt) (int intstd))
%                      } else {
%                         if (vh) {
			     (pvm-upkshort car_arg (int intcnt) (int intstd))
%                      } else {
                             (pvm-upkint car_arg (int intcnt) (int intstd))
%                               }
%                      }
%                        break;
%              case 'f':
%                        if (vl) {
			      (pvm-upkdouble car_arg (int intcnt) (int intstd))
%                        } else {
			      (pvm-upkfloat car_arg (int intcnt) (int intstd))
%                                 }
%                        break;
%              case 'x':
%                          if (vl) {
			      (pvm-upkdcplx car_arg (int intcnt) (int intstd))
%                       } else {
			      (pvm-upkcplx car_arg (int intcnt) (int intstd))
%                       }
%                       break;
%              case 's':
		       (pvm-pkstr car_arg)
%                      break;
%            }
%          }
%       }    
)
(defentry pvm-unpackf(object) (int call_unpackf))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;; pvmgen.pl and pvmgen.c generated interface routines ;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_archcode(arch)
object arch;" 0
%	int cod;
%	char *arch_inter;
%       arch_inter=(char *)calloc(((arch->st).st_dim)+1, sizeof(char));
%       strncpy(arch_inter, arch->st.st_self, arch->st.st_dim);
%       arch_inter[(arch->st).st_dim]='\0';
%	cod=pvm_archcode(arch_inter);
%	Creturn( cod );
)
(defentry pvm-archcode(object)  (int call_archcode))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_delete(name, index)
object name; int index;" 0
%	int cc;
%	char *name_inter;
%       name_inter=(char *)calloc(((name->st).st_dim)+1, sizeof(char));
%       strncpy(name_inter, name->st.st_self, name->st.st_dim);
%       name_inter[(name->st).st_dim]='\0';
%	cc=pvm_delete(name_inter, index);
%	Creturn( cc );
)
(defentry pvm-delete(object int)  (int call_delete))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_getopt(what)
int what;" 0
%	int val;
%	val=pvm_getopt(what);
%	Creturn( val );
)
(defentry pvm-getopt(int)  (int call_getopt))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_getrbuf()
" 0
%	int bufid;
%	bufid=pvm_getrbuf(); 
%	Creturn( bufid );
)
(defentry pvm-getrbuf() (int call_getrbuf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_getsbuf()
" 0
%	int bufid;
%	bufid=pvm_getsbuf(); 
%	Creturn( bufid );
)
(defentry pvm-getsbuf() (int call_getsbuf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_halt()
" 0
%	int info;
%	info=pvm_halt(); 
%	Creturn( info );
)
(defentry pvm-halt() (int call_halt))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_insert(name, index, data)
object name; int index; int data;" 0
%	int cc;
%	char *name_inter;
%       name_inter=(char *)calloc(((name->st).st_dim)+1, sizeof(char));
%       strncpy(name_inter, name->st.st_self, name->st.st_dim);
%       name_inter[(name->st).st_dim]='\0';
%	cc=pvm_insert(name_inter, index, data);
%	Creturn( cc );
)
(defentry pvm-insert(object int int)  (int call_insert))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_kill(tid)
int tid;" 0
%	int info;
%	info=pvm_kill(tid);
%	Creturn( info );
)
(defentry pvm-kill(int)  (int call_kill))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_lookup(name, index, data)
object name; int index; object data;" 1
%	int cc;
%	char *name_inter;
%	int place_0;
%       name_inter=(char *)calloc(((name->st).st_dim)+1, sizeof(char));
%       strncpy(name_inter, name->st.st_self, name->st.st_dim);
%       name_inter[(name->st).st_dim]='\0';
%	cc=pvm_lookup(name_inter, index, &place_0);
	('nil "vs[0]")
		((cons (int place_0) "vs[0]") "vs[0]")
	(set data "vs[0]")
%	Creturn( cc );
)
(defentry pvm-lookup(object int object)  (int call_lookup))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_mcast(tids, ntask, msgtag)
object tids; int ntask; int msgtag;" 0
%	int i, info;
%	int *tids_inter;
%       object td;
	(print tids)
	((lst2arr tids) tids)
%       tids_inter=(int *)calloc(ntask, sizeof(int));
%       for (i=0; i<ntask; i++)
%       {
         ((aref tids (int i)) td)
%        tids_inter[i]=(int)fix(td);
%       }
%	info=pvm_mcast(tids_inter, ntask, msgtag);
%	Creturn( info );
)
(defentry pvm-mcast(object int int)  (int call_mcast))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_mkbuf(encoding)
int encoding;" 0
%	int bufid;
%	bufid=pvm_mkbuf(encoding);
%	Creturn( bufid );
)
(defentry pvm-mkbuf(int)  (int call_mkbuf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_mstat(host)
object host;" 0
%	int mstat;
%	char *host_inter;
%       host_inter=(char *)calloc(((host->st).st_dim)+1, sizeof(char));
%       strncpy(host_inter, host->st.st_self, host->st.st_dim);
%       host_inter[(host->st).st_dim]='\0';
%	mstat=pvm_mstat(host_inter);
%	Creturn( mstat );
)
(defentry pvm-mstat(object)  (int call_mstat))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_notify(what, msgtag, cnt, tids)
int what; int msgtag; int cnt; object tids;" 0
%	int i,info;
%	int *tids_inter;
%       object id;
%       if (what!=3) {
%         tids_inter=(int *)calloc(cnt, sizeof(int));
        ((lst2arr tids) tids) 
%       for (i=0; i<cnt; i++)
%       {
            ((aref tids (int i)) id)
%	    tids_inter[i]=fix(id);
%        }
%       }
%	info=pvm_notify(what, msgtag, cnt, tids_inter);
%	Creturn( info );
)
(defentry pvm-notify(int int int object)  (int call_notify))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_nrecv(tid, msgtag)
int tid; int msgtag;" 0
%	int bufid;
%	bufid=pvm_nrecv(tid, msgtag);
%	Creturn( bufid );
)
(defentry pvm-nrecv(int int)  (int call_nrecv))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkbyte(xp, nitem, stride)
object xp; int nitem; int stride;" 0
%	int info;
%	char *xp_inter;
%       xp_inter=(char *)calloc(nitem*stride+1, sizeof(char));
%       strncpy(xp_inter, xp->st.st_self, nitem*stride);
%       xp_inter[nitem*stride]='\0';
%	info=pvm_pkbyte(xp_inter, nitem, stride);
;;%       free(xp_inter);
%	Creturn( info );
)
(defentry pvm-pkbyte(object int int)  (int call_pkbyte))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkcplx(cp, nitem, stride)
object cp; int nitem; int stride;" 0
%	int i, info,j;
%	float *cp_inter;
%       object df;
%       object rlpt;
%       object impt;
;;	(print cp)
	((lst2arr cp) cp)
%       cp_inter=(float *)calloc(nitem*stride*2, sizeof(float));
%       for (i=0; i<nitem*stride*2; i+=stride)
%       {
%         j=i/2;
%         if (nitem > 1) {         
            ((aref cp (int j)) df)
%         } else {
%	    df=cp;
%         }
	    ((realpart df) rlpt)
	    ((imagpart df) impt)
%           cp_inter[i]=sf(rlpt);
%           cp_inter[++i]=sf(impt);
%       }
%	info=pvm_pkcplx(cp_inter, nitem, stride);
;;%       free(cp_inter);
%	Creturn( info );
)
(defentry pvm-pkcplx(object int int)  (int call_pkcplx))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkdcplx(zp, nitem, stride)
object zp; int nitem; int stride;" 0
%	int i,info,j;
%	double *zp_inter;
%       object df;
%       object rlpt;
%       object impt;
;;	(print zp)
	((lst2arr zp) zp)
%       zp_inter=(double *)calloc(nitem*stride*2, sizeof(double));
%       for (i=0; i<nitem*stride*2; i+=stride)
%       {
%           j=i/2;
%           if (nitem > 1) {         
               ((aref zp (int j)) df)
%           } else {
%	       df=zp;
%           }
	    ((realpart df) rlpt)
	    ((imagpart df) impt)
%           zp_inter[i]=lf(rlpt);
%           zp_inter[++i]=lf(impt);
%       }
%	info=pvm_pkdcplx(zp_inter, nitem, stride);
;;%       free(zp_inter);
%	Creturn( info );
)
(defentry pvm-pkdcplx(object int int)  (int call_pkdcplx))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkdouble(dd, nitem, stride)
object dd; int nitem; int stride;" 0
%	int i,info;
%       object df;
%       double *dp_inter;
	((lst2arr dd) dd)
	(print dd)
%       if (nitem==1) {
%          dp_inter=&((dd->LF).LFVAL);
%       }
%       else
%       {
%          dp_inter=(double *)calloc(nitem*stride, sizeof(double));
%          for (i=0; i<nitem*stride; i+=stride)
%          {
              ((aref dd (int i)) df)
	      (print df)
%             dp_inter[i]=lf(df);
%          }
%       }
%	info=pvm_pkdouble(dp_inter, nitem, stride);
%       if (dp_inter != NULL) free(dp_inter);
%	Creturn( info );
)
(defentry pvm-pkdouble(object int int)  (int call_pkdouble))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkfloat(fp, nitem, stride)
object fp; int nitem; int stride;" 0
%	int i,info;
%	float *fp_inter;
%       object tf; 
	((lst2arr fp) fp)
;;	(print fp)
%       if (nitem==1)
%          fp_inter=&((fp->SF).SFVAL);
%       else
%       {
%          fp_inter=(float *)calloc(nitem*stride, sizeof(float));
%          for (i=0; i<nitem*stride; i+=stride)
%          {
              ((aref fp (int i)) tf)
%             fp_inter[i]=sf(tf);
%          }
%       }
%	info=pvm_pkfloat(fp_inter, nitem, stride);
;;%       free(fp_inter);
%	Creturn( info );
)
(defentry pvm-pkfloat(object int int)  (int call_pkfloat))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkint(ip, nitem, stride)
object ip; int nitem; int stride;" 0
%	int i,info;
%	int *ip_inter;
%       object ti;
        (print ip)
	((lst2arr ip) ip)
        (print ip)
%       if (nitem == 1)
%          ip_inter= &((ip->FIX).FIXVAL);
%       else 
%       {
%            ip_inter=(int *)calloc(nitem*stride, sizeof(int));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref ip (int i)) ti)
%               ip_inter[i]=(int)fix(ti);
%            }
%       }
%	info=pvm_pkint(ip_inter, nitem, stride);
;;%       free(ip_inter);
%	Creturn( info );
)
(defentry pvm-pkint(object int int)  (int call_pkint))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkuint(ip, nitem, stride)
object ip; int nitem; int stride;" 0
%	int i,info;
%       object ti;
%       unsigned int *ip_inter;
	((lst2arr ip) ip)
%       if (nitem == 1)
%          ip_inter= &((GEN)(ip->big).big_self);
%       else 
%       {
%            ip_inter=(unsigned int *)calloc(nitem*stride, sizeof(unsigned int));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref ip (int i)) ti)
%               ip_inter[i]=(unsigned int)MP(ti);
%            }
%       }
%	info=pvm_pkuint(ip_inter, nitem, stride);
;;%       free(ip_inter);
%	Creturn( info );
)
(defentry pvm-pkuint(object int int)  (int call_pkuint))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkushort(ip, nitem, stride)
object ip; int nitem; int stride;" 0
%	int i,info;
%	unsigned short *ip_inter;
%       object ti;
	((lst2arr ip) ip)
;;        (print ip)
%       if (nitem == 1)
%          ip_inter= &((ip->FIX).FIXVAL);
%       else 
%       {
%            ip_inter=(unsigned short *)calloc(nitem*stride, sizeof(short));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref ip (int i)) ti)
%               ip_inter[i]=(unsigned short)fix(ti);
%            }
%       }
%	info=pvm_pkushort(ip_inter, nitem, stride);
;;%       free(ip_inter);
%	Creturn( info );
)
(defentry pvm-pkushort(object int int)  (int call_pkushort))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkshort(jp, nitem, stride)
object jp; int nitem; int stride;" 0
%	int i,info;
%	int *jp_inter;
%       object ti;
	((lst2arr jp) jp)
;;        (print jp)
%       if (nitem == 1)
%          jp_inter= &((jp->FIX).FIXVAL);
%       else 
%       {
%            jp_inter=(short *)calloc(nitem*stride, sizeof(short));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref jp (int i)) ti)
%               jp_inter[i]=(short)fix(ti);
%            }
%       }
%	info=pvm_pkshort(jp_inter, nitem, stride);
;;%       free(jp_inter);
%	Creturn( info );
)
(defentry pvm-pkshort(object int int)  (int call_pkshort))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pkulong(ip, nitem, stride)
object ip; int nitem; int stride;" 0
%	int i,info;
%       object ti;
%       unsigned long *ip_inter;
	((lst2arr ip) ip)
%       if (nitem == 1)
%          ip_inter= &((GEN)(ip->big).big_self);
%       else 
%       {
%            ip_inter=(unsigned long *)calloc(nitem*stride, sizeof(long));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref ip (int i)) ti)
%               ip_inter[i]=(unsigned long int)MP(ti);
%            }
%       }
%	info=pvm_pkulong(ip_inter, nitem, stride);
;;%       free(ip_inter);
%	Creturn( info );
)
(defentry pvm-pkulong(object int int)  (int call_pkulong))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pklong(ip, nitem, stride)
object ip; int nitem; int stride;" 0
%	int i,info;
%       long int tmp; 
%	long int *ip_inter;
%       object ti;
	((lst2arr ip) ip)
         (print ip)
%       if (nitem == 1) {
%          ip_inter=&((ip->FIX).FIXVAL);
%       }else 
%       {
%            ip_inter=(long int*)calloc(nitem*stride, sizeof(long int));
%            for (i=0; i<nitem*stride; i+=stride)
%            {
                ((aref ip (int i)) ti)
		(print ti)
%               ip_inter[i]=fix(ti);
		(print (int ip_inter[i]))
%            }
%       }
%	info=pvm_pklong(ip_inter, nitem, stride);
;;%       free(ip_inter);
%	Creturn( info );
)
(defentry pvm-pklong(object int int)  (int call_pklong))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_perror(msg)
object msg;" 0
%	int info;
%	char *msg_inter;
%       msg_inter=(char *)calloc(((msg->st).st_dim)+1, sizeof(char));
%       strncpy(msg_inter, msg->st.st_self, msg->st.st_dim);
%       msg_inter[(msg->st).st_dim]='\0';
%	info=pvm_perror(msg_inter);
%	Creturn( info );
)
(defentry pvm-perror(object)  (int call_perror))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_probe(tid, msgtag)
int tid; int msgtag;" 0
%	int bufid;
%	bufid=pvm_probe(tid, msgtag);
%	Creturn( bufid );
)
(defentry pvm-probe(int int)  (int call_probe))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_pstat(tid)
int tid;" 0
%	int status;
%	status=pvm_pstat(tid);
%	Creturn( status );
)
(defentry pvm-pstat(int)  (int call_pstat))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_reg_hoster()" 0
%	int cc;
%	cc=pvm_reg_hoster();
%	Creturn( cc );
)
(defentry pvm-reg_hoster() (int call_reg_hoster))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_reg_tasker()" 0
%	int cc;
%	cc=pvm_reg_tasker();
%	Creturn( cc );
)
(defentry pvm-reg_tasker() (int call_reg_tasker))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_sendsig(tid, signum)
int tid; int signum;" 0
%	int info;
%	info=pvm_sendsig(tid, signum);
%	Creturn( info );
)
(defentry pvm-sendsig(int int)  (int call_sendsig))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;(defCfun "int call_serror(set)
;;int set;" 0
;;%	int oldset;
;;%	oldset=pvm_serror(set);
;;%	Creturn( oldset );
;;)
;;(defentry pvm-serror(int)  (int call_serror))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_getmwid(bufid)
int bufid;" 0
%	int info;
%	info=pvm_getmwid(bufid);
%	Creturn( info );
)
(defentry pvm-getmwid(int)  (int call_getmwid))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_setmwid(bufid, waitid)
int bufid; int waitid;" 0
%	int info;
%	info=pvm_setmwid(bufid, waitid);
%	Creturn( info );
)
(defentry pvm-setmwid(int int)  (int call_setmwid))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_setopt(what, val)
int what; int val;" 0
%	int oldval;
%	oldval=pvm_setopt(what, val);
%	Creturn( oldval );
)
(defentry pvm-setopt(int int)  (int call_setopt))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_setrbuf(bufid)
int bufid;" 0
%	int oldbuf;
%	oldbuf=pvm_setrbuf(bufid);
%	Creturn( oldbuf );
)
(defentry pvm-setrbuf(int)  (int call_setrbuf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_setsbuf(bufid)
int bufid;" 0
%	int oldbuf;
%	oldbuf=pvm_setsbuf(bufid);
%	Creturn( oldbuf );
)
(defentry pvm-setsbuf(int)  (int call_setsbuf))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_start_pvmd(argc, argv, block)
int argc; object argv; int block;" 0
%	int i,info;
%	char *place_0;
%	char *place_1;
%	char **argv_inter;
%	**argv_inter=NULL;
%       argv_inter=(char **)calloc(argc, sizeof(char));
%	place_1=(char *)calloc(((argv->st).st_dim)+1, sizeof(char));
%	place_0=(argv->st).st_self;
%	strncpy(place_1, place_0, ((argv->st).st_dim)+1);
%	place_1[(argv->st).st_dim]='\0';
%	argv_inter[0]=strtok(place_1, " \t");
%	for ( i=1; i<argc && argv_inter[i-1] != NULL; i++ )
%	{
%		 argv_inter[i] =strtok(NULL, " \t");
%	}
%	info=pvm_start_pvmd(argc, argv_inter, block);
%	Creturn( info );
)
(defentry pvm-start_pvmd(int object int)  (int call_start_pvmd))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_tidtohost(tid)
int tid;" 0
%	int dtid;
%	dtid=pvm_tidtohost(tid);
%	Creturn( dtid );
)
(defentry pvm-tidtohost(int)  (int call_tidtohost))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Upkbyte is similar to Upkstr.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkbyte(xp, nitem, stride)
object xp; int nitem; int stride;" 1
%	int i,info, dim;
%	char *place_0;
%       dim=nitem*stride;
%	place_0=(char *)calloc(nitem*stride, sizeof(char));
%	info=pvm_upkbyte(place_0, nitem, stride);
	('nil "vs[0]")
	((make-string (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
	    (fillstr "vs[0]" (char place_0[i]) (int i))
;;		((cons (char place_0[i]) "vs[0]") "vs[0]")
%	}
	(set xp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkbyte(object int int)  (int call_upkbyte))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkcplx(cp, nitem, stride)
object cp; int nitem; int stride;" 1
%	int i,info,j;
%       float rl, img;
%       object cplx;
%	float *place_0;
%       int dim;
%       dim=nitem*stride;
%	place_0=(float *)calloc(nitem*stride*2, sizeof(float));
%	info=pvm_upkcplx(place_0, nitem, stride);
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride*2-1; i>=0; i-=stride)
%	{  
%           j=(i-1)/2;
%           img=place_0[i];
%           rl=place_0[--i];
	    ((complex (float rl) (float img)) cplx)
	    (fillnum "vs[0]" cplx (int j))
;;		((cons (float place_0[i]) "vs[0]") "vs[0]")
%	}
	(set cp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkcplx(object int int)  (int call_upkcplx))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkdcplx(zp, nitem, stride)
object zp; int nitem; int stride;" 1
%	int i,j,info;
%       object cplx;
%       double rl, img;
%	double *place_0;
%       int dim;
%       dim=nitem*stride;
%	place_0=(double *)calloc(nitem*stride*2, sizeof(double));
%	info=pvm_upkdcplx(place_0, nitem, stride);
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride*2-1; i>=0; i-=stride)
%	{
%           j=(i-1)/2;
%           img=place_0[i];
%           rl=place_0[--i];
	    ((complex (double rl) (double img)) cplx)
	    (fillnum "vs[0]" cplx (int j))
;;		((cons (double place_0[i]) "vs[0]") "vs[0]")
%	}
	(set zp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkdcplx(object int int)  (int call_upkdcplx))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkdouble(dp, nitem, stride)
object dp; int nitem; int stride;" 1
%	int dim,i,info;
%	double *place_0;
%	place_0=(double *)calloc(nitem*stride, sizeof(double));
%	info=pvm_upkdouble(place_0, nitem, stride);
%	dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
		(filldnum "vs[0]" (double place_0[i]) (int i))
;;		((cons (double Place_0[i]) "vs[0]") "vs[0]")
%	}
	   (set dp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkdouble(object int int)  (int call_upkdouble))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkfloat(fp, nitem, stride)
object fp; int nitem; int stride;" 1
%	int i,dim,info;
%	float *place_0;
%	place_0=(float *)calloc(nitem*stride, sizeof(float));
%	info=pvm_upkfloat(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
        ((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
		(fillnum "vs[0]" (float place_0[i]) (int i))
;;		((cons (float place_0[i]) "vs[0]") "vs[0]")
%	}
        (set fp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkfloat(object int int)  (int call_upkfloat))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkint(ip, nitem, stride)
object ip; int nitem; int stride;" 1
%	int dim, i,info;
%	int *place_0;
%	place_0=(int *)calloc(nitem*stride, sizeof(int));
%	info=pvm_upkint(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
		(fillnum "vs[0]" (int place_0[i]) (int i))
;;		((cons (int place_0[i]) "vs[0]") "vs[0]")
%	}
        (set ip "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkint(object int int)  (int call_upkint))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkuint(ip, nitem, stride)
object ip; int nitem; int stride;" 1
%	int dim,i,info;
%	unsigned int *place_0;
%	place_0=(unsigned int *)calloc(nitem*stride, sizeof(int));
%	info=pvm_upkuint(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
		(fillnum "vs[0]" (int place_0[i]) (int i))
;;		((cons (int place_0[i]) "vs[0]") "vs[0]")
%	}
	(set ip "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkuint(object int int)  (int call_upkuint))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkushort(ip, nitem, stride)
object ip; int nitem; int stride;" 1
%	int dim,i,info;
%       int tmp;
%	unsigned short *place_0;
%	place_0=(unsigned short *)calloc(nitem*stride, sizeof(short));
%	info=pvm_upkushort(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
%               tmp=(int)(place_0[i]);
		(fillnum "vs[0]" (int tmp) (int i))
;;		((cons (int place_0[i]) "vs[0]") "vs[0]")
%	}
	(set ip "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkushort(object int int)  (int call_upkushort))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkulong(ip, nitem, stride)
object ip; int nitem; int stride;" 1
%	int i,dim,info;
%       unsigned long int tmp;
%	unsigned long *place_0;
%	place_0=(unsigned long *)calloc(nitem*stride, sizeof(long));
%	info=pvm_upkulong(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
%               tmp=(unsigned long int)(place_0[i]);
		(fillnum "vs[0]" (int tmp) (int i))
;;		((cons (float place_0[i]) "vs[0]") "vs[0]")
%	}
	(set ip "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkulong(object int int)  (int call_upkulong))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upklong(ip, nitem, stride)
object ip; int nitem; int stride;" 1
%	int i,dim,info;
%       object tmp;
%       long int ctmp;
%	long int *place_0;
%	place_0=(long int *)calloc(nitem*stride, sizeof(long int));
%	info=pvm_upklong(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{
                (fillnum "vs[0]" (int place_0[i]) (int i))
;;		((cons (float place_0[i]) "vs[0]") "vs[0]")
%	}
	(set ip "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upklong(object int int)  (int call_upklong))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_upkshort(jp, nitem, stride)
object jp; int nitem; int stride;" 1
%	int i,dim,info;
%	short *place_0;
%       int tmp;
%	place_0=(short *)calloc(nitem*stride, sizeof(short));
%	info=pvm_upkshort(place_0, nitem, stride);
%       dim=nitem*stride;
	('nil "vs[0]")
	((make-array (int dim)) "vs[0]")
%	for (i=nitem*stride-1; i>=0; i-=stride)
%	{      
%               tmp=(int)(place_0[i]);
		(fillnum "vs[0]" (int tmp) (int i))
;;		((cons (int place_0[i]) "vs[0]") "vs[0]")
%	}
	(set jp "vs[0]")
;;%       free(place_0);
%	Creturn( info );
)
(defentry pvm-upkshort(object int int)  (int call_upkshort))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_precv(tid, msgtag, buf, len, datatype, atid, atag, alen)
int tid; int msgtag; object buf; int len; int datatype; object atid; object atag; object alen;" 0
%       object bufid;
%       int stride=1;
        ((pvm-recv (int tid) (int msgtag)) bufid)
	(pvm-bufinfo  bufid alen atag atid)
%       switch (datatype) 
%       {
%        case PVM_STR: 
        	 (pvm-upkstr buf)
%                break; 
%        case PVM_BYTE:
		 (pvm-upkbyte buf (int len) (int stride))  
%                break;
%        case PVM_SHORT:
		 (pvm-upkshort buf (int len) (int stride)) 
%                break;
%        case PVM_INT: 
		 (pvm-upkint buf (int len) (int stride)) 
%                break;
%        case PVM_FLOAT: 
		 (pvm-upkfloat buf (int len) (int stride)) 
%                break;
%        case PVM_CPLX:  
		 (pvm-upkcplx buf (int len) (int stride)) 
%                break;
%        case PVM_DCPLX:  
        	 (pvm-upkdcplx buf (int len) (int stride)) 
%                break;
%        case PVM_LONG:  
		 (pvm-upklong buf (int len) (int stride)) 
%                break;
%        case PVM_USHORT:  
		 (pvm-upkushort buf (int len) (int stride)) 
%                break;
%        case PVM_UINT:  
		 (pvm-upkuint buf (int len) (int stride)) 
%                break;
%        case PVM_ULONG:  
		 (pvm-upkulong buf (int len) (int stride))
%		 break;
%       }
)
(defentry pvm-precv(int int object int int object object object)  (int call_precv))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defCfun "int call_psend(tid, msgtag, buf, len, datatype)
int tid; int msgtag; object buf; int len; int datatype;" 0
%      int stride=1;
%      int p=PvmDataDefault;
       (pvm-initsend (int p))
%       switch (datatype) 
%       {
%        case PVM_STR: 
        	 (pvm-pkstr buf)
%                break; 
%        case PVM_BYTE:
		 (pvm-pkbyte buf (int len) (int stride))  
%                break;
%        case PVM_SHORT:
		 (pvm-pkshort buf (int len) (int stride)) 
%                break;
%        case PVM_INT: 
		 (pvm-pkint buf (int len) (int stride)) 
%                break;
%        case PVM_FLOAT: 
		 (pvm-pkfloat buf (int len) (int stride)) 
%                break;
%        case PVM_CPLX:  
		 (pvm-pkcplx buf (int len) (int stride)) 
%                break;
%        case PVM_DCPLX:  
        	 (pvm-pkdcplx buf (int len) (int stride)) 
%                break;
%        case PVM_LONG:  
		 (pvm-pklong buf (int len) (int stride)) 
%                break;
%        case PVM_USHORT:  
		 (pvm-pkushort buf (int len) (int stride)) 
%                break;
%        case PVM_UINT:  
		 (pvm-pkuint buf (int len) (int stride)) 
%                break;
%        case PVM_ULONG:  
		 (pvm-pkulong buf (int len) (int stride))
%		 break;
%       }
	(pvm-send (int tid) (int msgtag))
)
(defentry pvm-psend(int int object int int)  (int call_psend))
