#!/usr/local/bin/wish -file

proc UsePrinter {} {
    global Type PreviewSave
    set Type Printer
    .m.t configure -text $Type
    .t.n configure -text $Type
    .m.v configure -state normal
    if {$PreviewSave == 1} {.m.v select}
}

proc UseFile {} {
    global Type Preview PreviewSave
    set Type File
    .m.t configure -text $Type
    .t.n configure -text $Type
    .m.v configure -state disabled
    set PreviewSave $Preview
    .m.v deselect
}

proc FmtASCII {} {
    global Format
    set Format ascii
    .m.f configure -text $Format
}

proc FmtLatin1 {} {
    global Format
    set Format latin1
    .m.f configure -text $Format
}

proc FmtPS {} {
    global Format
    set Format ps
    .m.f configure -text $Format
}

proc FmtDVI {} {
    global Format
    set Format dvi
    .m.f configure -text $Format
}

proc Execute {} {
    global Type Format Preview
    puts "Type=$Type"
    set Entry [.t.t get]
    puts "Entry=$Entry"
    puts "Format=$Format"
    puts "Preview=$Preview"
    destroy .
}

proc Cancel {} {
    destroy .
}

####

frame .m -borderwidth 5

pack configure .m -in .

menubutton .m.t -menu .m.t.m -width 10 -relief raised

menu .m.t.m

.m.t.m add command -label {Printer} -command UsePrinter
.m.t.m add command -label {File} -command UseFile

pack configure .m.t -in .m -side left

menubutton .m.f -menu .m.f.m -width 10 -relief raised

menu .m.f.m

.m.f.m add command -label {ascii} -command FmtASCII
.m.f.m add command -label {dvi} -command FmtDVI
.m.f.m add command -label {latin1} -command FmtLatin1
.m.f.m add command -label {ps} -command FmtPS

pack configure .m.f -after .m.t -side left

checkbutton .m.v -variable Preview -text Preview

pack configure .m.v -after .m.f -side left

####

frame .t -borderwidth 5

pack configure .t -after .m

label .t.n -width 10

pack configure .t.n -in .t -side left

entry .t.t -width 32 -borderwidth 2 -relief sunken

pack configure .t.t -after .t.n -side right

####

frame .a -borderwidth 5

pack configure .a -after .t

button .a.ok -text Execute -command Execute

pack configure .a.ok -in .a -side left

button .a.no -text Cancel -command Cancel

pack configure .a.no -after .a.ok -side right

####

set PreviewSave 0
UsePrinter
FmtPS

wm title . {TkGnats Filter Configuration}
wm iconname . TkFilter
