/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DERUniversalString
extends DERObject
implements DERString {
    byte[] string;
    char[] table;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUniversalString.getInstance(obj.getObject());
    }

    public String getString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i != this.string.length) {
            buf.append(this.table[(this.string[i] >>> 4) % 15]);
            buf.append(this.table[this.string[i] & 0xF]);
            ++i;
        }
        return buf.toString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)o).getString());
    }

    private final /* synthetic */ void this() {
        this.table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public DERUniversalString(byte[] string) {
        this.this();
        this.string = string;
    }
}

