/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: menu.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino. If not, see <http://www.gnu.org/licenses/>.
 */    

#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#include "kbd.h"
#include "file.h"
#include "edit.h"
#include "options.h"
#include "file.h"
#include "help.h"

#define EOL	10

struct menustruct
{
    int  box[4];
    char **menuItems;
    int  menuItemCount;
    void (**func)();
    //void (*func2)(char *arg);
};

int mSelect;
int endme;
int menuIndex;
struct menustruct *curMenu;

void (*fileFuncs[])() =
{
    fileMenu_New, fileMenu_Open, fileMenu_Save, fileMenu_SaveAs, fileMenu_Print, fileMenu_Exit
};

void (*editFuncs[])() =
{
    editMenu_Cut, editMenu_Copy, editMenu_Paste, editMenu_SelectAll, editMenu_Undo, 
    editMenu_Redo, editMenu_DeleteLine, editMenu_Find, editMenu_Replace, editMenu_ToggleSelectMode,
};

void (*optionsFuncs[])() =
{
    optionsMenu_Change_Colors, optionsMenu_Tab_Spaces, optionsMenu_Autoindent,
    optionsMenu_Reset_Config
};

void (*helpFuncs[])() =
{
    showReadMe, showKeybindings, showQuickReference, showAboutBox
};

struct menustruct mainMenu[] =
{
    /* File menu */
    {
        { 2, 2, 9, 19 }, fileMenu, fTotal, fileFuncs,
    },
    /* Edit menu */
    {
        { 2, 8, 13, 30 }, editMenu, eTotal, editFuncs,
    },
    /* Options menu */
    {
        { 2, 14, 7, 31 }, optionsMenu, oTotal, optionsFuncs,
    },
    /* Help menu */
    {
        { 2, 23, 7, 40 }, helpMenu, hTotal, helpFuncs,
    },
};
    
void drawMenuBox(struct menustruct *curMenu)
{
    int x1 = curMenu->box[0];
    int y1 = curMenu->box[1];
    int x2 = curMenu->box[2];
    int y2 = curMenu->box[3];
    char **menuItems = curMenu->menuItems;
    int menuItemCount = curMenu->menuItemCount;
    setScreenColorsI(COLOR_WINDOW);
    drawBox(x1++, y1++, x2, y2, NULL, YES, 0);
    setScreenColorsI(COLOR_HIGHLIGHT_TEXT);
    fprintf(stdout, "\e[%d;%dH%s", x1, y1, menuItems[0]);
    setScreenColorsI(COLOR_WINDOW);
    for(int i = 1; i < menuItemCount; i++) 
    {
      fprintf(stdout, "\e[%d;%dH%s", i+3, y1, menuItems[i]);
    }
    fprintf(stdout, "\e[%d;%dH", x1, y2-1);
    fflush(stdout);
}

void clearSelection(int y, int menuIndex, char **menuItems)
{
    //clear last selection
    setScreenColorsI(COLOR_WINDOW);
    fprintf(stdout, "\e[%d;%dH%s", menuIndex+3, y, menuItems[menuIndex]);
}

void highlightSelection(int y1, int y2, int menuIndex, char **menuItems)
{
    setScreenColorsI(COLOR_HIGHLIGHT_TEXT);
    fprintf(stdout, "\e[%d;%dH%s", menuIndex+3, y1, menuItems[menuIndex]);
    fprintf(stdout, "\e[%d;%dH", menuIndex+3, y2);
    fflush(stdout);
}

void doEsc()
{
    /*
    setScreenColorsI(COLOR_WINDOW);
    refreshView();
    fflush(stdout);
    */
    endme = 1;
}

void doUpDown(int step)
{
    clearSelection(curMenu->box[1]+1, mSelect, curMenu->menuItems);
    mSelect += step;
    if(mSelect < 0) mSelect = curMenu->menuItemCount-1;
    else if(mSelect >= curMenu->menuItemCount) mSelect = 0;
    highlightSelection(curMenu->box[1]+1, curMenu->box[3]-1, mSelect, curMenu->menuItems);
}

void doRightLeft(int step)
{
    menuIndex += step;
    if(menuIndex < 0) menuIndex = totalMainMenus-1;
    else if(menuIndex == totalMainMenus) menuIndex = 0;
    refreshView();
}

/***********************************************************************
 * This procedure shows the requested menu under the main menu bar. 
 * It also takes control of the user input to navigate the menu
 * with the arrow keys and to select menu items with ENTER. Pressing 
 * right or left arrows navigate to next menu on the left and the right 
 * respectively.
 ***********************************************************************/
void showMenu(int index, char *open_file_name)
{
    char *ch;
    menuIndex = index;
    hideCursor();
    
loop:
    mSelect   = 0;
    endme     = 0;
    curMenu   = &mainMenu[menuIndex];
    drawMenuBox(curMenu);
    while(!endme) 
    {
        ch = getKey();
        switch(ch[0]) 
        {
            case('f'):                      // switch to File menu
                if(ALT)
                {
                    if(menuIndex == 0) { endme = 1; break; }
                    menuIndex = 0;
                    refreshView();
                    goto loop;
                }
                if(CTRL)
                {
                    if(GNU_DOS_LEVEL > 1)
                    {
                        doRightLeft(1);
                        goto loop;
                    }
                }
                break;
            case('e'):                      // switch to Edit menu
                if(ALT)
                {
                    if(menuIndex == 1) { endme = 1; break; }
                    menuIndex = 1;
                    refreshView();
                    goto loop;
                }
                break;
            case('o'):                      // switch to Options menu
                if(ALT)
                {
                    if(menuIndex == 2) { endme = 1; break; }
                    menuIndex = 2;
                    refreshView();
                    goto loop;
                }
                break;
            case('h'):                      // switch to Help menu
                if(ALT)
                {
                    if(menuIndex == 3) { endme = 1; break; }
                    menuIndex = 3;
                    refreshView();
                    goto loop;
                }
                break;
            case('g'):
                if(GNU_DOS_LEVEL < 3) break;
                if(!CTRL) break;
                doEsc();
                break;
            case(ESC_KEY):
                if(GNU_DOS_LEVEL > 2) break;
                doEsc();
                break;
            case('p'):
                if(GNU_DOS_LEVEL < 2) break;
                if(!CTRL) break;
                doUpDown(-1);
                break;
            case(UP_KEY):
                if(GNU_DOS_LEVEL > 1) break;
                doUpDown(-1);
                break;
            case('n'):
                if(GNU_DOS_LEVEL < 2) break;
                if(!CTRL) break;
                doUpDown(1);
                break;
            case(DOWN_KEY):
                if(GNU_DOS_LEVEL > 1) break;
                doUpDown(1);
                break;
            case(RIGHT_KEY):
                if(GNU_DOS_LEVEL > 1) break;
                doRightLeft(1);
                goto loop;
                break;
            case('b'):
                if(GNU_DOS_LEVEL < 2) break;
                if(!CTRL) break;
                doRightLeft(-1);
                goto loop;
                break;
            case(LEFT_KEY):
                if(GNU_DOS_LEVEL > 1) break;
                doRightLeft(-1);
                goto loop;
                break;
            case(ENTER_KEY):
                showCursor();
                if(menuIndex == 0)      // File menu has special treatment
                {
                    curMenu->func[mSelect](open_file_name);
                }
                else
                {
                    curMenu->func[mSelect]();
                }
                endme = 1;
                break;
        }
    }

    setScreenColorsI(COLOR_WINDOW);
    refreshView();
    showCursor();
    fflush(stdout);
}
